/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.message.action;

import java.util.ArrayList;
import java.util.Date;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.message.MessageReferenceBeanInterface;
import jp.mosp.platform.bean.message.MessageRegistBeanInterface;
import jp.mosp.platform.dto.message.MessageDtoInterface;
import jp.mosp.platform.message.vo.MessageCardVo;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class MessageCardAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF4120";
    public static final String CMD_SELECT_SHOW = "PF4121";
    public static final String CMD_REGIST = "PF4125";
    public static final String CMD_DELETE = "PF4127";
    public static final String CMD_SET_ACTIVATION_DATE = "PF4170";
    public static final String CMD_INSERT_MODE = "PF4171";
    public static final String CMD_REPLICATION_MODE = "PF4174";
    public static final String CMD_SEND_MAIL = "PF4175";

    protected BaseVo getSpecificVo() {
        return new MessageCardVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.selectShow();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_REPLICATION_MODE)) {
            this.prepareVo();
            this.replicationMode();
        } else if (this.mospParams.getCommand().equals(CMD_SEND_MAIL)) {
            this.prepareVo();
            this.sendMail();
        }
    }

    protected void show() throws MospException {
        this.insertMode();
    }

    protected void selectShow() throws MospException {
        this.editMode();
    }

    protected void regist() throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        MessageRegistBeanInterface regist = platform.messageRegist();
        MessageDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageNewInsertSucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getMessageNo());
    }

    protected void update() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        MessageRegistBeanInterface regist = platform.messageRegist();
        MessageDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getMessageNo());
    }

    protected void delete() throws MospException {
        PlatformBeanHandlerInterface platform = this.platform();
        MessageRegistBeanInterface regist = platform.messageRegist();
        MessageDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.insertMode();
    }

    protected void setActivationDate() throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void insertMode() throws MospException {
        this.setEditInsertMode();
        this.setDefaultValues();
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode());
    }

    protected void setEditUpdateMode(String messageNo) throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        MessageReferenceBeanInterface reference = this.reference().message();
        MessageDtoInterface dto = reference.findForKey(messageNo);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        vo.setModeActivateDate("fixed");
        this.setPulldown();
        this.setEditUpdateMode(new ArrayList());
    }

    protected void replicationMode() {
        this.setEditReplicationMode();
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        vo.setLblMessageNo("");
    }

    protected void sendMail() throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        String messageNo = vo.getLblMessageNo();
        int count = this.reference().messageMail().send(messageNo);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.addSendMailMessage(count);
    }

    protected void setPulldown() throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltWorkPlace(this.getInputActivateDatePulldown());
            vo.setAryPltEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltSection(this.getInputActivateDatePulldown());
            vo.setAryPltPosition(this.getInputActivateDatePulldown());
            return;
        }
        Date date = this.getEditActivateDate();
        vo.setAryPltWorkPlace(this.reference().workPlace().getCodedSelectArray(date, true, null));
        vo.setAryPltEmployment(this.reference().employmentContract().getCodedSelectArray(date, true, null));
        vo.setAryPltSection(this.reference().section().getCodedSelectArray(date, true, null));
        vo.setAryPltPosition(this.reference().position().getCodedSelectArray(date, true, null));
    }

    public void setDefaultValues() {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        vo.setTxtEndYear("");
        vo.setTxtEndMonth("");
        vo.setTxtEndDay("");
        vo.setPltMessageType("");
        vo.setPltImportance("");
        vo.setPltWorkPlace("");
        vo.setPltEmployment("");
        vo.setPltSection("");
        vo.setPltPosition("");
        vo.setTxtEmployeeCode("");
        vo.setTxtMessageTitle("");
        vo.setTxtMessage("");
        vo.setLblMessageNo("");
        vo.setLblRegistUser("");
        vo.setLblEmployeeName("");
        vo.setRadApplicationType("0");
    }

    protected void setDtoFields(MessageDtoInterface dto) throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        dto.setPftMessageId(vo.getRecordId());
        dto.setMessageNo(vo.getLblMessageNo());
        dto.setStartDate(this.getEditActivateDate());
        dto.setEndDate(this.getDate(vo.getTxtEndYear(), vo.getTxtEndMonth(), vo.getTxtEndDay()));
        dto.setMessageType(this.getInt(vo.getPltMessageType()));
        dto.setMessageImportance(this.getInt(vo.getPltImportance()));
        dto.setMessageTitle(vo.getTxtMessageTitle());
        dto.setMessageBody(vo.getTxtMessage());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
        dto.setApplicationType(this.getInt(vo.getRadApplicationType()));
        if (vo.getRadApplicationType().equals("0")) {
            dto.setWorkPlaceCode(vo.getPltWorkPlace());
            dto.setEmploymentContractCode(vo.getPltEmployment());
            dto.setSectionCode(vo.getPltSection());
            dto.setPositionCode(vo.getPltPosition());
            dto.setPersonalId("");
        } else {
            dto.setWorkPlaceCode("");
            dto.setEmploymentContractCode("");
            dto.setSectionCode("");
            dto.setPositionCode("");
            dto.setPersonalId(this.reference().human().getPersonalIds(vo.getTxtEmployeeCode(), this.getEditActivateDate()));
        }
    }

    protected void setVoFields(MessageDtoInterface dto) throws MospException {
        MessageCardVo vo = (MessageCardVo)this.mospParams.getVo();
        HumanReferenceBeanInterface human = this.reference().human();
        vo.setRecordId(dto.getPftMessageId());
        vo.setLblMessageNo(dto.getMessageNo());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getStartDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getStartDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getStartDate()));
        vo.setTxtEndYear(this.getStringYear(dto.getEndDate()));
        vo.setTxtEndMonth(this.getStringMonth(dto.getEndDate()));
        vo.setTxtEndDay(this.getStringDay(dto.getEndDate()));
        vo.setPltMessageType(String.valueOf(dto.getMessageType()));
        vo.setPltImportance(String.valueOf(dto.getMessageImportance()));
        vo.setTxtMessageTitle(dto.getMessageTitle());
        vo.setTxtMessage(dto.getMessageBody());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
        vo.setRadApplicationType(String.valueOf(dto.getApplicationType()));
        vo.setPltWorkPlace(dto.getWorkPlaceCode());
        vo.setPltEmployment(dto.getEmploymentContractCode());
        vo.setPltSection(dto.getSectionCode());
        vo.setPltPosition(dto.getPositionCode());
        vo.setTxtEmployeeCode(human.getEmployeeCodes(dto.getPersonalId(), dto.getStartDate()));
        vo.setLblEmployeeName(human.getHumanNames(dto.getPersonalId(), dto.getStartDate()));
        vo.setLblRegistUser(this.getInsertUserName((BaseDtoInterface)dto));
    }

    protected void addSendMailMessage(int count) {
        StringBuilder sb = new StringBuilder(NameUtility.count((MospParams)this.mospParams, (int)count));
        sb.append(PfNameUtility.sendMail((MospParams)this.mospParams));
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)sb.toString());
    }
}

