/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.utils;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.BinaryUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanNormalDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class HumanUtility {
    private HumanUtility() {
    }

    public static int getHumanTargetIndex(HumanDtoInterface dto, List<HumanDtoInterface> list) throws MospException {
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (dto.getPfmHumanId() != list.get(i).getPfmHumanId()) continue;
            index = i;
        }
        return index;
    }

    public static String getDuration(int amountMonth, MospParams mospParams) {
        int countYear = amountMonth / 12;
        int countMonth = amountMonth % 12;
        if (countYear < 0) {
            countYear = 0;
        }
        if (countMonth < 0) {
            countMonth = 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(countYear).append(PfNameUtility.year((MospParams)mospParams));
        sb.append(countMonth).append(PfNameUtility.amountMonth((MospParams)mospParams));
        return sb.toString();
    }

    public static String getHumanOlder(Date birthDate, Date targetDate, MospParams mospParams) {
        if (MospUtility.isEmpty((Object[])new Object[]{birthDate, targetDate})) {
            return "";
        }
        int amountMonth = DateUtility.getMonthDifference((Date)birthDate, (Date)targetDate);
        StringBuilder sb = new StringBuilder();
        sb.append(amountMonth / 12).append(PfNameUtility.yearsOld((MospParams)mospParams));
        return PfNameUtility.parentheses((MospParams)mospParams, (String)sb.toString());
    }

    public static String getWorkPlaceStayMonths(HumanDtoInterface dto, List<HumanDtoInterface> humanList, Date targetDate, WorkPlaceDtoInterface workPlaceDto, RetirementDtoInterface retirementDto, MospParams mospParams) throws MospException {
        HumanDtoInterface firstDto;
        if (workPlaceDto == null || dto.getWorkPlaceCode().isEmpty()) {
            return "";
        }
        String workPlaceCode = dto.getWorkPlaceCode();
        int index = HumanUtility.getHumanTargetIndex((HumanDtoInterface)dto, humanList);
        Date firstDate = dto.getActivateDate();
        for (int i = index - 1; i >= 0 && (firstDto = humanList.get(i)).getWorkPlaceCode().equals(workPlaceCode); --i) {
            firstDate = firstDto.getActivateDate();
        }
        return HumanUtility.getDurationName((String)workPlaceDto.getWorkPlaceName(), (Date)targetDate, (Date)firstDate, (RetirementDtoInterface)retirementDto, (MospParams)mospParams);
    }

    public static String getSectionStayMonths(HumanDtoInterface dto, List<HumanDtoInterface> humanList, Date targetDate, SectionDtoInterface sectionDto, RetirementDtoInterface retirementDto, MospParams mospParams) throws MospException {
        HumanDtoInterface firstDto;
        if (sectionDto == null || dto.getSectionCode().isEmpty()) {
            return "";
        }
        String sectionCode = dto.getSectionCode();
        if (sectionCode.isEmpty()) {
            return "";
        }
        int index = HumanUtility.getHumanTargetIndex((HumanDtoInterface)dto, humanList);
        Date firstDate = dto.getActivateDate();
        for (int i = index; i >= 0 && (firstDto = humanList.get(i)).getSectionCode().equals(sectionCode); --i) {
            firstDate = firstDto.getActivateDate();
        }
        return HumanUtility.getDurationName((String)sectionDto.getSectionName(), (Date)targetDate, (Date)firstDate, (RetirementDtoInterface)retirementDto, (MospParams)mospParams);
    }

    public static String getPositionStayMonths(HumanDtoInterface dto, List<HumanDtoInterface> humanList, Date targetDate, PositionDtoInterface positionDto, RetirementDtoInterface retirementDto, MospParams mospParams) throws MospException {
        HumanDtoInterface firstDto;
        if (positionDto == null || dto.getPositionCode().isEmpty()) {
            return "";
        }
        String positionCode = dto.getPositionCode();
        if (positionCode.isEmpty()) {
            return "";
        }
        int index = HumanUtility.getHumanTargetIndex((HumanDtoInterface)dto, humanList);
        Date firstDate = dto.getActivateDate();
        for (int i = index; i >= 0 && (firstDto = humanList.get(i)).getPositionCode().equals(positionCode); --i) {
            firstDate = firstDto.getActivateDate();
        }
        return HumanUtility.getDurationName((String)positionDto.getPositionName(), (Date)targetDate, (Date)firstDate, (RetirementDtoInterface)retirementDto, (MospParams)mospParams);
    }

    public static String getEmploymentStayMonths(HumanDtoInterface dto, List<HumanDtoInterface> humanList, Date targetDate, EmploymentContractDtoInterface employmentContractDto, RetirementDtoInterface retirementDto, MospParams mospParams) throws MospException {
        HumanDtoInterface firstDto;
        if (employmentContractDto == null || dto.getEmploymentContractCode().isEmpty()) {
            return "";
        }
        String employmentCode = dto.getEmploymentContractCode();
        int index = HumanUtility.getHumanTargetIndex((HumanDtoInterface)dto, humanList);
        Date firstDate = dto.getActivateDate();
        for (int i = index; i >= 0 && (firstDto = humanList.get(i)).getEmploymentContractCode().equals(employmentCode); --i) {
            firstDate = firstDto.getActivateDate();
        }
        return HumanUtility.getDurationName((String)employmentContractDto.getEmploymentContractName(), (Date)targetDate, (Date)firstDate, (RetirementDtoInterface)retirementDto, (MospParams)mospParams);
    }

    public static String getPostStayMonths(HumanDtoInterface dto, List<HumanDtoInterface> humanList, Date targetDate, List<HumanHistoryDtoInterface> postList, HumanHistoryDtoInterface postDto, RetirementDtoInterface retirementDto, MospParams mospParams, String name) throws MospException {
        HumanHistoryDtoInterface targetPostDto;
        HumanDtoInterface firstDto;
        int postIndex;
        if (postDto == null || postList.isEmpty()) {
            return "";
        }
        String postCode = postDto.getHumanItemValue();
        int index = HumanUtility.getHumanTargetIndex((HumanDtoInterface)dto, humanList);
        Date firstDate = dto.getActivateDate();
        for (int i = index - 1; i >= 0 && (postIndex = HumanUtility.getTargetIndexPost(postList, (Date)(firstDto = humanList.get(i)).getActivateDate())) != -1 && (targetPostDto = postList.get(postIndex)).getHumanItemValue().equals(postCode); --i) {
            firstDate = firstDto.getActivateDate();
        }
        return HumanUtility.getDurationName((String)name, (Date)targetDate, (Date)firstDate, (RetirementDtoInterface)retirementDto, (MospParams)mospParams);
    }

    public static int getTargetIndexPost(List<HumanHistoryDtoInterface> postList, Date activeDate) throws MospException {
        int postIndex = -1;
        for (int i = 0; i < postList.size(); ++i) {
            HumanHistoryDtoInterface dto = postList.get(i);
            if (!dto.getActivateDate().equals(activeDate)) continue;
            return i;
        }
        return postIndex;
    }

    public static String getContinuationMonthName(Date showDate, Date targetDate, RetirementDtoInterface retirementDto, MospParams mospParams) throws MospException {
        Date lastDate = showDate;
        if (retirementDto != null && lastDate.compareTo(retirementDto.getRetirementDate()) > 0) {
            lastDate = retirementDto.getRetirementDate();
        }
        int amountMonth = DateUtility.getMonthDifference((Date)targetDate, (Date)lastDate);
        return HumanUtility.getDuration((int)amountMonth, (MospParams)mospParams);
    }

    public static String getDurationName(String name, Date showDate, Date targetDate, RetirementDtoInterface retirementDto, MospParams mospParams) throws MospException {
        StringBuffer sb = new StringBuffer(name);
        sb.append(PfNameUtility.parentheses((MospParams)mospParams, (String)HumanUtility.getContinuationMonthName((Date)showDate, (Date)targetDate, (RetirementDtoInterface)retirementDto, (MospParams)mospParams)));
        return sb.toString();
    }

    public static String getBinaryFileType(String fileName) {
        if (BinaryUtility.isExtensionGif((String)fileName)) {
            return "0";
        }
        if (BinaryUtility.isExtensionPng((String)fileName)) {
            return "2";
        }
        if (BinaryUtility.isExtensionJpg((String)fileName)) {
            return "1";
        }
        return "3";
    }

    public static boolean isSuspension(Collection<SuspensionDtoInterface> suspensions, Date targetDate) {
        return !MospUtility.isEmpty((Object[])new Object[]{HumanUtility.getSuspension(suspensions, (Date)targetDate)});
    }

    public static String getSuspensionReason(Collection<SuspensionDtoInterface> suspensions, Date targetDate) {
        SuspensionDtoInterface dto = HumanUtility.getSuspension(suspensions, (Date)targetDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        return dto.getSuspensionReason();
    }

    protected static SuspensionDtoInterface getSuspension(Collection<SuspensionDtoInterface> suspensions, Date targetDate) {
        if (MospUtility.isEmpty(suspensions)) {
            return null;
        }
        for (SuspensionDtoInterface suspensionDto : suspensions) {
            Date startDate = suspensionDto.getStartDate();
            Date endDate = suspensionDto.getEndDate();
            if (endDate == null) {
                endDate = suspensionDto.getScheduleEndDate();
            }
            if (!DateUtility.isTermContain((Date)targetDate, (Date)startDate, (Date)endDate)) continue;
            return suspensionDto;
        }
        return null;
    }

    public static Date getRetireDate(RetirementDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return null;
        }
        return dto.getRetirementDate();
    }

    public static boolean isRetired(RetirementDtoInterface dto, Date targetDate) {
        return HumanUtility.isRetired((Date)HumanUtility.getRetireDate((RetirementDtoInterface)dto), (Date)targetDate);
    }

    public static boolean isRetired(Date retireDate, Date targetDate) {
        if (MospUtility.isEmpty((Object[])new Object[]{retireDate, targetDate})) {
            return false;
        }
        return targetDate.compareTo(retireDate) > 0;
    }

    public static String getHumanItemValue(HumanNormalDtoInterface dto) {
        return MospUtility.isEmpty((Object[])new Object[]{dto}) ? "" : dto.getHumanItemValue();
    }
}

