/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.comparator.IndexComparator;
import jp.mosp.framework.property.CodeItemProperty;
import jp.mosp.framework.property.CodeProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.human.base.PlatformHumanVo;
import jp.mosp.platform.utils.PfMessageUtility;

public abstract class PlatformHumanAction
extends PlatformAction {
    public static final String PATH_PLATFORM_HUMAN_JS = "/pub/platform/human/js/platformHuman.js";
    public static final String PATH_PLATFORM_HUMAN_CSS = "/pub/platform/human/css/platformHuman.css";

    protected void addBaseJsCssFiles() {
        super.addBaseJsCssFiles();
        this.mospParams.addJsFile(PATH_PLATFORM_HUMAN_JS);
        this.mospParams.addCssFile(PATH_PLATFORM_HUMAN_CSS);
    }

    protected void setPlatformHumanSettings(String searchCmd, String modeHumanLayout) {
        PlatformHumanVo vo = (PlatformHumanVo)this.mospParams.getVo();
        vo.setCmdSaerch(searchCmd);
        vo.setModeHumanLayout(modeHumanLayout);
    }

    protected void setTargetHumanCommonInfo() throws MospException {
        PlatformHumanVo vo = (PlatformHumanVo)this.mospParams.getVo();
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getTargetDate();
        this.setHumanCommonInfo(personalId, targetDate);
        vo.setJsIsReferenceDivision(RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams).contains(this.getTransferredType()));
    }

    protected void setHumanCommonInfoForEmployeeCode(String employeeCode, Date targetDate) throws MospException {
        HumanDtoInterface dto = this.reference().human().getHumanInfoForEmployeeCode(employeeCode, targetDate);
        this.setHumanCommonInfo(dto, targetDate);
    }

    protected void setHumanCommonInfo(String personalId, Date targetDate) throws MospException {
        HumanDtoInterface dto = this.reference().human().getHumanInfo(personalId, targetDate);
        this.setHumanCommonInfo(dto, targetDate);
    }

    protected void setHumanCommonInfo(HumanDtoInterface dto, Date targetDate) throws MospException {
        PlatformHumanVo vo = (PlatformHumanVo)this.mospParams.getVo();
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            PfMessageUtility.addErrorEmployeeNotExist((MospParams)this.mospParams);
        }
        String employeeCode = dto.getEmployeeCode();
        if (!this.mospParams.hasErrorMessage() && this.isNotEmployeeReferable(employeeCode, targetDate)) {
            PfMessageUtility.addErrorNoAuthorityToRefer((MospParams)this.mospParams, (Date)targetDate, (String)employeeCode);
        }
        if (this.mospParams.hasErrorMessage()) {
            if (MospUtility.isEmpty((String[])new String[]{vo.getEmployeeCode()})) {
                this.mospParams.setNextCommand("PF0040");
            }
            throw new MospException("FWW0101");
        }
        vo.setEmployeeCode(employeeCode);
        vo.setTargetDate(targetDate);
        vo.setPersonalId(dto.getPersonalId());
        vo.setLblEmployeeName(MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName()));
        vo.setTxtSearchActivateYear(String.valueOf(DateUtility.getYear((Date)targetDate)));
        vo.setTxtSearchActivateMonth(String.valueOf(DateUtility.getMonth((Date)targetDate)));
        vo.setTxtSearchActivateDay(String.valueOf(DateUtility.getDay((Date)targetDate)));
        vo.setTxtSearchEmployeeCode("");
        this.setRollEmployee();
    }

    protected boolean isNotEmployeeReferable(String employeeCode, Date targetDate) throws MospException {
        HumanSearchBeanInterface humanSearch = this.reference().humanSearch();
        humanSearch.setTargetDate(targetDate);
        humanSearch.setEmployeeCode(employeeCode);
        humanSearch.setEmployeeCodeType("exact");
        humanSearch.setOperationType("1");
        List list = humanSearch.search();
        return list.isEmpty();
    }

    protected void setRollEmployee() throws MospException {
        PlatformHumanVo vo = (PlatformHumanVo)this.mospParams.getVo();
        vo.setLblNextEmployeeCode("");
        vo.setLblBackEmployeeCode("");
        HumanSearchBeanInterface humanSearch = this.reference().humanSearch();
        humanSearch.setTargetDate(vo.getTargetDate());
        humanSearch.setOperationType("1");
        List list = humanSearch.search();
        for (int i = 0; i < list.size(); ++i) {
            HumanDtoInterface dto = (HumanDtoInterface)list.get(i);
            if (!dto.getEmployeeCode().equals(vo.getEmployeeCode())) continue;
            if (i + 1 < list.size()) {
                vo.setLblNextEmployeeCode(((HumanDtoInterface)list.get(i + 1)).getEmployeeCode());
                vo.setNextPersonalId(((HumanDtoInterface)list.get(i + 1)).getPersonalId());
            }
            if (i <= 0) break;
            vo.setLblBackEmployeeCode(((HumanDtoInterface)list.get(i - 1)).getEmployeeCode());
            vo.setBackPersonalId(((HumanDtoInterface)list.get(i - 1)).getPersonalId());
            break;
        }
    }

    protected String getSearchEmployeeCode() {
        return this.mospParams.getRequestParam("txtSearchEmployeeCode");
    }

    protected Date getSearchTargetDate() {
        String year = this.mospParams.getRequestParam("txtSearchActivateYear");
        String month = this.mospParams.getRequestParam("txtSearchActivateMonth");
        String day = this.mospParams.getRequestParam("txtSearchActivateDay");
        return this.getDate(year, month, day);
    }

    protected void searchHumanCommonInfo() throws MospException {
        PlatformHumanVo vo = (PlatformHumanVo)this.mospParams.getVo();
        String searchMode = this.getTransferredSearchMode();
        if ("searchBack".equals(searchMode)) {
            this.setHumanCommonInfo(vo.getBackPersonalId(), vo.getTargetDate());
        } else if ("searchNext".equals(searchMode)) {
            this.setHumanCommonInfo(vo.getNextPersonalId(), vo.getTargetDate());
        } else if ("searchEmployeeCode".equals(searchMode)) {
            this.setHumanCommonInfoForEmployeeCode(this.getSearchEmployeeCode(), vo.getTargetDate());
        } else if ("searchTargetDate".equals(searchMode)) {
            this.setHumanCommonInfo(vo.getPersonalId(), this.getSearchTargetDate());
        }
    }

    protected String getTransferredSearchMode() {
        return this.mospParams.getRequestParam("transferSearch");
    }

    protected String[][] getCodeArrayForHumanGeneral(String codeKey, boolean needBlank) {
        String[][] array;
        CodeProperty codeProperty = (CodeProperty)this.mospParams.getCodeProperty().get(codeKey);
        if (codeProperty == null) {
            return new String[0][0];
        }
        ArrayList list = new ArrayList(codeProperty.getCodeItemMap().values());
        Collections.sort(list, new IndexComparator());
        for (int i = list.size() - 1; i >= 0; --i) {
            CodeItemProperty codeItemProperty = (CodeItemProperty)list.get(i);
            if (codeItemProperty.getViewFlag() == 1) {
                list.remove(i);
            }
            if (!RoleUtility.getHiddenDivisionsList((MospParams)this.mospParams).contains(codeItemProperty.getKey())) continue;
            list.remove(i);
        }
        int idx = 0;
        if (needBlank) {
            array = new String[list.size() + 1][2];
            array[0][0] = "";
            array[0][1] = "";
            ++idx;
        } else {
            array = new String[list.size()][2];
        }
        for (CodeItemProperty codeItemProperty : list) {
            array[idx][0] = codeItemProperty.getKey();
            array[idx][1] = codeItemProperty.getItemName();
            ++idx;
        }
        return array;
    }
}

