/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.RetirementRegistBeanInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.RetirementCardVo;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class RetirementCardAction
extends PlatformHumanAction {
    public static final String CMD_SELECT = "PF1171";
    public static final String CMD_SEARCH = "PF1172";
    public static final String CMD_TRANSFER = "PF1176";
    public static final String CMD_UPDATE = "PF1178";
    public static final String CMD_DELETE = "PF1179";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new RetirementCardVo();
    }

    protected void select() throws MospException {
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.setRetirementInfo();
        this.setPulldown();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.setRetirementInfo();
    }

    protected void transfer() {
        RetirementCardVo vo = (RetirementCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void regist() throws MospException {
        this.validate();
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        RetirementRegistBeanInterface regist = this.platform().retirementRegist();
        RetirementDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.regist(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        this.setRetirementInfo();
    }

    protected void delete() throws MospException {
        RetirementRegistBeanInterface regist = this.platform().retirementRegist();
        RetirementDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.setDefaultValues();
    }

    protected void setRetirementInfo() throws MospException {
        RetirementCardVo vo = (RetirementCardVo)this.mospParams.getVo();
        this.setVoFields(this.reference().retirement().getRetireInfo(vo.getPersonalId()));
    }

    protected void setPulldown() {
        RetirementCardVo vo = (RetirementCardVo)this.mospParams.getVo();
        vo.setAryPltRetirementReason(this.mospParams.getProperties().getCodeArray("Retirement", false));
    }

    public void setDefaultValues() {
        RetirementCardVo vo = (RetirementCardVo)this.mospParams.getVo();
        vo.setRecordId(0L);
        vo.setTxtRetirementDetail("");
        vo.setTxtRetirementYear("");
        vo.setTxtRetirementMonth("");
        vo.setTxtRetirementDay("");
        vo.setPltRetirementReason("");
    }

    public void setVoFields(RetirementDtoInterface dto) {
        if (dto == null) {
            return;
        }
        RetirementCardVo vo = (RetirementCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfaHumanRetirementId());
        vo.setPersonalId(dto.getPersonalId());
        vo.setPltRetirementReason(dto.getRetirementReason());
        vo.setTxtRetirementYear(this.getStringYear(dto.getRetirementDate()));
        vo.setTxtRetirementMonth(this.getStringMonth(dto.getRetirementDate()));
        vo.setTxtRetirementDay(this.getStringDay(dto.getRetirementDate()));
        vo.setTxtRetirementDetail(dto.getRetirementDetail());
    }

    protected void setDtoFields(RetirementDtoInterface dto) {
        RetirementCardVo vo = (RetirementCardVo)this.mospParams.getVo();
        dto.setPfaHumanRetirementId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setRetirementDate(this.getRetirementDate());
        dto.setRetirementDetail(vo.getTxtRetirementDetail());
        dto.setRetirementReason(vo.getPltRetirementReason());
    }

    protected Date getRetirementDate() {
        RetirementCardVo vo = (RetirementCardVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtRetirementYear(), vo.getTxtRetirementMonth(), vo.getTxtRetirementDay());
    }

    public void validate() {
        RetirementCardVo vo = (RetirementCardVo)this.mospParams.getVo();
        String yearName = PfNameUtility.year((MospParams)this.mospParams);
        String monthName = PfNameUtility.month((MospParams)this.mospParams);
        String dayName = PfNameUtility.day((MospParams)this.mospParams);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getTxtRetirementYear(), (String)yearName);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getTxtRetirementMonth(), (String)monthName);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getTxtRetirementDay(), (String)dayName);
        InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getTxtRetirementYear(), (String)yearName);
        InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getTxtRetirementMonth(), (String)monthName);
        InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getTxtRetirementDay(), (String)dayName);
        InputCheckUtility.checkDate((MospParams)this.mospParams, (String)vo.getTxtRetirementYear(), (String)vo.getTxtRetirementMonth(), (String)vo.getTxtRetirementDay(), (String)PfNameUtility.retirementDate((MospParams)this.mospParams));
    }
}

