/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.dto.human.HumanListDtoInterface;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.HumanListVo;
import jp.mosp.platform.utils.PfMessageUtility;

public class HumanListAction
extends PlatformHumanAction {
    public static final String CMD_SHOW = "PF1110";
    public static final String CMD_SET_ACTIVATION_DATE = "PF1111";
    public static final String CMD_SEARCH = "PF1112";
    public static final String CMD_RE_SEARCH = "PF1113";
    public static final String CMD_SORT = "PF1114";
    public static final String CMD_PAGE = "PF1115";
    public static final String CMD_TRANSFER = "PF1116";

    public HumanListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new HumanListVo();
    }

    protected void show() throws MospException {
        HumanListVo vo = (HumanListVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setModeActivateDate("fixed");
        vo.setModeSearchExpansion("");
        this.setPulldown();
        this.setList(new ArrayList());
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
    }

    protected void setActivationDate() throws MospException {
        HumanListVo vo = (HumanListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
        this.setList(new ArrayList());
        vo.setList(new ArrayList());
    }

    protected void search() throws MospException {
        HumanListVo vo = (HumanListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            PfMessageUtility.addErrorActivateDateNotSettled((MospParams)this.mospParams);
            return;
        }
        HumanSearchBeanInterface humanSearch = this.reference().humanSearch();
        this.checkSearchCondition(new String[]{vo.getTxtEmployeeCode(), vo.getTxtLastName(), vo.getPltWorkPlaceAbbr(), vo.getPltEmploymentName(), vo.getPltSectionAbbr(), vo.getPltPositionName(), vo.getPltState(), vo.getTxtFirstName(), vo.getTxtLastKana(), vo.getTxtFirstKana(), vo.getTxtSearchWord()});
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        humanSearch.setTargetDate(this.getActivateDate());
        humanSearch.setEmployeeCode(vo.getTxtEmployeeCode());
        humanSearch.setLastName(vo.getTxtLastName());
        humanSearch.setWorkPlaceCode(vo.getPltWorkPlaceAbbr());
        humanSearch.setSectionCode(vo.getPltSectionAbbr());
        humanSearch.setPositionCode(vo.getPltPositionName());
        humanSearch.setEmploymentContractCode(vo.getPltEmploymentName());
        humanSearch.setFirstName(vo.getTxtFirstName());
        humanSearch.setLastKana(vo.getTxtLastKana());
        humanSearch.setLastKanaType(vo.getPltLastKana());
        humanSearch.setFirstKana(vo.getTxtFirstKana());
        humanSearch.setStateType(vo.getPltState());
        humanSearch.setInformationType(vo.getPltInfoType());
        humanSearch.setSearchWord(vo.getTxtSearchWord());
        humanSearch.setEmployeeCodeType(vo.getPltEmployeeCode());
        humanSearch.setFirstKanaType(vo.getPltFirstKana());
        humanSearch.setFirstNameType(vo.getPltFirstName());
        humanSearch.setLastNameType(vo.getPltLastName());
        humanSearch.setNeedLowerSection(true);
        humanSearch.setNeedConcurrent(true);
        humanSearch.setOperationType("1");
        List list = humanSearch.getHumanList();
        vo.setList(list);
        vo.setComparatorName(EmployeeCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.size() == 0) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
            return;
        }
        vo.setActivateDate(this.getActivateDate());
    }

    protected void sort() throws MospException {
        this.setList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setList(this.pageList());
    }

    protected void transfer() {
        HumanListVo vo = (HumanListVo)this.mospParams.getVo();
        this.setTargetPersonalId(vo.getAryPersonalId(this.getTransferredIndex()));
        this.setTargetDate(vo.getActivateDate());
        this.mospParams.setNextCommand("PF1121");
    }

    protected void setDefaultValues() {
        HumanListVo vo = (HumanListVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        vo.setTxtActivateYear(this.getStringYear(date));
        vo.setTxtActivateMonth(this.getStringMonth(date));
        vo.setTxtActivateDay(this.getStringDay(date));
        vo.setPltEmployeeCode("broad");
        vo.setPltLastKana("broad");
        vo.setPltLastName("broad");
        vo.setPltFirstKana("broad");
        vo.setPltFirstName("broad");
        vo.setPltState("presence");
        vo.setJsSearchConditionRequired(this.isSearchConditionRequired());
    }

    protected void setList(List<? extends BaseDtoInterface> humanList) {
        HumanListVo vo = (HumanListVo)this.mospParams.getVo();
        String[] aryEmployeeCode = new String[humanList.size()];
        String[] aryEmployeeName = new String[humanList.size()];
        String[] aryEmployeeKana = new String[humanList.size()];
        String[] aryWorkPlaceAbbr = new String[humanList.size()];
        String[] arySection = new String[humanList.size()];
        String[] aryPositionAbbr = new String[humanList.size()];
        String[] aryEmploymentAbbr = new String[humanList.size()];
        String[] aryState = new String[humanList.size()];
        String[] aryPersonalId = new String[humanList.size()];
        for (int i = 0; i < humanList.size(); ++i) {
            HumanListDtoInterface humanDto = (HumanListDtoInterface)humanList.get(i);
            aryEmployeeCode[i] = humanDto.getEmployeeCode();
            aryEmployeeName[i] = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
            aryEmployeeKana[i] = MospUtility.getHumansName((String)humanDto.getFirstKana(), (String)humanDto.getLastKana());
            aryWorkPlaceAbbr[i] = humanDto.getWorkPlaceAbbr();
            arySection[i] = humanDto.getSectionName();
            aryPositionAbbr[i] = humanDto.getPositionAbbr();
            aryEmploymentAbbr[i] = humanDto.getEmploymentContractAbbr();
            aryState[i] = humanDto.getRetireState();
            aryPersonalId[i] = humanDto.getPersonalId();
        }
        vo.setAryEmployeeCode(aryEmployeeCode);
        vo.setAryEmployeeName(aryEmployeeName);
        vo.setAryEmployeeKana(aryEmployeeKana);
        vo.setAryWorkPlaceAbbr(aryWorkPlaceAbbr);
        vo.setArySection(arySection);
        vo.setAryPositionAbbr(aryPositionAbbr);
        vo.setAryEmploymentAbbr(aryEmploymentAbbr);
        vo.setAryState(aryState);
        vo.setAryPersonalId(aryPersonalId);
    }

    protected Date getActivateDate() {
        HumanListVo vo = (HumanListVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
    }

    protected void setPulldown() throws MospException {
        HumanListVo vo = (HumanListVo)this.mospParams.getVo();
        vo.setAryPltWorkPlace(this.getInputActivateDatePulldown());
        vo.setAryPltEmployment(this.getInputActivateDatePulldown());
        vo.setAryPltSectionAbbr(this.getInputActivateDatePulldown());
        vo.setAryPltPosition(this.getInputActivateDatePulldown());
        Date targetDate = this.getActivateDate();
        if (this.mospParams.hasErrorMessage()) {
            vo.setModeActivateDate("chaning");
        }
        if (vo.getModeActivateDate().equals("chaning")) {
            return;
        }
        vo.setAryPltWorkPlace(this.reference().workPlace().getCodedAbbrSelectArray(targetDate, true, "1"));
        vo.setAryPltEmployment(this.reference().employmentContract().getCodedAbbrSelectArray(targetDate, true, "1"));
        vo.setAryPltSectionAbbr(this.reference().section().getCodedSelectArray(targetDate, true, "1"));
        vo.setAryPltPosition(this.reference().position().getCodedSelectArray(targetDate, true, "1"));
        vo.setAryPltFreeWordTypes(this.getCodeArrayForHumanGeneral("FreeWordType", false));
    }
}

