/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.io.InputStream;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.BinaryUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanBinaryNormalReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanBinaryNormalRegistBeanInterface;
import jp.mosp.platform.dto.human.HumanBinaryNormalDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.human.vo.HumanBinaryNormalCardVo;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class HumanBinaryNormalCardAction
extends PlatformHumanAction {
    public static final String CMD_SELECT = "PF1551";
    public static final String CMD_SEARCH = "PF1552";
    public static final String CMD_INSERT = "PF1555";
    public static final String CMD_UPDATE = "PF1556";
    public static final String CMD_DELETE = "PF1557";
    public static final String CMD_TRANSFER = "PF1559";
    public static final String KEY_VIEW_BINARY_NORMAL_CARD = "BinaryNormal";
    public static final String PRM_FILE_BINARY_NORMAL = "fileBinaryNormal";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT)) {
            this.prepareVo();
            this.insert();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.update();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new HumanBinaryNormalCardVo();
    }

    protected void select() throws MospException {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        StringBuilder name = new StringBuilder(NameUtility.getName((MospParams)this.mospParams, (String)vo.getDivision()));
        name.append(PfNameUtility.information((MospParams)this.mospParams));
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)name.toString());
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.setBinaryNormalInfo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.setBinaryNormalInfo();
    }

    protected void insert() throws MospException {
        HumanBinaryNormalRegistBeanInterface regist = this.platform().humanBinaryNormalRegist();
        HumanBinaryNormalDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        this.setBinaryNormalInfo();
    }

    protected void update() throws MospException {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        HumanBinaryNormalReferenceBeanInterface reference = this.reference().humanBinaryNormal();
        HumanBinaryNormalDtoInterface dto = reference.findForKey(vo.getHidRecordId(), false);
        dto.setFileName(vo.getFileBinaryNormal());
        dto.setFileRemark(vo.getTxtFileRemark());
        this.platform().humanBinaryNormalRegist().update(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        this.setBinaryNormalInfo();
    }

    private void setDtoFields(HumanBinaryNormalDtoInterface dto) throws MospException {
        byte[] file = BinaryUtility.getBinaryData((InputStream)this.mospParams.getRequestFile(PRM_FILE_BINARY_NORMAL));
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        dto.setPersonalId(vo.getPersonalId());
        dto.setHumanItemType(vo.getDivision());
        dto.setHumanItemBinary(file);
        dto.setFileType(HumanUtility.getBinaryFileType((String)vo.getFileBinaryNormal()));
        dto.setFileName(vo.getFileBinaryNormal());
        dto.setFileRemark(vo.getTxtFileRemark());
    }

    protected void delete() throws MospException {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        HumanBinaryNormalRegistBeanInterface regist = this.platform().humanBinaryNormalRegist();
        regist.delete(this.reference().humanBinaryNormal().findForKey(vo.getHidRecordId(), false));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.setDefaultValues();
        vo.setModeCardEdit("insert");
    }

    protected void transfer() {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setDefaultValues() {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        vo.setPltFileType("");
        vo.setFileBinaryNormal("");
        vo.setTxtFileRemark("");
        vo.setJsIsReferenceDivision(RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams).contains(this.getTransferredType()));
        this.setPulldown();
    }

    protected void setBinaryNormalInfo() throws MospException {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        String division = vo.getDivision();
        HumanBinaryNormalReferenceBeanInterface binaryNormalRefer = this.reference().humanBinaryNormal();
        HumanBinaryNormalDtoInterface dto = binaryNormalRefer.findForInfo(vo.getPersonalId(), division);
        if (dto == null) {
            this.setDefaultValues();
            vo.setModeCardEdit("insert");
            return;
        }
        this.setVoFields(dto);
        vo.setModeCardEdit("edit");
    }

    protected void setVoFields(HumanBinaryNormalDtoInterface dto) {
        if (dto == null) {
            this.setDefaultValues();
            return;
        }
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        vo.setHidRecordId(Long.valueOf(dto.getPfaHumanBinaryNormalId()));
        vo.setPltFileType(dto.getFileType());
        vo.setFileBinaryNormal(dto.getFileName());
        vo.setTxtFileRemark(dto.getFileRemark());
    }

    protected void setPulldown() {
        HumanBinaryNormalCardVo vo = (HumanBinaryNormalCardVo)this.mospParams.getVo();
        MospProperties properties = this.mospParams.getProperties();
        String[][] aryBinaryFileType = properties.getCodeArray("BinaryFileType", true);
        vo.setAryPltFileType(aryBinaryFileType);
    }
}

