/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanBinaryHistoryReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanBinaryHistoryDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.HumanBinaryHistoryListVo;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class HumanBinaryHistoryListAction
extends PlatformHumanAction {
    public static final String CMD_SEARCH = "PF1582";
    public static final String CMD_SELECT = "PF1586";
    public static final String CMD_RE_SEARCH = "PF1587";
    public static final String CMD_DELETE = "PF1588";
    public static final String CMD_TRANSFER = "PF1589";
    public static final String KEY_VIEW_BINARY_HISTORY_LIST = "BinaryListList";
    public static final String PRM_FILE_BINARY_NORMAL = "fileBinaryHistoryList";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.reSearch();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo(true, false);
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    public HumanBinaryHistoryListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new HumanBinaryHistoryListVo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.getHistoryList();
    }

    protected void select() throws MospException {
        HumanBinaryHistoryListVo vo = (HumanBinaryHistoryListVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        StringBuilder name = new StringBuilder(NameUtility.getName((MospParams)this.mospParams, (String)vo.getDivision()));
        name.append(PfNameUtility.list((MospParams)this.mospParams));
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)name.toString());
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.getHistoryList();
    }

    protected void reSearch() throws MospException {
        HumanBinaryHistoryListVo vo = (HumanBinaryHistoryListVo)this.mospParams.getVo();
        this.setHumanCommonInfo(vo.getPersonalId(), vo.getTargetDate());
        this.setDefaultValues();
        this.getHistoryList();
    }

    protected void delete() throws MospException {
        this.deleteHistoryBasicInfo();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.setDefaultValues();
        this.getHistoryList();
    }

    protected void deleteHistoryBasicInfo() throws MospException {
        HumanBinaryHistoryListVo vo = (HumanBinaryHistoryListVo)this.mospParams.getVo();
        Date activeDate = DateUtility.getDate((String)this.getTransferredActivateDate());
        Long recordId = (Long)vo.getHidRecordIdMap().get(activeDate);
        HumanBinaryHistoryDtoInterface dto = this.reference().humanBinaryHistory().findForKey(recordId, false);
        this.platform().humanBinaryHistoryRegist().delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.commit();
    }

    protected void transfer() {
        HumanBinaryHistoryListVo vo = (HumanBinaryHistoryListVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals("PF1576")) {
            this.mospParams.setNextCommand("PF1576");
        } else if (actionName.equals("PF1574")) {
            this.mospParams.setNextCommand("PF1574");
        } else if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setDefaultValues() {
        HumanBinaryHistoryListVo vo = (HumanBinaryHistoryListVo)this.mospParams.getVo();
        vo.setAryActiveteDate(new String[0]);
        vo.setAryFileType(new String[0]);
        vo.setAryPfaHumanBinaryHistoryId(new String[0]);
        vo.setAryFileName(new String[0]);
        vo.setAryFileRemark(new String[0]);
    }

    protected void getHistoryList() throws MospException {
        HumanBinaryHistoryReferenceBeanInterface humanBinaryReference;
        List list;
        HumanBinaryHistoryListVo vo = (HumanBinaryHistoryListVo)this.mospParams.getVo();
        String division = vo.getDivision();
        String personalId = vo.getPersonalId();
        if (personalId.isEmpty()) {
            personalId = this.reference().human().getPersonalId(vo.getEmployeeCode(), this.getSystemDate());
        }
        if ((list = (humanBinaryReference = this.reference().humanBinaryHistory()).findForHistory(personalId, division)).isEmpty()) {
            return;
        }
        boolean isLastHistory = false;
        if (list.size() == 1) {
            isLastHistory = true;
        }
        vo.setJsIsLastHistory(isLastHistory);
        String[] aryActiveteDate = new String[list.size()];
        String[] aryFileType = new String[list.size()];
        String[] aryFileName = new String[list.size()];
        String[] aryFileRemark = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            HumanBinaryHistoryDtoInterface dto = (HumanBinaryHistoryDtoInterface)list.get(list.size() - 1 - i);
            vo.setPersonalId(dto.getPersonalId());
            aryActiveteDate[i] = this.getStringDate(dto.getActivateDate());
            aryFileType[i] = dto.getFileType();
            aryFileName[i] = dto.getFileName();
            aryFileRemark[i] = dto.getFileRemark();
            vo.putHidRecordIdMap(dto.getActivateDate(), Long.valueOf(dto.getPfaHumanBinaryHistoryId()));
        }
        vo.setAryActiveteDate(aryActiveteDate);
        vo.setAryFileType(aryFileType);
        vo.setAryFileName(aryFileName);
        vo.setAryFileRemark(aryFileRemark);
    }
}

