/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.framework.utils.TopicPathUtility;
import jp.mosp.platform.bean.human.HumanArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanArrayRegistBeanInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.HumanArrayCardVo;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class HumanArrayCardAction
extends PlatformHumanAction {
    public static final String CMD_SET_ACTIVATION_DATE = "PF1521";
    public static final String CMD_SEARCH = "PF1522";
    public static final String CMD_ADD_SELECT = "PF1524";
    public static final String CMD_EDIT_SELECT = "PF1526";
    public static final String CMD_DELETE = "PF1527";
    public static final String CMD_UPDATE = "PF1528";
    public static final String CMD_TRANSFER = "PF1529";
    public static final String KEY_VIEW_ARRAY_CARD = "ArrayCard";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_SELECT)) {
            this.prepareVo(true, false);
            this.addSelect();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_SELECT)) {
            this.prepareVo(false, false);
            this.editSelect();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
        this.setCardCommonInfo();
    }

    protected void setActivationDate() throws MospException {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else if (vo.getModeActivateDate().equals("fixed")) {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
        String imageName = this.getTransferredCommand();
        this.mospParams.addGeneralParam(KEY_VIEW_ARRAY_CARD, (Object)imageName);
    }

    protected BaseVo getSpecificVo() {
        return new HumanArrayCardVo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
    }

    protected void addSelect() throws MospException {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        vo.setDivision(this.getTransferredType());
        StringBuilder name = new StringBuilder(NameUtility.getName((MospParams)this.mospParams, (String)vo.getDivision()));
        name.append(PfNameUtility.addInfo((MospParams)this.mospParams));
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)name.toString());
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.mospParams.addGeneralParam(KEY_VIEW_ARRAY_CARD, (Object)CMD_ADD_SELECT);
    }

    protected void regist() throws MospException {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        int rowId = vo.getRowId();
        this.mospParams.addGeneralParam("ArrayRowId", (Object)String.valueOf(rowId));
        String division = vo.getDivision();
        Date activeDate = DateUtility.getDate((String)vo.getTxtActivateYear(), (String)vo.getTxtActivateMonth(), (String)vo.getTxtActivateDay());
        this.validate();
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        HumanArrayRegistBeanInterface regist = this.platform().humanArrayRegist();
        regist.regist(division, KEY_VIEW_ARRAY_CARD, vo.getPersonalId(), activeDate, rowId, vo.getAryRecordIdMap());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        String newRowId = (String)this.mospParams.getGeneralParam("ArrayRowId");
        vo.setRowId(this.getInt(newRowId));
        this.getArrayItem(division, this.getInt(newRowId));
        vo.setModeCardEdit("edit");
    }

    protected void editSelect() throws MospException {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        String division = this.getTransferredType();
        vo.setDivision(division);
        int rowId = this.getInt(this.getTransferredCode());
        vo.setRowId(rowId);
        this.mospParams.addGeneralParam("ArrayRowId", (Object)this.getTransferredCode());
        StringBuilder name = new StringBuilder(NameUtility.getName((MospParams)this.mospParams, (String)division));
        name.append(PfNameUtility.editInfo((MospParams)this.mospParams));
        TopicPathUtility.setTopicPathName((MospParams)this.mospParams, (String)vo.getClassName(), (String)name.toString());
        this.setPlatformHumanSettings(CMD_SEARCH, "codeAndName");
        this.setTargetHumanCommonInfo();
        HumanArrayReferenceBeanInterface arrayRefere = this.reference().humanArray();
        this.getArrayItem(division, rowId);
        Date date = DateUtility.getDate((String)vo.getArrayItem(division, String.valueOf(rowId), "activeDate"));
        vo.setTxtActivateYear(DateUtility.getStringYear((Date)date));
        vo.setTxtActivateMonth(DateUtility.getStringMonth((Date)date));
        vo.setTxtActivateDay(DateUtility.getStringDay((Date)date));
        vo.putPltItem(arrayRefere.getHumanGeneralPulldown(vo.getDivision(), KEY_VIEW_ARRAY_CARD, date));
        vo.setModeActivateDate("fixed");
        vo.setModeCardEdit("edit");
        this.mospParams.addGeneralParam(KEY_VIEW_ARRAY_CARD, (Object)CMD_EDIT_SELECT);
        vo.setJsIsReferenceDivision(RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams).contains(this.getTransferredType()));
    }

    protected void delete() throws MospException {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        HumanArrayRegistBeanInterface regist = this.platform().humanArrayRegist();
        regist.delete(vo.getDivision(), KEY_VIEW_ARRAY_CARD, vo.getRowId(), vo.getAryRecordIdMap());
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        vo.getHumanArrayMap().clear();
        this.setDefaultValues();
    }

    protected void transfer() {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setDefaultValues() throws MospException {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        vo.setTxtActivateYear("");
        vo.setTxtActivateMonth("");
        vo.setTxtActivateDay("");
        vo.setModeActivateDate("chaning");
        vo.setModeCardEdit("add");
        vo.setJsIsReferenceDivision(RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams).contains(this.getTransferredType()));
        this.setPulldown();
    }

    protected void setPulldown() throws MospException {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        HumanArrayReferenceBeanInterface arrayRefere = this.reference().humanArray();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.putPltItem(arrayRefere.getInputActiveDateGeneralPulldown(vo.getDivision(), KEY_VIEW_ARRAY_CARD));
            return;
        }
        Date activeDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        vo.putPltItem(arrayRefere.getHumanGeneralPulldown(vo.getDivision(), KEY_VIEW_ARRAY_CARD, activeDate));
    }

    protected void validate() throws MospException {
    }

    public void setCardCommonInfo() {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        vo.setJsIsReferenceDivision(RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams).contains(this.getTransferredType()));
    }

    protected void getArrayItem(String division, int rowId) throws MospException {
        HumanArrayCardVo vo = (HumanArrayCardVo)this.mospParams.getVo();
        HumanArrayReferenceBeanInterface normalReference = this.reference().humanArray();
        normalReference.getHumanArrayDtoMapInfo(division, KEY_VIEW_ARRAY_CARD, vo.getPersonalId(), rowId);
        vo.setAryRecordIdMap(normalReference.getRecordsMap());
        vo.putArrayItem(division, normalReference.getArrayHumanInfoMap());
    }
}

