/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.ConcurrentRegistBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.ConcurrentCardVo;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class ConcurrentCardAction
extends PlatformHumanAction {
    public static final String CMD_SET_ACTIVATION_DATE = "PF1180";
    public static final String CMD_SEARCH = "PF1182";
    public static final String CMD_UPDATE = "PF1183";
    public static final String CMD_SELECT = "PF1186";
    public static final String CMD_DELETE = "PF1187";
    public static final String CMD_TRANSFER = "PF1189";
    public static final String PRM_TRANSFERRED_ROW_NO = "transferredRowNo";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.update();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new ConcurrentCardVo();
    }

    protected void select() throws MospException {
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setCurrentWorkInfo();
        this.setConcurrentInfo();
        this.setPulldownList();
        this.setJsValue();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setCurrentWorkInfo();
        this.setConcurrentInfo();
        this.setPulldownList();
    }

    protected void update() throws MospException {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        this.validate();
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        ConcurrentRegistBeanInterface regist = this.platform().concurrentRegist();
        List list = regist.getInitDtoList(vo.getAryHidPfaHumanConcurrentId().length);
        this.setDtoFields(list);
        regist.regist(list);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageInsertSucceed((MospParams)this.mospParams);
        this.setConcurrentInfo();
        this.setPulldownList();
    }

    protected void delete() throws MospException {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(this.getIndexArray(vo.getCkbSelect()), vo.getAryHidPfaHumanConcurrentId());
        if (idArray.length == 0) {
            PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
            this.removeDeletedRow();
            this.setPulldownList();
            return;
        }
        this.platform().concurrentRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.removeDeletedRow();
        this.setPulldownList();
    }

    protected void setActivationDate() throws MospException {
        int rowNo = this.getTransferredRowNo();
        this.setModeActivateDate(rowNo);
        this.setPulldownList();
    }

    protected void transfer() {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setModeActivateDate(int rowNo) {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        String[] modeActivateDateArray = vo.getModeActivateDateArray();
        modeActivateDateArray[rowNo] = modeActivateDateArray[rowNo].equals("chaning") ? "fixed" : "chaning";
        vo.setModeActivateDateArray(modeActivateDateArray);
    }

    protected void setPulldownList() throws MospException {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        SectionReferenceBeanInterface section = this.reference().section();
        PositionReferenceBeanInterface position = this.reference().position();
        String range = "1";
        ArrayList<String[][]> listAryPltSectionAbbr = new ArrayList<String[][]>();
        ArrayList<String[][]> listAryPltPosition = new ArrayList<String[][]>();
        for (int i = 0; i < vo.getAryHidPfaHumanConcurrentId().length; ++i) {
            if (vo.getModeActivateDateArray()[i].equals("fixed")) {
                listAryPltSectionAbbr.add(section.getCodedSelectArray(this.getConcurrentStartDate(i), false, range));
                listAryPltPosition.add(position.getCodedSelectArray(this.getConcurrentStartDate(i), false, range));
                continue;
            }
            listAryPltSectionAbbr.add(this.getInputStartDatePulldown());
            listAryPltPosition.add(this.getInputStartDatePulldown());
        }
        vo.setListAryPltSectionAbbr(listAryPltSectionAbbr);
        vo.setListAryPltPosition(listAryPltPosition);
    }

    protected void setCurrentWorkInfo() throws MospException {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        Date targetDate = this.getSystemDate();
        HumanDtoInterface dto = this.reference().human().getHumanInfo(vo.getPersonalId(), targetDate);
        if (dto == null) {
            return;
        }
        vo.setLblPositionName(this.reference().position().getPositionName(dto.getPositionCode(), targetDate));
        vo.setAryLblClassRoute(this.reference().section().getClassRouteNameArray(dto.getSectionCode(), targetDate));
    }

    protected void setConcurrentInfo() throws MospException {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        this.setVoFields(this.reference().concurrent().getConcurrentHistory(vo.getPersonalId()));
    }

    protected void setDefaultValues() {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        String[] aryBlank = new String[]{""};
        Date systemDate = this.getSystemDate();
        vo.setAryHidPfaHumanConcurrentId(aryBlank);
        vo.setAryTxtConcurrentStartYear(new String[]{this.getStringYear(systemDate)});
        vo.setAryTxtConcurrentStartMonth(new String[]{this.getStringMonth(systemDate)});
        vo.setAryTxtConcurrentStartDay(new String[]{this.getStringDay(systemDate)});
        vo.setAryPosition(aryBlank);
        vo.setArySectionAbbr(aryBlank);
        vo.setAryTxtConcurrentEndYear(aryBlank);
        vo.setAryTxtConcurrentEndMonth(aryBlank);
        vo.setAryTxtConcurrentEndDay(aryBlank);
        vo.setAryTxtRemark(aryBlank);
        vo.setModeActivateDateArray(new String[]{"chaning"});
    }

    protected void setJsValue() {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        vo.setJsActivateDateButtonName(PfNameUtility.decision((MospParams)this.mospParams));
        vo.setJsDefaultPulldown(PfNameUtility.inputStartDate((MospParams)this.mospParams));
    }

    protected void setVoFields(List<ConcurrentDtoInterface> list) {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        if (list.isEmpty()) {
            this.setDefaultValues();
            return;
        }
        String[] aryHidPfaHumanConcurrentId = new String[list.size()];
        String[] aryTxtConcurrentStartYear = new String[list.size()];
        String[] aryTxtConcurrentStartMonth = new String[list.size()];
        String[] aryTxtConcurrentStartDay = new String[list.size()];
        String[] aryTxtConcurrentEndYear = new String[list.size()];
        String[] aryTxtConcurrentEndMonth = new String[list.size()];
        String[] aryTxtConcurrentEndDay = new String[list.size()];
        String[] arySectionAbbr = new String[list.size()];
        String[] aryPosition = new String[list.size()];
        String[] aryTxtRemark = new String[list.size()];
        String[] aryModeActivateDate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ConcurrentDtoInterface dto = list.get(i);
            aryTxtConcurrentStartYear[i] = this.getStringYear(dto.getStartDate());
            aryTxtConcurrentStartMonth[i] = this.getStringMonth(dto.getStartDate());
            aryTxtConcurrentStartDay[i] = this.getStringDay(dto.getStartDate());
            aryTxtConcurrentEndYear[i] = this.getStringYear(dto.getEndDate());
            aryTxtConcurrentEndMonth[i] = this.getStringMonth(dto.getEndDate());
            aryTxtConcurrentEndDay[i] = this.getStringDay(dto.getEndDate());
            arySectionAbbr[i] = dto.getSectionCode();
            aryPosition[i] = dto.getPositionCode();
            aryTxtRemark[i] = dto.getConcurrentRemark();
            aryHidPfaHumanConcurrentId[i] = String.valueOf(dto.getPfaHumanConcurrentId());
            aryModeActivateDate[i] = "fixed";
        }
        vo.setAryHidPfaHumanConcurrentId(aryHidPfaHumanConcurrentId);
        vo.setAryTxtConcurrentStartYear(aryTxtConcurrentStartYear);
        vo.setAryTxtConcurrentStartMonth(aryTxtConcurrentStartMonth);
        vo.setAryTxtConcurrentStartDay(aryTxtConcurrentStartDay);
        vo.setAryTxtConcurrentEndYear(aryTxtConcurrentEndYear);
        vo.setAryTxtConcurrentEndMonth(aryTxtConcurrentEndMonth);
        vo.setAryTxtConcurrentEndDay(aryTxtConcurrentEndDay);
        vo.setArySectionAbbr(arySectionAbbr);
        vo.setAryPosition(aryPosition);
        vo.setAryTxtRemark(aryTxtRemark);
        vo.setModeActivateDateArray(aryModeActivateDate);
    }

    protected void setDtoFields(List<ConcurrentDtoInterface> list) {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        for (int i = 0; i < list.size(); ++i) {
            ConcurrentDtoInterface dto = list.get(i);
            if (vo.getAryHidPfaHumanConcurrentId()[i].isEmpty()) {
                dto.setPfaHumanConcurrentId(0L);
            } else {
                dto.setPfaHumanConcurrentId(this.getLong(vo.getAryHidPfaHumanConcurrentId()[i]));
            }
            dto.setPersonalId(vo.getPersonalId());
            dto.setStartDate(this.getConcurrentStartDate(i));
            dto.setEndDate(this.getConcurrentEndDate(i));
            dto.setSectionCode(vo.getArySectionAbbr()[i]);
            dto.setPositionCode(vo.getAryPosition()[i]);
            dto.setConcurrentRemark(vo.getAryTxtRemark()[i]);
        }
    }

    protected void removeDeletedRow() {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        int[] deletedRows = this.getIndexArray(vo.getCkbSelect());
        int length = vo.getAryHidPfaHumanConcurrentId().length - deletedRows.length;
        if (length <= 0) {
            this.setDefaultValues();
            return;
        }
        String[] aryHidPfaHumanConcurrentId = new String[length];
        String[] aryTxtConcurrentStartYear = new String[length];
        String[] aryTxtConcurrentStartMonth = new String[length];
        String[] aryTxtConcurrentStartDay = new String[length];
        String[] aryTxtConcurrentEndYear = new String[length];
        String[] aryTxtConcurrentEndMonth = new String[length];
        String[] aryTxtConcurrentEndDay = new String[length];
        String[] arySectionAbbr = new String[length];
        String[] aryPosition = new String[length];
        String[] aryTxtRemark = new String[length];
        String[] aryModeActivateDate = new String[length];
        int idx = 0;
        for (int i = 0; i < vo.getAryHidPfaHumanConcurrentId().length; ++i) {
            if (this.isIndexed(i, deletedRows)) continue;
            aryTxtConcurrentStartYear[idx] = vo.getAryTxtConcurrentStartYear()[i];
            aryTxtConcurrentStartMonth[idx] = vo.getAryTxtConcurrentStartMonth()[i];
            aryTxtConcurrentStartDay[idx] = vo.getAryTxtConcurrentStartDay()[i];
            aryTxtConcurrentEndYear[idx] = vo.getAryTxtConcurrentEndYear()[i];
            aryTxtConcurrentEndMonth[idx] = vo.getAryTxtConcurrentEndMonth()[i];
            aryTxtConcurrentEndDay[idx] = vo.getAryTxtConcurrentEndDay()[i];
            arySectionAbbr[idx] = vo.getArySectionAbbr()[i];
            aryPosition[idx] = vo.getAryPosition()[i];
            aryTxtRemark[idx] = vo.getAryTxtRemark()[i];
            aryHidPfaHumanConcurrentId[idx] = vo.getAryHidPfaHumanConcurrentId()[i];
            aryModeActivateDate[idx++] = i < vo.getModeActivateDateArray().length ? vo.getModeActivateDateArray()[i] : "chaning";
        }
        vo.setAryHidPfaHumanConcurrentId(aryHidPfaHumanConcurrentId);
        vo.setAryTxtConcurrentStartYear(aryTxtConcurrentStartYear);
        vo.setAryTxtConcurrentStartMonth(aryTxtConcurrentStartMonth);
        vo.setAryTxtConcurrentStartDay(aryTxtConcurrentStartDay);
        vo.setAryTxtConcurrentEndYear(aryTxtConcurrentEndYear);
        vo.setAryTxtConcurrentEndMonth(aryTxtConcurrentEndMonth);
        vo.setAryTxtConcurrentEndDay(aryTxtConcurrentEndDay);
        vo.setArySectionAbbr(arySectionAbbr);
        vo.setAryPosition(aryPosition);
        vo.setAryTxtRemark(aryTxtRemark);
        vo.setModeActivateDateArray(aryModeActivateDate);
    }

    protected void validate() throws MospException {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        String startDateName = PfNameUtility.concurrentStartDate((MospParams)this.mospParams);
        String endDateName = PfNameUtility.concurrentEndDate((MospParams)this.mospParams);
        for (int i = 0; i < vo.getAryTxtConcurrentStartYear().length; ++i) {
            InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getAryTxtConcurrentStartYear()[i], (String)startDateName);
            InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getAryTxtConcurrentStartMonth()[i], (String)startDateName);
            InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getAryTxtConcurrentStartDay()[i], (String)startDateName);
            InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentStartYear()[i], (String)startDateName);
            InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentStartMonth()[i], (String)startDateName);
            InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentStartDay()[i], (String)startDateName);
            InputCheckUtility.checkLength((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentStartYear()[i], (int)4, (String)startDateName);
            InputCheckUtility.checkLength((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentStartMonth()[i], (int)2, (String)startDateName);
            InputCheckUtility.checkLength((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentStartDay()[i], (int)2, (String)startDateName);
            if (!(vo.getAryTxtConcurrentEndYear()[i] != null && !vo.getAryTxtConcurrentEndYear()[i].isEmpty() || vo.getAryTxtConcurrentEndMonth()[i] != null && !vo.getAryTxtConcurrentEndMonth()[i].isEmpty()) && (vo.getAryTxtConcurrentEndDay()[i] == null || vo.getAryTxtConcurrentEndDay()[i].isEmpty())) continue;
            InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getAryTxtConcurrentEndYear()[i], (String)endDateName);
            InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getAryTxtConcurrentEndMonth()[i], (String)endDateName);
            InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)vo.getAryTxtConcurrentEndDay()[i], (String)endDateName);
            InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentEndYear()[i], (String)endDateName);
            InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentEndMonth()[i], (String)endDateName);
            InputCheckUtility.checkNumber((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentEndDay()[i], (String)endDateName);
            InputCheckUtility.checkLength((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentEndYear()[i], (int)4, (String)endDateName);
            InputCheckUtility.checkLength((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentEndMonth()[i], (int)2, (String)endDateName);
            InputCheckUtility.checkLength((MospParams)this.mospParams, (String)vo.getAryTxtConcurrentEndDay()[i], (int)2, (String)endDateName);
            Date startDate = this.getDate(vo.getAryTxtConcurrentStartYear()[i], vo.getAryTxtConcurrentStartMonth()[i], vo.getAryTxtConcurrentStartDay()[i]);
            Date endDate = this.getDate(vo.getAryTxtConcurrentEndYear()[i], vo.getAryTxtConcurrentEndMonth()[i], vo.getAryTxtConcurrentEndDay()[i]);
            InputCheckUtility.checkDateOrder((MospParams)this.mospParams, (Date)startDate, (Date)endDate, (String)startDateName, (String)endDateName);
        }
    }

    protected Date getConcurrentStartDate(int idx) {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        return this.getDate(vo.getAryTxtConcurrentStartYear()[idx], vo.getAryTxtConcurrentStartMonth()[idx], vo.getAryTxtConcurrentStartDay()[idx]);
    }

    protected Date getConcurrentEndDate(int idx) {
        ConcurrentCardVo vo = (ConcurrentCardVo)this.mospParams.getVo();
        return this.getDate(vo.getAryTxtConcurrentEndYear()[idx], vo.getAryTxtConcurrentEndMonth()[idx], vo.getAryTxtConcurrentEndDay()[idx]);
    }

    protected int getTransferredRowNo() {
        int retInt = 0;
        if (this.mospParams.getRequestParam(PRM_TRANSFERRED_ROW_NO) != null) {
            retInt = Integer.parseInt(this.mospParams.getRequestParam(PRM_TRANSFERRED_ROW_NO));
        }
        return retInt;
    }
}

