/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.TopicPath;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.HistoryBasicDeleteBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.NamingReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.BasicListVo;
import jp.mosp.platform.utils.PfMessageUtility;

public class BasicListAction
extends PlatformHumanAction {
    public static final String CMD_SEARCH = "PF1142";
    public static final String CMD_SELECT = "PF1146";
    public static final String CMD_RE_SEARCH = "PF1147";
    public static final String CMD_DELETE = "PF1148";
    public static final String CMD_TRANSFER = "PF1149";
    protected static final String APP_BASIC_BEANS = "HistoryBasicDeleteBeans";

    public BasicListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.reSearch();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo(true, false);
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new BasicListVo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.getBasicList();
    }

    protected void select() throws MospException {
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.getBasicList();
    }

    protected void reSearch() throws MospException {
        BasicListVo vo = (BasicListVo)this.mospParams.getVo();
        this.setHumanCommonInfo(vo.getPersonalId(), vo.getTargetDate());
        this.setDefaultValues();
        this.getBasicList();
    }

    protected void delete() throws MospException {
        BasicListVo vo = (BasicListVo)this.mospParams.getVo();
        this.deleteHistoryBasicInfo();
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (vo.getJsIsLastHistoryBasic().booleanValue()) {
            String nextCommand = this.mospParams.getApplicationProperty("CommandPortal");
            List topicPathList = this.mospParams.getTopicPathList();
            if (topicPathList != null && topicPathList.size() > 1) {
                nextCommand = ((TopicPath)topicPathList.get(1)).getCommand();
            }
            this.mospParams.setNextCommand(nextCommand);
            return;
        }
        this.setDefaultValues();
        this.getBasicList();
    }

    protected void transfer() {
        BasicListVo vo = (BasicListVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals("PF1156")) {
            this.setTargetDate(this.getDate(vo.getAryActiveteDate(this.getTransferredIndex())));
            this.mospParams.setNextCommand("PF1156");
        } else if (actionName.equals("PF1136")) {
            this.mospParams.setNextCommand("PF1136");
        } else if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void deleteHistoryBasicInfo() throws MospException {
        BasicListVo vo = (BasicListVo)this.mospParams.getVo();
        int idx = this.getTransferredIndex();
        long pfmHumanId = this.getLong(vo.getAryPfmHumanId()[idx]);
        boolean isAllDelete = vo.getJsIsLastHistoryBasic();
        HistoryBasicDeleteBeanInterface bean = this.platform().historyBasicDelete();
        bean.delete(pfmHumanId, isAllDelete);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        if (isAllDelete) {
            PfMessageUtility.addMessageDeleteAllHistory((MospParams)this.mospParams);
        } else {
            PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        }
        this.commit();
    }

    protected void setDefaultValues() {
        BasicListVo vo = (BasicListVo)this.mospParams.getVo();
        vo.setAryActiveteDate(new String[0]);
        vo.setAryEmployeeKana(new String[0]);
        vo.setAryEmployeeName(new String[0]);
        vo.setAryWorkPlace(new String[0]);
        vo.setAryEmployment(new String[0]);
        vo.setAryPosition(new String[0]);
        vo.setArySection(new String[0]);
        vo.setAryPost(new String[0]);
        vo.setNeedDeleteBasciHistory(this.mospParams.getApplicationPropertyBool("HistoryBasicDeleteButton"));
        vo.setNeedPost(this.mospParams.getApplicationPropertyBool("UsePost"));
    }

    protected void getBasicList() throws MospException {
        BasicListVo vo = (BasicListVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        if (vo.getPersonalId().isEmpty()) {
            personalId = this.reference().human().getPersonalId(vo.getEmployeeCode(), this.getSystemDate());
        }
        List list = this.reference().human().getHistory(personalId);
        boolean isLastHistory = false;
        if (list.size() == 1) {
            isLastHistory = true;
        }
        vo.setJsIsLastHistoryBasic(Boolean.valueOf(isLastHistory));
        String[] aryPfmHumanId = new String[list.size()];
        String[] aryActiveteDate = new String[list.size()];
        String[] aryEmployeeKana = new String[list.size()];
        String[] aryEmployeeName = new String[list.size()];
        String[] aryWorkPlaceCode = new String[list.size()];
        String[] aryWorkPlace = new String[list.size()];
        String[] aryEmploymentCode = new String[list.size()];
        String[] aryEmployment = new String[list.size()];
        String[] aryPositionCode = new String[list.size()];
        String[] aryPosition = new String[list.size()];
        String[] arySectionCode = new String[list.size()];
        String[] arySection = new String[list.size()];
        PositionReferenceBeanInterface position = this.reference().position();
        SectionReferenceBeanInterface section = this.reference().section();
        EmploymentContractReferenceBeanInterface contract = this.reference().employmentContract();
        WorkPlaceReferenceBeanInterface workPlace = this.reference().workPlace();
        for (int i = 0; i < list.size(); ++i) {
            HumanDtoInterface dto = (HumanDtoInterface)list.get(list.size() - 1 - i);
            vo.setPersonalId(dto.getPersonalId());
            aryPfmHumanId[i] = String.valueOf(dto.getPfmHumanId());
            aryActiveteDate[i] = this.getStringDate(dto.getActivateDate());
            aryEmployeeKana[i] = MospUtility.getHumansName((String)dto.getFirstKana(), (String)dto.getLastKana());
            aryEmployeeName[i] = MospUtility.getHumansName((String)dto.getFirstName(), (String)dto.getLastName());
            aryWorkPlaceCode[i] = dto.getWorkPlaceCode();
            aryWorkPlace[i] = workPlace.getWorkPlaceName(dto.getWorkPlaceCode(), dto.getActivateDate());
            aryEmploymentCode[i] = dto.getEmploymentContractCode();
            aryEmployment[i] = contract.getContractName(dto.getEmploymentContractCode(), dto.getActivateDate());
            aryPositionCode[i] = dto.getPositionCode();
            aryPosition[i] = position.getPositionName(dto.getPositionCode(), dto.getActivateDate());
            arySectionCode[i] = dto.getSectionCode();
            arySection[i] = section.getSectionName(dto.getSectionCode(), dto.getActivateDate());
        }
        vo.setAryPfmHumanId(aryPfmHumanId);
        vo.setAryActiveteDate(aryActiveteDate);
        vo.setAryEmployeeKana(aryEmployeeKana);
        vo.setAryEmployeeName(aryEmployeeName);
        vo.setAryWorkPlaceCode(aryWorkPlaceCode);
        vo.setAryWorkPlace(aryWorkPlace);
        vo.setAryEmploymentCode(aryEmploymentCode);
        vo.setAryEmployment(aryEmployment);
        vo.setAryPositionCode(aryPositionCode);
        vo.setAryPosition(aryPosition);
        vo.setArySectionCode(arySectionCode);
        vo.setArySection(arySection);
        if (vo.getNeedPost()) {
            this.setPost(list);
        }
    }

    private void setPost(List<HumanDtoInterface> list) throws MospException {
        BasicListVo vo = (BasicListVo)this.mospParams.getVo();
        String[] aryPostCode = new String[list.size()];
        String[] aryPost = new String[list.size()];
        HumanHistoryReferenceBeanInterface humanHistoryReference = this.reference().humanHistory();
        NamingReferenceBeanInterface namingReference = this.reference().naming();
        for (int i = 0; i < list.size(); ++i) {
            HumanDtoInterface dto = list.get(list.size() - 1 - i);
            HumanHistoryDtoInterface postDto = humanHistoryReference.findForKey(dto.getPersonalId(), "post", dto.getActivateDate());
            if (postDto == null) continue;
            String namingName = namingReference.getNamingItemName("post", postDto.getHumanItemValue(), dto.getActivateDate());
            aryPostCode[i] = postDto.getHumanItemValue();
            aryPost[i] = namingName;
        }
        vo.setAryPostCode(aryPostCode);
        vo.setAryPost(aryPost);
    }
}

