/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.file.action;

import java.util.ArrayList;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.bean.file.ImportBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.file.base.ImportListAction;
import jp.mosp.platform.file.vo.ImportListVo;
import jp.mosp.platform.utils.PfMessageUtility;

public class HumanImportListAction
extends ImportListAction {
    public static final String CMD_SHOW = "PF1310";
    public static final String CMD_SEARCH = "PF1312";
    public static final String CMD_RE_SHOW = "PF1313";
    public static final String CMD_EXECUTION = "PF1315";
    public static final String CMD_SORT = "PF1318";
    public static final String CMD_PAGE = "PF1319";
    public static final String CMD_TEMP_OUTPUT = "PF1386";

    public HumanImportListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_EXECUTION)) {
            this.prepareVo();
            this.execution();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_TEMP_OUTPUT)) {
            this.prepareVo();
            this.tempOutput();
        }
    }

    protected void setImportListInfo() {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        vo.setTableTypeCodeKey("HumanImportTableType");
        vo.setReShowCommand(CMD_RE_SHOW);
        vo.setSearchCommand(CMD_SEARCH);
        vo.setSortCommand(CMD_SORT);
        vo.setExecuteCommand(CMD_EXECUTION);
        vo.setTemplateOutputCommand(CMD_TEMP_OUTPUT);
        this.setPageInfo(CMD_PAGE, this.getListLength());
    }

    protected void show() throws MospException {
        this.setImportListInfo();
        this.initImportListVoFields();
    }

    protected void search() throws MospException {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        super.search();
        if (vo.getList().isEmpty()) {
            return;
        }
        ArrayList ary = new ArrayList();
        ary.addAll(RoleUtility.getHiddenDivisionsList((MospParams)this.mospParams));
        ary.addAll(RoleUtility.getReferenceDivisionsList((MospParams)this.mospParams));
        String[] aryDivision = MospUtility.toArray(ary);
        if (aryDivision.length == 0) {
            return;
        }
        ArrayList<ImportDtoInterface> list = new ArrayList<ImportDtoInterface>();
        for (int idx = 0; idx < vo.getList().size(); ++idx) {
            ImportDtoInterface dto = (ImportDtoInterface)vo.getList().get(idx);
            if (!dto.getImportTable().contains("pfm_human")) {
                list.add(dto);
                continue;
            }
            if (this.reference().humanImport().isExistLikeFieldName(dto.getImportCode(), aryDivision)) continue;
            list.add(dto);
        }
        this.setDtoToVoList(list);
    }

    protected void execution() throws MospException {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        ImportDtoInterface importDto = this.reference().importRefer().findForKey(vo.getRadSelect());
        if (importDto == null) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        ImportBeanInterface importBean = this.getImportBean(importDto);
        if (importBean == null) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        int count = importBean.importFile(importDto, this.mospParams.getRequestFile("filImport"));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageImportSucceed((MospParams)this.mospParams, (int)count);
    }

    protected ImportBeanInterface getImportBean(ImportDtoInterface importDto) throws MospException {
        Object importBean = null;
        importBean = importDto.getImportTable().equals("pfm_human") ? this.platform().humanImport() : (importDto.getImportTable().equals("pfm_user") ? this.platform().userImport() : (importDto.getImportTable().equals("pfa_user_extra_role") ? this.platform().userExtraRoleImport() : (importDto.getImportTable().equals("pfm_section") ? this.platform().sectionImport() : (importDto.getImportTable().equals("pfm_position") ? this.platform().positionImport() : (importDto.getImportTable().equals("pfa_user_password") ? this.platform().userPasswordImport() : (importDto.getImportTable().equals("unit_section") ? this.platform().unitSectionImport() : (importDto.getImportTable().equals("unit_person") ? this.platform().unitPersonImport() : this.getImportBean(importDto.getImportTable()))))))));
        return importBean;
    }

    protected ImportBeanInterface getImportBean(String exportTable) throws MospException {
        String modelClass = MospUtility.getModelClass((String)exportTable, (MospProperties)this.mospParams.getProperties(), (Date)this.getSystemDate());
        return (ImportBeanInterface)this.reference().createBean(modelClass);
    }
}

