/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.file.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.MospProperties;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.bean.file.ExportBeanInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.file.base.ExportListAction;
import jp.mosp.platform.file.base.ExportListVo;
import jp.mosp.platform.file.vo.HumanExportListVo;
import jp.mosp.platform.utils.PfMessageUtility;

public class HumanExportListAction
extends ExportListAction {
    public static final String CMD_SHOW = "PF1410";
    public static final String CMD_SEARCH = "PF1412";
    public static final String CMD_RE_SHOW = "PF1413";
    public static final String CMD_EXPORT = "PF1415";
    public static final String CMD_SORT = "PF1418";
    public static final String CMD_PAGE = "PF1419";
    public static final String CMD_SET_EXPORT = "PF1480";
    public static final String CMD_SET_ACTIVATION_DATE = "PF1482";

    public HumanExportListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new HumanExportListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_EXPORT)) {
            this.prepareVo();
            this.export();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_EXPORT)) {
            this.prepareVo();
            this.setExport();
        } else if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        }
    }

    protected void setExportListInfo() {
        ExportListVo vo = (ExportListVo)this.mospParams.getVo();
        vo.setTableTypeCodeKey("HumanExportTableType");
        vo.setReShowCommand(CMD_RE_SHOW);
        vo.setSearchCommand(CMD_SEARCH);
        vo.setSortCommand(CMD_SORT);
        vo.setSetExportCommand(CMD_SET_EXPORT);
        this.setPageInfo(CMD_PAGE, this.getListLength());
    }

    protected void show() throws MospException {
        this.setExportListInfo();
        this.initExportListVoFields();
        this.initOutputCondition();
    }

    protected void search() throws MospException {
        ExportListVo vo = (ExportListVo)this.mospParams.getVo();
        super.search();
        if (vo.getList().isEmpty()) {
            return;
        }
        String[] aryDivision = MospUtility.toArray((Collection)RoleUtility.getHiddenDivisionsList((MospParams)this.mospParams));
        if (aryDivision.length == 0) {
            return;
        }
        ArrayList<ExportDtoInterface> list = new ArrayList<ExportDtoInterface>();
        for (int idx = 0; idx < vo.getList().size(); ++idx) {
            ExportDtoInterface dto = (ExportDtoInterface)vo.getList().get(idx);
            if (!dto.getExportTable().contains("pfm_human")) {
                list.add(dto);
                continue;
            }
            if (this.reference().humanExport().isExistLikeFieldName(dto.getExportCode(), aryDivision)) continue;
            list.add(dto);
        }
        this.setDtoToVoList(list);
    }

    protected void setActivationDate() throws MospException {
        HumanExportListVo vo = (HumanExportListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
        } else {
            vo.setModeActivateDate("chaning");
        }
        this.setPulldown();
    }

    protected void setPulldown() throws MospException {
        HumanExportListVo vo = (HumanExportListVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltWorkPlace(this.getInputActivateDatePulldown());
            vo.setAryPltEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltSection(this.getInputActivateDatePulldown());
            vo.setAryPltPosition(this.getInputActivateDatePulldown());
            return;
        }
        Date targetDate = this.getPulldownTargetDate();
        vo.setAryPltWorkPlace(this.reference().workPlace().getCodedAbbrSelectArray(targetDate, true, "1"));
        vo.setAryPltEmployment(this.reference().employmentContract().getCodedAbbrSelectArray(targetDate, true, "1"));
        vo.setAryPltSection(this.reference().section().getCodedSelectArray(targetDate, true, "1"));
        vo.setAryPltPosition(this.reference().position().getCodedSelectArray(targetDate, true, "1"));
    }

    protected Date getPulldownTargetDate() {
        HumanExportListVo vo = (HumanExportListVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
    }

    protected void initOutputCondition() throws MospException {
        HumanExportListVo vo = (HumanExportListVo)this.mospParams.getVo();
        Date systemDate = this.getSystemDate();
        vo.setTxtActivateYear(this.getStringYear(systemDate));
        vo.setTxtActivateMonth(this.getStringMonth(systemDate));
        vo.setTxtActivateDay(this.getStringDay(systemDate));
        vo.setModeActivateDate("chaning");
        this.setPulldown();
    }

    protected void export() throws MospException {
        HumanExportListVo vo = (HumanExportListVo)this.mospParams.getVo();
        Date targetDate = this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
        ExportDtoInterface exportDto = this.reference().export().findForKey(vo.getRadSelect());
        if (exportDto == null) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
            return;
        }
        Object exportBean = exportDto.getExportTable().equals("pfm_human") ? this.reference().humanExport() : (exportDto.getExportTable().equals("pfm_user") ? this.reference().userExport() : (exportDto.getExportTable().equals("pfa_user_extra_role") ? this.reference().userExtraRoleExport() : (exportDto.getExportTable().equals("pfm_section") ? this.reference().sectionExport() : this.getExportBean(exportDto.getExportTable()))));
        if (exportBean == null) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
            return;
        }
        exportBean.export(vo.getRadSelect(), targetDate, vo.getPltWorkPlace(), vo.getPltEmployment(), vo.getPltSection(), vo.getPltPosition());
    }

    protected ExportBeanInterface getExportBean(String exportTable) throws MospException {
        String modelClass = MospUtility.getModelClass((String)exportTable, (MospProperties)this.mospParams.getProperties(), (Date)this.getSystemDate());
        return (ExportBeanInterface)this.reference().createBean(modelClass);
    }
}

