/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.system.impl;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dao.system.UserExtraRoleDaoInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmUserDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PfmUserDao
extends PlatformDao
implements UserMasterDaoInterface {
    protected UserExtraRoleDaoInterface userExtraRoleDao;
    public static final String TABLE = "pfm_user";
    public static final String COL_PFM_USER_ID = "pfm_user_id";
    public static final String COL_USER_ID = "user_id";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_ROLE_CODE = "role_code";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "pfm_user_id";

    public void initDao() {
    }

    protected void setDaoInstances() throws MospException {
        this.userExtraRoleDao = (UserExtraRoleDaoInterface)this.loadDao(UserExtraRoleDaoInterface.class);
    }

    public BaseDto mapping() throws MospException {
        PfmUserDto dto = new PfmUserDto();
        dto.setPfmUserId(this.getLong("pfm_user_id"));
        dto.setUserId(this.getString("user_id"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setRoleCode(this.getString("role_code"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<UserMasterDtoInterface> mappingAll() throws MospException {
        ArrayList<UserMasterDtoInterface> all = new ArrayList<UserMasterDtoInterface>();
        while (this.next()) {
            all.add((UserMasterDtoInterface)this.mapping());
        }
        return all;
    }

    public UserMasterDtoInterface findForKey(String userId, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmUserDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmUserDao.and());
            sb.append(PfmUserDao.equal((String)"user_id"));
            sb.append(PfmUserDao.and());
            sb.append(PfmUserDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, userId);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            UserMasterDtoInterface dto = null;
            if (this.next()) {
                dto = (UserMasterDtoInterface)this.mapping();
            }
            UserMasterDtoInterface userMasterDtoInterface = dto;
            return userMasterDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public UserMasterDtoInterface findForInfo(String userId, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmUserDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmUserDao.and());
            sb.append(PfmUserDao.equal((String)"user_id"));
            sb.append(PfmUserDao.and());
            sb.append(PfmUserDao.lessEqual((String)"activate_date"));
            sb.append(PfmUserDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, userId);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            UserMasterDtoInterface dto = null;
            if (this.rs.next()) {
                dto = (UserMasterDtoInterface)this.mapping();
            }
            UserMasterDtoInterface userMasterDtoInterface = dto;
            return userMasterDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<UserMasterDtoInterface> findForHistory(String userId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmUserDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmUserDao.and());
            sb.append(PfmUserDao.equal((String)"user_id"));
            sb.append(PfmUserDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, userId);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<UserMasterDtoInterface> findForPersonalId(String personalId, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_user", "user_id", "activate_date"));
            sb.append(PfmUserDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmUserDao.and());
            sb.append(PfmUserDao.equal((String)"personal_id"));
            sb.append(PfmUserDao.getOrderByColumn((String)"user_id"));
            this.prepareStatement(sb.toString());
            this.index = this.setParamsForMaxActivateDate(this.index, activateDate, this.ps);
            this.setParam(this.index++, personalId);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<UserMasterDtoInterface> findForPersonalId(String personalId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmUserDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmUserDao.and());
            sb.append(PfmUserDao.equal((String)"personal_id"));
            sb.append(PfmUserDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<UserMasterDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            Date targetDate;
            HumanDaoInterface humanDao = (HumanDaoInterface)this.loadDao(HumanDaoInterface.class);
            Date activateDate = (Date)param.get("activateDate");
            String employeeCode = String.valueOf(param.get("employeeCode"));
            String userId = String.valueOf(param.get("userId"));
            String employeeName = String.valueOf(param.get("employeeName"));
            String inactivateFlag = String.valueOf(param.get("inactivateFlag"));
            this.index = 1;
            StringBuffer sb = new StringBuffer();
            sb.append(this.getSelectQuery(this.getClass()));
            if (activateDate != null) {
                sb.append(this.getQueryForMaxActivateDate("pfm_user", "user_id", "activate_date"));
            }
            sb.append(PfmUserDao.where());
            sb.append(this.deleteFlagOff());
            if (!userId.isEmpty()) {
                sb.append(PfmUserDao.and());
                sb.append(PfmUserDao.like((String)"user_id"));
            }
            if (!employeeCode.isEmpty()) {
                sb.append(PfmUserDao.and());
                sb.append("personal_id");
                sb.append(PfmUserDao.in());
                sb.append(PfmUserDao.leftParenthesis());
                sb.append(humanDao.getQueryForEmployeeCode());
                sb.append(PfmUserDao.rightParenthesis());
            }
            if (!employeeName.isEmpty()) {
                sb.append(humanDao.getQueryForEmployeeName("personal_id"));
            }
            if (!inactivateFlag.isEmpty()) {
                sb.append(PfmUserDao.and());
                sb.append(PfmUserDao.equal((String)"inactivate_flag"));
            }
            this.prepareStatement(sb.toString());
            if (activateDate != null) {
                this.setParam(this.index++, activateDate);
            }
            if (!userId.isEmpty()) {
                this.setParam(this.index++, PfmUserDao.startWithParam((String)userId));
            }
            if (!employeeCode.isEmpty()) {
                targetDate = activateDate;
                if (targetDate == null) {
                    targetDate = DateUtility.getSystemDate();
                }
                this.setParam(this.index++, targetDate);
                this.setParam(this.index++, PfmUserDao.startWithParam((String)employeeCode));
            }
            if (!employeeName.isEmpty()) {
                targetDate = activateDate;
                if (targetDate == null) {
                    targetDate = DateUtility.getSystemDate();
                }
                this.index = humanDao.setParamsForEmployeeName(this.index, PfmUserDao.containsParam((String)employeeName), targetDate, this.ps);
            }
            if (!inactivateFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            UserMasterDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmUserId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            UserMasterDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmUserId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        UserMasterDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPfmUserId());
        this.setParam(this.index++, dto.getUserId());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getRoleCode());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public String getQueryForEmployeeName() throws MospException {
        HumanDaoInterface humanDao = (HumanDaoInterface)this.loadDao(HumanDaoInterface.class);
        StringBuffer sb = new StringBuffer();
        sb.append(PfmUserDao.select());
        sb.append("user_id");
        sb.append(PfmUserDao.from((String)"pfm_user"));
        sb.append(this.getQueryForMaxActivateDate("pfm_user", "user_id", "activate_date"));
        sb.append(PfmUserDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(humanDao.getQueryForEmployeeName("personal_id"));
        return sb.toString();
    }

    public String getQueryForApprover(String targetColumn) throws MospException {
        StringBuffer sb = new StringBuffer();
        Set approverRoleSet = RoleUtility.getApproverRoles((MospParams)this.mospParams);
        if (approverRoleSet.isEmpty()) {
            return sb.toString();
        }
        this.setDaoInstances();
        sb.append(PfmUserDao.and());
        sb.append(targetColumn);
        sb.append(PfmUserDao.in());
        sb.append(PfmUserDao.leftParenthesis());
        sb.append(PfmUserDao.select());
        sb.append("personal_id");
        sb.append(PfmUserDao.from((String)"pfm_user"));
        sb.append(this.getQueryForMaxActivateDate("pfm_user", "user_id", "activate_date"));
        sb.append(this.userExtraRoleDao.getQueryForJoinUser("user_id", "activate_date"));
        sb.append(PfmUserDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmUserDao.and());
        sb.append(PfmUserDao.leftParenthesis());
        for (int i = 0; i < approverRoleSet.size(); ++i) {
            sb.append(PfmUserDao.equal((String)"role_code"));
            sb.append(PfmUserDao.or());
            sb.append(PfmUserDao.equal((String)this.userExtraRoleDao.getRoleCodeColumnForJoinUser()));
            if (i >= approverRoleSet.size() - 1) continue;
            sb.append(PfmUserDao.or());
        }
        sb.append(PfmUserDao.rightParenthesis());
        sb.append(PfmUserDao.rightParenthesis());
        return sb.toString();
    }

    public int setParamsForApprover(int index, Date targetDate, PreparedStatement ps) throws MospException {
        Set approverRoleSet = RoleUtility.getApproverRoles((MospParams)this.mospParams);
        if (approverRoleSet.isEmpty()) {
            return index;
        }
        int idx = index;
        this.setParam(idx++, targetDate, false, ps);
        for (String approverRole : approverRoleSet) {
            this.setParam(idx++, approverRole, ps);
            this.setParam(idx++, approverRole, ps);
        }
        return idx;
    }

    public Map<String, Object> getParamsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    protected UserMasterDtoInterface castDto(BaseDtoInterface baseDto) {
        return (UserMasterDtoInterface)baseDto;
    }
}

