/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.bean.workflow.SubApproverRegistBeanInterface;
import jp.mosp.platform.dao.workflow.SubApproverDaoInterface;
import jp.mosp.platform.dto.workflow.SubApproverDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PftSubApproverDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class SubApproverRegistBean
extends PlatformHumanBean
implements SubApproverRegistBeanInterface {
    protected SubApproverDaoInterface dao;
    protected static final String FORMAT_MESSAGE_NO = "0000000000";

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (SubApproverDaoInterface)this.createDaoInstance(SubApproverDaoInterface.class);
    }

    public SubApproverDtoInterface getInitDto() {
        return new PftSubApproverDto();
    }

    public void insert(SubApproverDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setSubApproverNo(this.issueSequenceNo(this.dao.getMaxMessageNo(), FORMAT_MESSAGE_NO));
        dto.setPftSubApproverId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(SubApproverDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPftSubApproverId());
        dto.setPftSubApproverId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(SubApproverDtoInterface dto) throws MospException {
        this.checkSubApproverDuplicate(dto);
    }

    protected void checkUpdate(SubApproverDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPftSubApproverId());
        this.checkSubApproverDuplicate(dto);
    }

    protected void checkSubApproverDuplicate(SubApproverDtoInterface dto) throws MospException {
        List list = this.dao.findForTerm(dto.getPersonalId(), dto.getWorkflowType(), dto.getStartDate(), dto.getEndDate());
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1 && ((SubApproverDtoInterface)list.get(0)).getSubApproverNo().equals(dto.getSubApproverNo())) {
            return;
        }
        PfMessageUtility.addErrorTermOverlap((MospParams)this.mospParams, (String)PfNameUtility.substitute((MospParams)this.mospParams));
    }

    protected void validate(SubApproverDtoInterface dto) throws MospException {
        if (!this.checkDateOrder(dto.getStartDate(), dto.getEndDate(), true)) {
            PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)PfNameUtility.substituteEndDate((MospParams)this.mospParams), (String)PfNameUtility.substituteStartDate((MospParams)this.mospParams));
        }
    }
}

