/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationSearchBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dao.workflow.RouteApplicationDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;

public class RouteApplicationSearchBean
extends PlatformBean
implements RouteApplicationSearchBeanInterface {
    protected RouteApplicationDaoInterface dao;
    private Date activateDate;
    private String routeApplicationCode;
    private String routeApplicationName;
    private String workflowType;
    private String routeCode;
    private String routeName;
    private String employeeCode;
    private String approverEmployeeCode;
    private String inactivateFlag;

    public void initBean() throws MospException {
        this.dao = (RouteApplicationDaoInterface)this.createDaoInstance(RouteApplicationDaoInterface.class);
    }

    public List<RouteApplicationDtoInterface> getSearchList() throws MospException {
        HumanDtoInterface humanDto;
        ArrayList<String> listPersonId;
        ArrayList<RouteApplicationDtoInterface> listTmp;
        Map param = this.dao.getParamsMap();
        param.put("activateDate", this.activateDate);
        param.put("routeApplicationCode", this.routeApplicationCode);
        param.put("routeApplicationName", this.routeApplicationName);
        param.put("workflowType", this.workflowType);
        param.put("routeCode", this.routeCode);
        param.put("routeName", this.routeName);
        param.put("inactivateFlag", this.inactivateFlag);
        param.put("employeeCode", this.employeeCode);
        param.put("approverEmployeeCode", this.approverEmployeeCode);
        List list = this.dao.findForSearch(param);
        if (this.employeeCode.isEmpty() && this.approverEmployeeCode.isEmpty()) {
            return list;
        }
        HumanReferenceBeanInterface humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        WorkflowIntegrateBeanInterface workflow = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
        List humanList = humanReference.getHumanList(this.activateDate);
        if (!this.employeeCode.isEmpty()) {
            listTmp = new ArrayList<RouteApplicationDtoInterface>();
            listPersonId = new ArrayList<String>();
            for (int i = 0; i < humanList.size(); ++i) {
                humanDto = (HumanDtoInterface)humanList.get(i);
                if (!humanDto.getEmployeeCode().equals(this.employeeCode)) continue;
                listPersonId.add(humanDto.getPersonalId());
            }
            for (RouteApplicationDtoInterface routeApplicationDto : list) {
                for (String personalId : listPersonId) {
                    if (!routeApplicationDto.getPersonalIds().contains(personalId) || listTmp.contains(routeApplicationDto)) continue;
                    listTmp.add(routeApplicationDto);
                }
            }
            list.clear();
            if (listTmp.size() != 0) {
                list.addAll(listTmp);
            }
        }
        if (!this.approverEmployeeCode.isEmpty()) {
            listTmp = new ArrayList();
            listPersonId = new ArrayList();
            for (int i = 0; i < humanList.size(); ++i) {
                humanDto = (HumanDtoInterface)humanList.get(i);
                if (!humanDto.getEmployeeCode().equals(this.approverEmployeeCode)) continue;
                listPersonId.add(humanDto.getPersonalId());
            }
            for (RouteApplicationDtoInterface routeApplicationDto : list) {
                for (String personalId : listPersonId) {
                    for (String routeCode : workflow.getApproverRouteSet(personalId, this.activateDate)) {
                        if (!routeCode.contains(routeApplicationDto.getRouteCode()) || listTmp.contains(routeApplicationDto)) continue;
                        listTmp.add(routeApplicationDto);
                    }
                }
            }
            list.clear();
            if (listTmp.size() != 0) {
                list.addAll(listTmp);
            }
        }
        return list;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setApproverEmployeeCode(String approverEmployeeCode) {
        this.approverEmployeeCode = approverEmployeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setInactivateFlag(String inactivateFlag) {
        this.inactivateFlag = inactivateFlag;
    }

    public void setRouteApplicationCode(String routeApplicationCode) {
        this.routeApplicationCode = routeApplicationCode;
    }

    public void setRouteApplicationName(String routeApplicationName) {
        this.routeApplicationName = routeApplicationName;
    }

    public void setRouteCode(String routeCode) {
        this.routeCode = routeCode;
    }

    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }

    public void setWorkflowType(String workflowType) {
        this.workflowType = workflowType;
    }
}

