/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.dao.workflow.ApprovalUnitDaoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;

public class ApprovalUnitReferenceBean
extends PlatformBean
implements ApprovalUnitReferenceBeanInterface {
    protected ApprovalUnitDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (ApprovalUnitDaoInterface)this.createDaoInstance(ApprovalUnitDaoInterface.class);
    }

    public ApprovalUnitDtoInterface findForKey(String unitCode, Date activateDate) throws MospException {
        return this.dao.findForKey(unitCode, activateDate);
    }

    public ApprovalUnitDtoInterface getApprovalUnitInfo(String unitCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(unitCode, targetDate);
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        int codeLength = 0;
        for (ApprovalUnitDtoInterface dto : list) {
            if (dto.getUnitCode().length() <= codeLength) continue;
            codeLength = dto.getUnitCode().length();
        }
        for (ApprovalUnitDtoInterface dto : list) {
            array[idx][0] = dto.getUnitCode();
            array[idx][1] = this.getCodedName(dto.getUnitCode(), dto.getUnitName(), codeLength);
            ++idx;
        }
        return array;
    }

    public String getUnitName(String unitCode, Date targetDate) throws MospException {
        ApprovalUnitDtoInterface dto = this.getApprovalUnitInfo(unitCode, targetDate);
        if (dto == null) {
            return unitCode;
        }
        return dto.getUnitName();
    }

    public List<ApprovalUnitDtoInterface> getApprovalUnitHistory(String unitCode) throws MospException {
        return this.dao.findForHistory(unitCode);
    }

    public Set<String> getUnitSetForPersonalId(String personalId, Date targetDate) throws MospException {
        return this.getUnitSet(this.dao.findForApproverPersonalId(personalId, targetDate));
    }

    public Set<String> getUnitSetForMaster(String sectionCode, String positionCode, Date targetDate) throws MospException {
        return this.getUnitSet(this.dao.findForApproverSection(sectionCode, positionCode, targetDate));
    }

    protected Set<String> getUnitSet(List<ApprovalUnitDtoInterface> list) {
        HashSet<String> set = new HashSet<String>();
        for (ApprovalUnitDtoInterface dto : list) {
            set.add(dto.getUnitCode());
        }
        return set;
    }

    public boolean hasPersonalUnit(String personalId, Date startDate, Date endDate) throws MospException {
        List list = this.dao.findPersonTerm(personalId, startDate, endDate);
        return !list.isEmpty();
    }
}

