/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitRegistBeanInterface;
import jp.mosp.platform.dao.workflow.ApprovalRouteDaoInterface;
import jp.mosp.platform.dao.workflow.ApprovalRouteUnitDaoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteUnitDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfaApprovalRouteUnitDto;

public class ApprovalRouteUnitRegistBean
extends PlatformBean
implements ApprovalRouteUnitRegistBeanInterface {
    protected ApprovalRouteUnitDaoInterface dao;
    protected ApprovalRouteDaoInterface routeDao;

    public void initBean() throws MospException {
        this.dao = (ApprovalRouteUnitDaoInterface)this.createDaoInstance(ApprovalRouteUnitDaoInterface.class);
        this.routeDao = (ApprovalRouteDaoInterface)this.createDaoInstance(ApprovalRouteDaoInterface.class);
    }

    public ApprovalRouteUnitDtoInterface getInitDto() {
        return new PfaApprovalRouteUnitDto();
    }

    public void add(ApprovalRouteUnitDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaApprovalRouteUnitId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(ApprovalRouteUnitDtoInterface dto) throws MospException {
        dto.setPfaApprovalRouteUnitId(this.getRecordID(dto));
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaApprovalRouteUnitId());
    }

    public void insert(ApprovalRouteUnitDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaApprovalRouteUnitId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(ApprovalRouteUnitDtoInterface dto) throws MospException {
        dto.setPfaApprovalRouteUnitId(this.getRecordID(dto));
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaApprovalRouteUnitId());
        dto.setPfaApprovalRouteUnitId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        for (String code : this.getCodeList(idArray)) {
            List routeUnitList;
            ApprovalRouteDtoInterface routeDto = this.routeDao.findForKey(code, activateDate);
            if (routeDto == null) {
                routeDto = this.routeDao.findForInfo(code, activateDate);
                if (routeDto == null) continue;
                routeUnitList = this.dao.findForRouteList(code, routeDto.getActivateDate());
                for (ApprovalRouteUnitDtoInterface routeUnitDto : routeUnitList) {
                    routeUnitDto.setActivateDate(activateDate);
                    routeUnitDto.setInactivateFlag(inactivateFlag);
                    this.checkAdd(routeUnitDto);
                    if (this.mospParams.hasErrorMessage()) continue;
                    routeUnitDto.setPfaApprovalRouteUnitId(this.dao.nextRecordId());
                    this.dao.insert((BaseDtoInterface)routeUnitDto);
                }
                continue;
            }
            routeUnitList = this.dao.findForRouteList(code, activateDate);
            for (ApprovalRouteUnitDtoInterface routeUnitDto : routeUnitList) {
                routeUnitDto.setInactivateFlag(inactivateFlag);
                this.checkUpdate(routeUnitDto);
                if (this.mospParams.hasErrorMessage()) continue;
                this.logicalDelete((BaseDaoInterface)this.dao, routeUnitDto.getPfaApprovalRouteUnitId());
                routeUnitDto.setPfaApprovalRouteUnitId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)routeUnitDto);
            }
        }
    }

    protected void checkAdd(ApprovalRouteUnitDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getRouteCode(), dto.getActivateDate(), dto.getApprovalStage()));
    }

    protected void validate(ApprovalRouteUnitDtoInterface dto) {
    }

    protected void checkInsert(ApprovalRouteUnitDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getRouteCode(), dto.getApprovalStage()));
    }

    protected long getRecordID(ApprovalRouteUnitDtoInterface dto) throws MospException {
        ApprovalRouteUnitDtoInterface subDto = this.dao.findForKey(dto.getRouteCode(), dto.getActivateDate(), dto.getApprovalStage());
        return subDto.getPfaApprovalRouteUnitId();
    }

    private void checkDelete(ApprovalRouteUnitDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaApprovalRouteUnitId());
    }

    protected void checkUpdate(ApprovalRouteUnitDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaApprovalRouteUnitId());
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            ApprovalRouteDtoInterface dto = (ApprovalRouteDtoInterface)this.routeDao.findForKey(id, false);
            list.add(dto.getRouteCode());
        }
        return list;
    }
}

