/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.system.WorkPlaceRegistBeanInterface;
import jp.mosp.platform.dao.system.WorkPlaceDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmWorkPlaceDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class WorkPlaceRegistBean
extends PlatformBean
implements WorkPlaceRegistBeanInterface {
    protected static final int LEN_POSTAL_CODE_1 = 3;
    protected static final int LEN_POSTAL_CODE_2 = 4;
    protected WorkPlaceDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (WorkPlaceDaoInterface)this.createDaoInstance(WorkPlaceDaoInterface.class);
    }

    public WorkPlaceDtoInterface getInitDto() {
        return new PfmWorkPlaceDto();
    }

    public void insert(WorkPlaceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmWorkPlaceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(WorkPlaceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmWorkPlaceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(WorkPlaceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmWorkPlaceId());
        dto.setPfmWorkPlaceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            WorkPlaceDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    PfMessageUtility.addErrorCodeNotExistBeforeDate((MospParams)this.mospParams, (String)code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmWorkPlaceId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmWorkPlaceId());
            dto.setPfmWorkPlaceId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkDelete((WorkPlaceDtoInterface)this.dao.findForKey(id, true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void checkInsert(WorkPlaceDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getWorkPlaceCode()));
    }

    protected void checkAdd(WorkPlaceDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getWorkPlaceCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkPlaceCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkPlaceCode(), humanList);
    }

    protected void checkUpdate(WorkPlaceDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmWorkPlaceId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmWorkPlaceId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkPlaceCode());
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkPlaceCode(), humanList);
    }

    protected void checkDelete(WorkPlaceDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmWorkPlaceId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkPlaceCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getWorkPlaceCode(), humanList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            WorkPlaceDtoInterface dto = (WorkPlaceDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getWorkPlaceCode());
        }
        return list;
    }

    protected void checkCodeIsUsed(String code, List<HumanDtoInterface> list) {
        for (HumanDtoInterface dto : list) {
            if (!code.equals(dto.getWorkPlaceCode())) continue;
            PfMessageUtility.addErrorCodeIsUsed((MospParams)this.mospParams, (String)code, (String)dto.getEmployeeCode());
        }
    }

    protected void validate(WorkPlaceDtoInterface dto) {
        StringBuilder sb;
        if (!MospUtility.isEmpty((String[])new String[]{dto.getPostalCode1()})) {
            sb = new StringBuilder(PfNameUtility.postalCode((MospParams)this.mospParams));
            sb.append(PfNameUtility.parentheses((MospParams)this.mospParams, (String)PfNameUtility.digit((MospParams)this.mospParams, (int)3)));
            this.checkInputLength(dto.getPostalCode1(), 3, sb.toString());
        }
        if (!MospUtility.isEmpty((String[])new String[]{dto.getPostalCode2()})) {
            sb = new StringBuilder(PfNameUtility.postalCode((MospParams)this.mospParams));
            sb.append(PfNameUtility.parentheses((MospParams)this.mospParams, (String)PfNameUtility.digit((MospParams)this.mospParams, (int)4)));
            this.checkInputLength(dto.getPostalCode2(), 4, sb.toString());
        }
    }
}

