/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.dao.system.WorkPlaceDaoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;

public class WorkPlaceReferenceBean
extends PlatformBean
implements WorkPlaceReferenceBeanInterface {
    protected WorkPlaceDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (WorkPlaceDaoInterface)this.createDaoInstance(WorkPlaceDaoInterface.class);
    }

    public WorkPlaceDtoInterface getWorkPlaceInfo(String workPlaceCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(workPlaceCode, targetDate);
    }

    public String getWorkPlaceName(String workPlaceCode, Date targetDate) throws MospException {
        WorkPlaceDtoInterface dto = this.getWorkPlaceInfo(workPlaceCode, targetDate);
        if (dto == null) {
            return "";
        }
        return dto.getWorkPlaceName();
    }

    public String getWorkPlaceAbbr(String workPlaceCode, Date targetDate) throws MospException {
        WorkPlaceDtoInterface dto = this.getWorkPlaceInfo(workPlaceCode, targetDate);
        if (dto == null) {
            return "";
        }
        return dto.getWorkPlaceAbbr();
    }

    public List<WorkPlaceDtoInterface> getHistory(String workPlaceCode) throws MospException {
        return this.dao.findForHistory(workPlaceCode);
    }

    public List<WorkPlaceDtoInterface> getWorkPlaceList(Date targetDate, String operationType) throws MospException {
        String[] rangeArray = this.getRangeWorkPlace(operationType, targetDate);
        return this.dao.findForActivateDate(targetDate, rangeArray);
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, false, false);
    }

    public String[][] getNameSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, true, false);
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, true, true);
    }

    public String[][] getCodedAbbrSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, false, true);
    }

    public WorkPlaceDtoInterface findForKey(String workPlaceCode, Date activateDate) throws MospException {
        return this.dao.findForKey(workPlaceCode, activateDate);
    }

    protected String[][] getSelectArray(Date targetDate, boolean needBlank, String operationType, boolean isName, boolean viewCode) throws MospException {
        List list = this.getWorkPlaceList(targetDate, operationType);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (WorkPlaceDtoInterface dto : list) {
            array[idx][0] = dto.getWorkPlaceCode();
            if (isName && viewCode) {
                array[idx++][1] = this.getCodedName(dto.getWorkPlaceCode(), dto.getWorkPlaceName(), length);
                continue;
            }
            if (isName) {
                array[idx++][1] = dto.getWorkPlaceName();
                continue;
            }
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getWorkPlaceCode(), dto.getWorkPlaceAbbr(), length);
                continue;
            }
            array[idx++][1] = dto.getWorkPlaceAbbr();
        }
        return array;
    }

    protected int getMaxCodeLength(List<WorkPlaceDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (WorkPlaceDtoInterface dto : list) {
            if (dto.getWorkPlaceCode().length() <= length) continue;
            length = dto.getWorkPlaceCode().length();
        }
        return length;
    }
}

