/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.Date;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.dao.system.UserPasswordDaoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.platform.dto.system.impl.PfaUserPasswordDto;
import jp.mosp.platform.utils.PfNameUtility;

public class UserPasswordRegistBean
extends PlatformBean
implements UserPasswordRegistBeanInterface {
    protected static final int LEN_PASSWORD = 50;
    protected UserPasswordDaoInterface dao;
    protected UserCheckBeanInterface userCheck;
    protected PasswordCheckBeanInterface passwordCheck;

    public void initBean() throws MospException {
        this.dao = (UserPasswordDaoInterface)this.createDaoInstance(UserPasswordDaoInterface.class);
        this.userCheck = (UserCheckBeanInterface)this.createBeanInstance(UserCheckBeanInterface.class);
        this.passwordCheck = (PasswordCheckBeanInterface)this.createBeanInstance(PasswordCheckBeanInterface.class);
    }

    public UserPasswordDtoInterface getInitDto() {
        return new PfaUserPasswordDto();
    }

    public void regist(UserPasswordDtoInterface dto) throws MospException {
        this.delete(dto.getUserId());
        dto.setPfaUserPasswordId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(String userId, Date changeDate, String password) throws MospException {
        UserPasswordDtoInterface dto = this.getInitDto();
        dto.setUserId(userId);
        dto.setChangeDate(changeDate);
        dto.setPassword(password);
        this.regist(dto);
    }

    public void delete(String userId) throws MospException {
        UserPasswordDtoInterface dto = this.dao.findForInfo(userId);
        if (dto != null) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaUserPasswordId());
        }
    }

    public void initPassword(Set<String> userIdList) throws MospException {
        Date changeDate = this.getSystemDate();
        for (String userId : userIdList) {
            this.initPassword(userId, changeDate);
        }
    }

    public void initPassword(String userId, Date changeDate) throws MospException {
        UserPasswordDtoInterface dto = this.getInitDto();
        dto.setUserId(userId);
        dto.setChangeDate(changeDate);
        dto.setPassword(this.getInitialPassword(userId));
        this.regist(dto);
    }

    protected String getInitialPassword(String userId) throws MospException {
        return this.passwordCheck.getEncryptedInitialPassword(userId);
    }

    public void validate(UserPasswordDtoInterface dto, Integer row) throws MospException {
        String nameUserId = PfNameUtility.userId((MospParams)this.mospParams);
        String nameChangeDate = PfNameUtility.changeDate((MospParams)this.mospParams);
        String namePassword = PfNameUtility.password((MospParams)this.mospParams);
        this.checkRequired((Object)dto.getUserId(), nameUserId, row);
        this.checkRequired((Object)dto.getChangeDate(), nameChangeDate, row);
        this.checkRequired((Object)dto.getPassword(), namePassword, row);
        this.checkLength(dto.getPassword(), 50, namePassword, row);
        this.userCheck.checkUserExist(dto.getUserId(), row);
    }
}

