/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.Date;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterRegistBeanInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmUserDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class UserMasterRegistBean
extends PlatformBean
implements UserMasterRegistBeanInterface {
    protected static final int LEN_USER_ID = 50;
    protected UserMasterDaoInterface dao;
    protected RoleReferenceBeanInterface roleRefer;

    public void initBean() throws MospException {
        this.dao = (UserMasterDaoInterface)this.createDaoInstance(UserMasterDaoInterface.class);
        this.roleRefer = (RoleReferenceBeanInterface)this.createBeanInstance(RoleReferenceBeanInterface.class);
    }

    public UserMasterDtoInterface getInitDto() {
        return new PfmUserDto();
    }

    public void insert(UserMasterDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmUserId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(UserMasterDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmUserId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(UserMasterDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmUserId());
        dto.setPfmUserId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(UserMasterDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmUserId());
    }

    protected void checkInsert(UserMasterDtoInterface dto) throws MospException {
        String userId = dto.getUserId();
        if (!this.dao.findForHistory(dto.getUserId()).isEmpty()) {
            PfMessageUtility.addErrorUserIdExist((MospParams)this.mospParams, (String)userId);
        }
    }

    protected void checkAdd(UserMasterDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getUserId(), dto.getActivateDate()));
    }

    protected void checkUpdate(UserMasterDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmUserId());
    }

    protected void checkDelete(UserMasterDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmUserId());
    }

    protected void checkUser(UserMasterDtoInterface dto) throws MospException {
        UserCheckBeanInterface userCheck = (UserCheckBeanInterface)this.createBean(UserCheckBeanInterface.class);
        userCheck.checkRoleExist(dto.getRoleCode(), dto.getActivateDate());
        userCheck.checkUserEmployee(dto.getPersonalId(), dto.getActivateDate());
    }

    public void validate(UserMasterDtoInterface dto, Integer row) throws MospException {
        String nameUserId = PfNameUtility.userId((MospParams)this.mospParams);
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            this.checkUser(dto);
        }
        this.checkRequired((Object)dto.getUserId(), nameUserId, row);
        this.checkUserId(dto.getUserId(), nameUserId, row);
        this.checkRequired((Object)dto.getActivateDate(), PfNameUtility.activateDate((MospParams)this.mospParams), row);
        this.checkLength(dto.getUserId(), 50, nameUserId, row);
        this.checkRole(dto.getRoleCode(), dto.getActivateDate(), row);
    }

    protected void checkRole(String roleCode, Date targetDate, Integer row) throws MospException {
        String[][] aryRole;
        for (String[] role : aryRole = this.roleRefer.getSelectArray(targetDate, false)) {
            if (!role[0].equals(roleCode)) continue;
            return;
        }
        PfMessageUtility.addErrorRoleCodeNotExist((MospParams)this.mospParams, (String)roleCode, (Integer)row);
    }
}

