/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserExtraRoleReferenceBeanInterface;
import jp.mosp.platform.dao.system.UserExtraRoleDaoInterface;
import jp.mosp.platform.dto.system.UserExtraRoleDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;

public class UserExtraRoleReferenceBean
extends PlatformBean
implements UserExtraRoleReferenceBeanInterface {
    protected UserExtraRoleDaoInterface dao;
    protected RoleReferenceBeanInterface roleRefer;

    public void initBean() throws MospException {
        this.dao = (UserExtraRoleDaoInterface)this.createDaoInstance(UserExtraRoleDaoInterface.class);
        this.roleRefer = (RoleReferenceBeanInterface)this.createBeanInstance(RoleReferenceBeanInterface.class);
    }

    public Map<String, String> getUserExtraRoleMap(String userId, Date activateDate) throws MospException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map dtos = this.getUserExtraRolesAsMap(userId, activateDate);
        List roleTypes = this.roleRefer.getAvailableRoleTypes(activateDate);
        for (String roleType : roleTypes) {
            UserExtraRoleDtoInterface dto = (UserExtraRoleDtoInterface)dtos.get(roleType);
            if (dto == null) continue;
            map.put(roleType, dto.getRoleCode());
        }
        return map;
    }

    public Set<String> getUserExtraRoles(String userId, Date activateDate) throws MospException {
        return new HashSet<String>(this.getUserExtraRoleMap(userId, activateDate).values());
    }

    public boolean isTheRoleCodeSet(UserMasterDtoInterface dto, String roleCode) throws MospException {
        Set userRoles = this.getUserRoles(dto);
        return userRoles.contains(roleCode);
    }

    public boolean isTheRoleCodeSet(UserMasterDtoInterface dto, Set<String> roleCodes) throws MospException {
        if (roleCodes == null || roleCodes.isEmpty()) {
            return false;
        }
        Set userRoles = this.getUserRoles(dto);
        for (String userRole : userRoles) {
            if (!roleCodes.contains(userRole)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, UserExtraRoleDtoInterface> getUserExtraRolesAsMap(String userId, Date activateDate) throws MospException {
        HashMap<String, UserExtraRoleDtoInterface> map = new HashMap<String, UserExtraRoleDtoInterface>();
        List dtos = this.dao.findForUser(userId, activateDate);
        for (UserExtraRoleDtoInterface dto : dtos) {
            map.put(dto.getRoleType(), dto);
        }
        return map;
    }

    protected Set<String> getUserRoles(UserMasterDtoInterface dto) throws MospException {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (dto == null) {
            return set;
        }
        set.add(dto.getRoleCode());
        set.addAll(this.getUserExtraRoles(dto.getUserId(), dto.getActivateDate()));
        return set;
    }
}

