/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionRegistBeanInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmSectionDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class SectionRegistBean
extends PlatformFileBean
implements SectionRegistBeanInterface {
    protected static final int LEN_SECTION_CODE = 10;
    protected static final int LEN_SECTION_NAME = 40;
    protected static final int LEN_SECTION_ABBR = 6;
    protected static final int LEN_SECTION_DISPLAY = 16;
    protected SectionDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (SectionDaoInterface)this.createDaoInstance(SectionDaoInterface.class);
    }

    public SectionDtoInterface getInitDto() {
        return new PfmSectionDto();
    }

    public void insert(SectionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmSectionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(SectionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        this.checkClassRouteForAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmSectionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(SectionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        this.checkClassRouteForUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmSectionId());
        dto.setPfmSectionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            SectionDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    PfMessageUtility.addErrorCodeNotExistBeforeDate((MospParams)this.mospParams, (String)code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto, null);
                this.checkAdd(dto);
                this.checkClassRouteForAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmSectionId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto, null);
            this.checkUpdate(dto);
            this.checkClassRouteForUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmSectionId());
            dto.setPfmSectionId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void update(long[] idArray, Date activateDate, String classRoute) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            SectionDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    PfMessageUtility.addErrorCodeNotExistBeforeDate((MospParams)this.mospParams, (String)code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setClassRoute(classRoute);
                this.validate(dto, null);
                this.checkAdd(dto);
                this.checkClassRouteForAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmSectionId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setClassRoute(classRoute);
            this.validate(dto, null);
            this.checkUpdate(dto);
            this.checkClassRouteForUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmSectionId());
            dto.setPfmSectionId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            SectionDtoInterface dto = (SectionDtoInterface)this.dao.findForKey(id, true);
            this.checkDelete(dto);
            this.checkClassRouteForDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void checkInsert(SectionDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getSectionCode()));
    }

    protected void checkAdd(SectionDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getSectionCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getSectionCode(), concurrentList);
    }

    protected void checkUpdate(SectionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmSectionId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmSectionId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getSectionCode(), concurrentList);
    }

    protected void checkDelete(SectionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmSectionId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getSectionCode(), concurrentList);
    }

    protected void checkClassRouteForAdd(SectionDtoInterface dto) throws MospException {
        this.checkClassRouteContainSelf(dto);
        SectionDtoInterface beforeDto = this.dao.findForInfo(dto.getSectionCode(), dto.getActivateDate());
        if (beforeDto == null || !this.isDtoActivate((BaseDtoInterface)beforeDto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)beforeDto) && !this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (this.isDtoActivate((BaseDtoInterface)beforeDto) && this.isDtoActivate((BaseDtoInterface)dto) && beforeDto.getClassRoute().equals(dto.getClassRoute())) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        this.checkCodeIsUsedAsClassRoute(dto.getSectionCode(), this.getSectionListForCheck((PlatformDtoInterface)dto, list));
    }

    protected void checkClassRouteForUpdate(SectionDtoInterface dto) throws MospException {
        SectionDtoInterface currentDto = this.dao.findForKey(dto.getSectionCode(), dto.getActivateDate());
        if (!this.isDtoActivate((BaseDtoInterface)currentDto) && !this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        this.checkClassRouteContainSelf(dto);
        if (this.isDtoActivate((BaseDtoInterface)currentDto) && this.isDtoActivate((BaseDtoInterface)dto) && currentDto.getClassRoute().equals(dto.getClassRoute())) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        this.checkCodeIsUsedAsClassRoute(dto.getSectionCode(), this.getSectionListForCheck((PlatformDtoInterface)dto, list));
    }

    protected void checkClassRouteForDelete(SectionDtoInterface dto) throws MospException {
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        SectionDtoInterface beforeDto = this.dao.findForInfo(dto.getSectionCode(), DateUtility.addDay((Date)dto.getActivateDate(), (int)-1));
        if (beforeDto != null && this.isDtoActivate((BaseDtoInterface)beforeDto) && beforeDto.getClassRoute().equals(dto.getClassRoute())) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        this.checkCodeIsUsedAsClassRoute(dto.getSectionCode(), this.getSectionListForCheck((PlatformDtoInterface)dto, list));
    }

    protected List<SectionDtoInterface> getSectionListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        List sectionList = this.dao.findForActivateDate(dto.getActivateDate(), new String[0]);
        sectionList.addAll(this.dao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return sectionList;
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            SectionDtoInterface dto = (SectionDtoInterface)this.dao.findForKey(id, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getSectionCode());
        }
        return list;
    }

    protected void checkCodeIsUsed(SectionDtoInterface sectionDto, List<HumanDtoInterface> list) throws MospException {
        RetirementReferenceBeanInterface refer = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        String sectionCode = sectionDto.getSectionCode();
        for (HumanDtoInterface humanDto : list) {
            if (!humanDto.getSectionCode().equals(sectionCode) || refer.isRetired(humanDto.getPersonalId(), sectionDto.getActivateDate())) continue;
            PfMessageUtility.addErrorCodeIsUsed((MospParams)this.mospParams, (String)sectionCode, (String)humanDto.getEmployeeCode());
        }
    }

    protected void checkConcurrentCodeIsUsed(String code, List<ConcurrentDtoInterface> list) throws MospException {
        for (ConcurrentDtoInterface ConcurrentDto : list) {
            if (!code.equals(ConcurrentDto.getSectionCode())) continue;
            HumanDtoInterface humanDto = this.getHumanInfo(ConcurrentDto.getPersonalId(), ConcurrentDto.getStartDate());
            PfMessageUtility.addErrorCodeIsUsed((MospParams)this.mospParams, (String)code, (String)humanDto.getEmployeeCode());
        }
    }

    protected void checkCodeIsUsedAsClassRoute(String code, List<?> list) {
        String classRoute = "," + code + ",";
        for (int i = 0; i < list.size(); ++i) {
            SectionDtoInterface dto = (SectionDtoInterface)list.get(i);
            if (dto.getClassRoute().indexOf(classRoute) == -1) continue;
            PfMessageUtility.addErrorSectionIsUsed((MospParams)this.mospParams, (String)code, (String)dto.getSectionCode());
        }
    }

    protected void checkClassRouteContainSelf(SectionDtoInterface dto) {
        String classRoute = "," + dto.getSectionCode() + ",";
        if (dto.getClassRoute().indexOf(classRoute) != -1) {
            PfMessageUtility.addErrorRouteContainsItself((MospParams)this.mospParams);
        }
    }

    protected void validate(SectionDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getSectionCode(), PfNameUtility.sectionCode((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getActivateDate(), PfNameUtility.activateDate((MospParams)this.mospParams), row);
        this.checkLength(dto.getSectionCode(), 10, PfNameUtility.sectionCode((MospParams)this.mospParams), row);
        this.checkLength(dto.getSectionName(), 40, PfNameUtility.sectionName((MospParams)this.mospParams), row);
        this.checkLength(dto.getSectionDisplay(), 16, PfNameUtility.sectionDisplayName((MospParams)this.mospParams), row);
        this.checkByteLength(dto.getSectionAbbr(), 6, PfNameUtility.sectionAbbreviation((MospParams)this.mospParams), row);
        this.checkTypeCode(dto.getSectionCode(), PfNameUtility.sectionCode((MospParams)this.mospParams), row);
        this.checkInactivateFlag(dto.getCloseFlag(), row);
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        this.checkRequired((Object)dto.getSectionName(), PfNameUtility.sectionName((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getSectionAbbr(), PfNameUtility.sectionAbbreviation((MospParams)this.mospParams), row);
    }
}

