/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.RangeProperty;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.ConcurrentReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;

public class SectionReferenceBean
extends PlatformBean
implements SectionReferenceBeanInterface {
    public static final String APP_SECTION_PULLDOWN_NAME = "SectionPulldownName";
    public static final String SECTION_PULLDOWN_NAME_DISPLAY = "Display";
    protected static final String CONCAT_CLASS_ROUTE = ">";
    protected static final String STR_SECTION_LEVEL = "-";
    protected SectionDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (SectionDaoInterface)this.createDaoInstance(SectionDaoInterface.class);
    }

    public List<SectionDtoInterface> getHigherSectionList(String sectionCode, Date targetDate) throws MospException {
        SectionDtoInterface dto = this.getSectionInfo(sectionCode, targetDate);
        ArrayList<SectionDtoInterface> higherList = new ArrayList<SectionDtoInterface>();
        if (dto != null) {
            String[] aryClassRoute = this.getClassRouteArray(dto.getClassRoute());
            for (int i = aryClassRoute.length - 1; i >= 0; --i) {
                SectionDtoInterface sectionDto = this.getSectionInfo(aryClassRoute[i], targetDate);
                if (sectionDto == null) continue;
                higherList.add(sectionDto);
            }
        }
        return higherList;
    }

    public List<SectionDtoInterface> getSectionHistory(String sectionCode) throws MospException {
        return this.dao.findForHistory(sectionCode);
    }

    public SectionDtoInterface getSectionInfo(String sectionCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(sectionCode, targetDate);
    }

    public String getSectionName(String sectionCode, Date targetDate) throws MospException {
        SectionDtoInterface dto = this.getSectionInfo(sectionCode, targetDate);
        if (dto == null) {
            return sectionCode;
        }
        return dto.getSectionName();
    }

    public String getSectionAbbr(String sectionCode, Date targetDate) throws MospException {
        SectionDtoInterface dto = this.getSectionInfo(sectionCode, targetDate);
        if (dto == null) {
            return sectionCode;
        }
        return dto.getSectionAbbr();
    }

    public String getSectionDisplay(String sectionCode, Date targetDate) throws MospException {
        SectionDtoInterface dto = this.getSectionInfo(sectionCode, targetDate);
        if (dto == null) {
            return sectionCode;
        }
        return dto.getSectionDisplay();
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, false, false, operationType);
    }

    public String[][] getNameSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, true, false, operationType);
    }

    public String[][] getCodedAbbrSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, false, true, operationType);
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, true, true, operationType);
    }

    public String[][] getSelectArrayForMaintenance(Date targetDate) throws MospException {
        List list = this.dao.findForActivateDate(targetDate, this.getRangeSection(null, targetDate));
        String[][] array = new String[list.size() + 1][2];
        int idx = 0;
        array[idx][0] = ",";
        array[idx++][1] = PfNameUtility.registAsGreatest((MospParams)this.mospParams);
        for (SectionDtoInterface dto : list) {
            array[idx][0] = dto.getClassRoute() + dto.getSectionCode() + ",";
            array[idx++][1] = this.getLeveledSectionName(dto);
        }
        return array;
    }

    public String getClassRouteAbbr(SectionDtoInterface dto, Date targetDate) throws MospException {
        String[] sectionArray;
        StringBuffer sb = new StringBuffer();
        for (String sectionCode : sectionArray = this.getClassRouteArray(dto.getClassRoute())) {
            sb.append(this.getSectionAbbr(sectionCode, targetDate));
            sb.append(CONCAT_CLASS_ROUTE);
        }
        sb.append(dto.getSectionAbbr());
        return sb.toString();
    }

    public String[] getClassRouteNameArray(String sectionCode, Date targetDate) throws MospException {
        SectionDtoInterface dto = this.dao.findForInfo(sectionCode, targetDate);
        if (dto == null) {
            return new String[0];
        }
        String[] sectionArray = this.getClassRouteArray(dto.getClassRoute());
        String[] nameArray = new String[sectionArray.length + 1];
        for (int i = 0; i < sectionArray.length; ++i) {
            nameArray[i] = this.getSectionName(sectionArray[i], targetDate);
        }
        nameArray[nameArray.length - 1] = dto.getSectionName();
        return nameArray;
    }

    protected String getLeveledSectionName(SectionDtoInterface dto) {
        StringBuffer sb = new StringBuffer();
        String[] sectionArray = this.getClassRouteArray(dto.getClassRoute());
        int level = sectionArray.length;
        for (int i = 0; i < level; ++i) {
            sb.append(STR_SECTION_LEVEL);
        }
        sb.append(dto.getSectionName());
        return sb.toString();
    }

    public String[] getClassRouteArray(SectionDtoInterface dto) {
        if (dto == null || dto.getClassRoute() == null) {
            return new String[0];
        }
        return this.getClassRouteArray(dto.getClassRoute());
    }

    protected String[] getClassRouteArray(String classRoute) {
        String classRouteForArray = classRoute.substring(1);
        if (classRouteForArray.length() == 0) {
            return new String[0];
        }
        classRouteForArray = classRouteForArray.substring(0, classRouteForArray.length() - 1);
        return classRouteForArray.split(",");
    }

    public SectionDtoInterface findForKey(String sectionCode, Date activateDate) throws MospException {
        return this.dao.findForKey(sectionCode, activateDate);
    }

    public SectionDtoInterface findForkey(long id) throws MospException {
        BaseDto dto = this.findForKey((BaseDaoInterface)this.dao, id, false);
        if (dto != null) {
            return (SectionDtoInterface)dto;
        }
        return null;
    }

    protected String[][] getSelectArray(Date targetDate, boolean needBlank, boolean isName, boolean viewCode, String operationType) throws MospException {
        String[] rangeArray = this.getRangeSection(operationType, targetDate);
        List list = this.dao.findForActivateDate(targetDate, rangeArray = this.addConcurrentSection(operationType, targetDate, rangeArray));
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        boolean useDisplayName = this.useDisplayName();
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (SectionDtoInterface dto : list) {
            String name = "";
            name = isName ? (useDisplayName ? dto.getSectionDisplay() : dto.getSectionName()) : dto.getSectionAbbr();
            array[idx][0] = dto.getSectionCode();
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getSectionCode(), name, length);
                continue;
            }
            array[idx++][1] = name;
        }
        return array;
    }

    protected String[] addConcurrentSection(String operationType, Date targetDate, String[] rangeArray) throws MospException {
        if (operationType == null) {
            return rangeArray;
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return rangeArray;
        }
        String rangeSection = range.getSection();
        if (rangeSection == null || rangeSection.isEmpty()) {
            return rangeArray;
        }
        List rangeSectionList = this.asList(rangeSection, ",");
        if (!rangeSectionList.contains("RangeMyself")) {
            return rangeArray;
        }
        ArrayList<String> rangeList = new ArrayList<String>(MospUtility.asList((String[])rangeArray));
        ConcurrentReferenceBeanInterface concurrentRefer = (ConcurrentReferenceBeanInterface)this.createBean(ConcurrentReferenceBeanInterface.class);
        List concurrentList = concurrentRefer.getConcurrentList(this.mospParams.getUser().getPersonalId(), targetDate);
        for (ConcurrentDtoInterface concurrent : concurrentList) {
            rangeList.add(concurrent.getSectionCode());
        }
        return rangeList.toArray(rangeArray);
    }

    public boolean useDisplayName() {
        return PlatformUtility.isSectionDisplayName((MospParams)this.mospParams);
    }

    protected int getMaxCodeLength(List<SectionDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (SectionDtoInterface dto : list) {
            if (dto.getSectionCode().length() <= length) continue;
            length = dto.getSectionCode().length();
        }
        return length;
    }

    public int getMaxLevel(Date targetDate) throws MospException {
        Map param = this.dao.getParamsMap();
        param.put("targetDate", targetDate);
        param.put("sectionType", "");
        param.put("sectionCode", "");
        param.put("sectionName", "");
        param.put("sectionAbbr", "");
        param.put("closeFlag", 0);
        List list = this.dao.findForSearch(param);
        int maxLevel = 0;
        for (SectionDtoInterface dto : list) {
            String[] route = this.getClassRouteArray(dto.getClassRoute());
            maxLevel = maxLevel < route.length ? route.length : maxLevel;
        }
        return maxLevel;
    }

    public String getHigherSectionCode(String sectionCode, Date targetDate, int level) throws MospException {
        String higherSectionCode = "";
        SectionDtoInterface dto = this.getSectionInfo(sectionCode, targetDate);
        if (dto == null) {
            return higherSectionCode;
        }
        String[] route = this.getClassRouteArray(dto.getClassRoute());
        if (route.length > level) {
            higherSectionCode = route[level];
        }
        return higherSectionCode;
    }

    public Set<String> getSectionCodeSetForCodeRange(String sectionCodeFrom, String sectionCodeTo, Date activateDate) throws MospException {
        List list = this.dao.findForCodeRange(sectionCodeFrom, sectionCodeTo, activateDate);
        return this.getSectionCodeSet(list);
    }

    protected Set<String> getSectionCodeSet(List<SectionDtoInterface> list) {
        HashSet<String> set = new HashSet<String>();
        for (SectionDtoInterface dto : list) {
            set.add(dto.getSectionCode());
        }
        return set;
    }
}

