/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;

public class RoleReferenceBean
extends PlatformBean
implements RoleReferenceBeanInterface {
    protected static final String CODE_KEY_ROLE_TYPE = "RoleType";

    public void initBean() throws MospException {
    }

    public String[][] getSelectArray(Date targetDate, boolean viewCode) throws MospException {
        String roleType = null;
        if (this.isExtraRolesAvailable(targetDate)) {
            roleType = "";
        }
        Map roles = RoleUtility.getRoles((MospParams)this.mospParams, (String)roleType);
        return this.getSelectArray(roles, false, viewCode);
    }

    public Map<String, String[][]> getExtraRoleArrays(Date targetDate, boolean needBlank, boolean viewCode) throws MospException {
        LinkedHashMap<String, String[][]> map = new LinkedHashMap<String, String[][]>();
        List roleTypes = this.getAvailableRoleTypes(targetDate);
        for (String roleType : roleTypes) {
            Map roles = RoleUtility.getRoles((MospParams)this.mospParams, (String)roleType);
            map.put(roleType, this.getSelectArray(roles, needBlank, viewCode));
        }
        return map;
    }

    public String[][] getAllArrays(Date targetDate, boolean needBlank, boolean viewCode) throws MospException {
        String[][] selectArray = this.getSelectArray(targetDate, viewCode);
        Map extraRoleArrays = this.getExtraRoleArrays(targetDate, false, viewCode);
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(selectArray));
        for (String[][] extraRoleArray : extraRoleArrays.values()) {
            list.addAll(Arrays.asList(extraRoleArray));
        }
        return (String[][])list.toArray((T[])new String[list.size()][2]);
    }

    public Set<String> getAvailabeRoleCodes(Date targetDate) throws MospException {
        Map all = RoleUtility.getRoles((MospParams)this.mospParams, null);
        return all.keySet();
    }

    public Set<String> getAvailabeRoleCodes(Date targetDate, String roleType) throws MospException {
        Map roles = RoleUtility.getRoles((MospParams)this.mospParams, (String)roleType);
        return roles.keySet();
    }

    public String[][] getRoleTypeSelectArray(Date targetDate) throws MospException {
        return MospUtility.getCodeArray((MospParams)this.mospParams, (String)CODE_KEY_ROLE_TYPE, (boolean)false);
    }

    public List<String> getAvailableRoleTypes(Date targetDate) throws MospException {
        return MospUtility.getCodeList((MospParams)this.mospParams, (String)CODE_KEY_ROLE_TYPE, (boolean)false);
    }

    public boolean isExtraRolesAvailable(Date targetDate) throws MospException {
        return !this.getAvailableRoleTypes(targetDate).isEmpty();
    }

    protected String[][] getSelectArray(Map<String, String> roles, boolean needBlank, boolean viewCode) throws MospException {
        if (roles == null || roles.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(roles.keySet(), viewCode);
        String[][] array = this.prepareSelectArray(roles.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (Map.Entry<String, String> entry : roles.entrySet()) {
            String code = entry.getKey();
            String name = entry.getValue();
            name = viewCode ? this.getCodedName(code, name, length) : name;
            array[idx][0] = code;
            array[idx++][1] = name;
        }
        return array;
    }

    protected int getMaxCodeLength(Set<String> roleCodes, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (String roleCode : roleCodes) {
            if (roleCode.length() <= length) continue;
            length = roleCode.length();
        }
        return length;
    }
}

