/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.io.InputStream;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.orangesignal.OrangeSignalParams;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.CsvImportBeanInterface;
import jp.mosp.platform.bean.system.PostalCodeRegistBeanInterface;
import jp.mosp.platform.dao.system.PostalCodeDaoInterface;
import jp.mosp.platform.dto.system.PostalCodeDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmPostalCodeDto;

public class PostalCodeRegistBean
extends PlatformBean
implements PostalCodeRegistBeanInterface,
CsvImportBeanInterface {
    protected PostalCodeDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (PostalCodeDaoInterface)this.createDaoInstance(PostalCodeDaoInterface.class);
    }

    public PostalCodeDtoInterface getInitDto() {
        return new PfmPostalCodeDto();
    }

    public void insert(PostalCodeDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmPostalCodeId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public int importCsv(InputStream requestedFile) throws MospException {
        List dataList = OrangeSignalUtility.parse((InputStream)requestedFile, (OrangeSignalParams)new OrangeSignalParams());
        for (String[] data : dataList) {
            int idx = 0;
            PfmPostalCodeDto dto = new PfmPostalCodeDto();
            dto.setPostalCode(data[++idx].trim());
            dto.setPrefectureCode(data[++idx].trim());
            dto.setCityCode(data[++idx].trim());
            dto.setCityName(data[++idx].trim());
            dto.setCityKana(data[++idx].trim());
            dto.setAddressName(data[++idx].trim());
            dto.setAddressKana(data[++idx].trim());
            dto.setInactivateFlag(0);
            dto.setDeleteFlag(0);
            this.insert((PostalCodeDtoInterface)dto);
        }
        return dataList.size();
    }

    protected void checkInsert(PostalCodeDtoInterface dto) throws MospException {
    }

    protected void validate(PostalCodeDtoInterface dto) {
    }
}

