/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionRegistBeanInterface;
import jp.mosp.platform.dao.system.PositionDaoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmPositionDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class PositionRegistBean
extends PlatformFileBean
implements PositionRegistBeanInterface {
    protected static final int LEN_POSITION_CODE = 10;
    protected static final int LEN_POSITION_NAME = 30;
    protected static final int LEN_POSITION_ABBR = 6;
    protected static final int LEN_POSITION_GRADE = 2;
    protected PositionDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (PositionDaoInterface)this.createDaoInstance(PositionDaoInterface.class);
    }

    public PositionDtoInterface getInitDto() {
        return new PfmPositionDto();
    }

    public void insert(PositionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmPositionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(PositionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmPositionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(PositionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmPositionId());
        dto.setPfmPositionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            PositionDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    PfMessageUtility.addErrorCodeNotExistBeforeDate((MospParams)this.mospParams, (String)code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto, null);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmPositionId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto, null);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmPositionId());
            dto.setPfmPositionId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkDelete((PositionDtoInterface)this.dao.findForKey(id, true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void checkInsert(PositionDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPositionCode()));
    }

    protected void checkAdd(PositionDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPositionCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPositionCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getPositionCode(), concurrentList);
    }

    protected void checkUpdate(PositionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmPositionId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmPositionId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPositionCode());
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getPositionCode(), concurrentList);
    }

    protected void checkDelete(PositionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmPositionId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPositionCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        List concurrentList = this.getConcurrentListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto, humanList);
        this.checkConcurrentCodeIsUsed(dto.getPositionCode(), concurrentList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            PositionDtoInterface dto = (PositionDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getPositionCode());
        }
        return list;
    }

    protected void checkCodeIsUsed(PositionDtoInterface positionDto, List<HumanDtoInterface> list) throws MospException {
        RetirementReferenceBeanInterface refer = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        String positionCode = positionDto.getPositionCode();
        for (HumanDtoInterface humanDto : list) {
            if (!humanDto.getPositionCode().equals(positionCode) || refer.isRetired(humanDto.getPersonalId(), positionDto.getActivateDate())) continue;
            PfMessageUtility.addErrorCodeIsUsed((MospParams)this.mospParams, (String)positionCode, (String)humanDto.getEmployeeCode());
        }
    }

    protected void checkConcurrentCodeIsUsed(String code, List<ConcurrentDtoInterface> list) throws MospException {
        for (ConcurrentDtoInterface concurrentDto : list) {
            if (!code.equals(concurrentDto.getPositionCode())) continue;
            HumanDtoInterface humanDto = this.getHumanInfo(concurrentDto.getPersonalId(), concurrentDto.getStartDate());
            PfMessageUtility.addErrorCodeIsUsed((MospParams)this.mospParams, (String)code, (String)humanDto.getEmployeeCode());
        }
    }

    protected void validate(PositionDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getPositionCode(), PfNameUtility.positionCode((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getActivateDate(), PfNameUtility.activateDate((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getPositionName(), PfNameUtility.positionName((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getPositionGrade(), PfNameUtility.positionGrade((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getPositionAbbr(), PfNameUtility.positionAbbreviation((MospParams)this.mospParams), row);
        this.checkLength(dto.getPositionCode(), 10, PfNameUtility.positionCode((MospParams)this.mospParams), row);
        this.checkLength(dto.getPositionName(), 30, PfNameUtility.positionName((MospParams)this.mospParams), row);
        this.checkLength(dto.getPositionGrade(), 2, PfNameUtility.positionGrade((MospParams)this.mospParams), row);
        this.checkByteLength(dto.getPositionAbbr(), 6, PfNameUtility.positionAbbreviation((MospParams)this.mospParams), row);
        this.checkTypeCode(dto.getPositionCode(), PfNameUtility.positionCode((MospParams)this.mospParams), row);
        this.checkTypeNumber(String.valueOf(dto.getPositionGrade()), PfNameUtility.positionGrade((MospParams)this.mospParams), row);
        this.checkInactivateFlag(dto.getInactivateFlag(), row);
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
    }
}

