/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.NamingReferenceBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterCheckBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.NamingDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.WorkPlaceDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class PlatformMasterCheckBean
extends PlatformBean
implements PlatformMasterCheckBeanInterface {
    protected SectionReferenceBeanInterface sectionReference;
    protected PositionReferenceBeanInterface positionReference;
    protected EmploymentContractReferenceBeanInterface employmentContractReference;
    protected WorkPlaceReferenceBeanInterface workPlaceReference;
    protected NamingReferenceBeanInterface namingReference;

    public void initBean() throws MospException {
        this.sectionReference = (SectionReferenceBeanInterface)this.createBeanInstance(SectionReferenceBeanInterface.class);
        this.positionReference = (PositionReferenceBeanInterface)this.createBeanInstance(PositionReferenceBeanInterface.class);
        this.employmentContractReference = (EmploymentContractReferenceBeanInterface)this.createBeanInstance(EmploymentContractReferenceBeanInterface.class);
        this.workPlaceReference = (WorkPlaceReferenceBeanInterface)this.createBeanInstance(WorkPlaceReferenceBeanInterface.class);
        this.namingReference = (NamingReferenceBeanInterface)this.createBeanInstance(NamingReferenceBeanInterface.class);
    }

    public boolean isCheckEmploymentContract(String employmentContractCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermEmploymentContract(employmentContractCode, startDate, endDate);
    }

    public boolean isCheckPosition(String positionCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermPosition(positionCode, startDate, endDate);
    }

    public boolean isCheckSection(String sectionCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermSection(sectionCode, startDate, endDate);
    }

    public boolean isCheckWorkPlace(String workPlaceCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermWorkPlace(workPlaceCode, startDate, endDate);
    }

    public boolean isCheckNaming(String namingType, String namingItemCode, Date startDate, Date endDate, Integer row) throws MospException {
        return this.isTermNaming(namingType, namingItemCode, startDate, endDate);
    }

    public boolean isCheckEmploymentContract(String employmentContractCode, Date startDate, Date endDate) throws MospException {
        return this.isTermEmploymentContract(employmentContractCode, startDate, endDate);
    }

    public boolean isCheckPosition(String positionCode, Date startDate, Date endDate) throws MospException {
        return this.isTermPosition(positionCode, startDate, endDate);
    }

    public boolean isCheckSection(String sectionCode, Date startDate, Date endDate) throws MospException {
        return this.isTermSection(sectionCode, startDate, endDate);
    }

    public boolean isCheckWorkPlace(String workPlaceCode, Date startDate, Date endDate) throws MospException {
        return this.isTermWorkPlace(workPlaceCode, startDate, endDate);
    }

    public boolean isTermEmploymentContract(String employmentContractCode, Date startDate, Date endDate) throws MospException {
        List employList = this.employmentContractReference.getContractHistory(employmentContractCode);
        for (EmploymentContractDtoInterface employDto : employList) {
            if (!DateUtility.isTermContain((Date)employDto.getActivateDate(), (Date)startDate, (Date)endDate) || employDto.getInactivateFlag() != 1) continue;
            String fieldName = PfNameUtility.employmentContract((MospParams)this.mospParams);
            Date targetDate = employDto.getActivateDate();
            PfMessageUtility.addErrorInactive((MospParams)this.mospParams, (String)fieldName, (String)employmentContractCode, (Date)targetDate);
            return false;
        }
        return true;
    }

    public boolean isTermPosition(String positionCode, Date startDate, Date endDate) throws MospException {
        List positionList = this.positionReference.getPositionHistory(positionCode);
        for (PositionDtoInterface positionDto : positionList) {
            if (!DateUtility.isTermContain((Date)positionDto.getActivateDate(), (Date)startDate, (Date)endDate) || positionDto.getInactivateFlag() != 1) continue;
            String fieldName = PfNameUtility.position((MospParams)this.mospParams);
            Date targetDate = positionDto.getActivateDate();
            PfMessageUtility.addErrorInactive((MospParams)this.mospParams, (String)fieldName, (String)positionCode, (Date)targetDate);
            return false;
        }
        return true;
    }

    public boolean isTermSection(String sectionCode, Date startDate, Date endDate) throws MospException {
        List sectionList = this.sectionReference.getSectionHistory(sectionCode);
        for (SectionDtoInterface sectionDto : sectionList) {
            if (!DateUtility.isTermContain((Date)sectionDto.getActivateDate(), (Date)startDate, (Date)endDate) || sectionDto.getInactivateFlag() != 1) continue;
            String fieldName = PfNameUtility.section((MospParams)this.mospParams);
            Date targetDate = sectionDto.getActivateDate();
            PfMessageUtility.addErrorInactive((MospParams)this.mospParams, (String)fieldName, (String)sectionCode, (Date)targetDate);
            return false;
        }
        return true;
    }

    public boolean isTermWorkPlace(String workPlaceCode, Date startDate, Date endDate) throws MospException {
        List workPlaceList = this.workPlaceReference.getHistory(workPlaceCode);
        for (WorkPlaceDtoInterface workPlaceDto : workPlaceList) {
            if (!DateUtility.isTermContain((Date)workPlaceDto.getActivateDate(), (Date)startDate, (Date)endDate) || workPlaceDto.getInactivateFlag() != 1) continue;
            String fieldName = PfNameUtility.workPlace((MospParams)this.mospParams);
            Date targetDate = workPlaceDto.getActivateDate();
            PfMessageUtility.addErrorInactive((MospParams)this.mospParams, (String)fieldName, (String)workPlaceCode, (Date)targetDate);
            return false;
        }
        return true;
    }

    protected boolean isTermNaming(String namingType, String namingItemCode, Date startDate, Date endDate) throws MospException {
        List namingList = this.namingReference.getNamingItemHistory(namingType, namingItemCode);
        for (NamingDtoInterface namingDto : namingList) {
            if (!DateUtility.isTermContain((Date)namingDto.getActivateDate(), (Date)startDate, (Date)endDate) || namingDto.getInactivateFlag() != 1) continue;
            String fieldName = MospUtility.getCodeName((MospParams)this.mospParams, (String)"NamingType", (String)namingType);
            Date targetDate = namingDto.getActivateDate();
            PfMessageUtility.addErrorInactive((MospParams)this.mospParams, (String)fieldName, (String)namingItemCode, (Date)targetDate);
            return false;
        }
        return true;
    }
}

