/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dao.human.HumanNormalDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dao.human.SuspensionDaoInterface;
import jp.mosp.platform.dao.system.AppPropertyDaoInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dao.workflow.RouteApplicationDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanNormalDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.system.AppPropertyDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformUtility;

public class PlatformMasterBean
extends PlatformBean
implements PlatformMasterBeanInterface {
    protected RouteApplicationDaoInterface routeApplicationDao;
    protected HumanDaoInterface humanDao;
    protected RetirementDaoInterface retireDao;
    protected SuspensionDaoInterface suspensionDao;
    protected HumanNormalDaoInterface humanNormalDao;
    protected SectionDaoInterface sectionDao;
    protected AppPropertyDaoInterface appPropertyDao;
    protected Map<Date, Set<RouteApplicationDtoInterface>> applicationPersonMap;
    protected Map<Date, Set<RouteApplicationDtoInterface>> applicationMasterMap;
    protected Map<String, List<HumanDtoInterface>> humanMap;
    protected Map<String, RetirementDtoInterface> retireMap;
    protected Map<String, List<SuspensionDtoInterface>> suspensionMap;
    protected Map<String, String> mailAddressMap;
    protected Map<String, Map<Date, SectionDtoInterface>> sectionMap;
    protected Map<String, AppPropertyDtoInterface> appPropertyMap;

    public void initBean() throws MospException {
        this.routeApplicationDao = (RouteApplicationDaoInterface)this.createDaoInstance(RouteApplicationDaoInterface.class);
        this.humanDao = (HumanDaoInterface)this.createDaoInstance(HumanDaoInterface.class);
        this.retireDao = (RetirementDaoInterface)this.createDaoInstance(RetirementDaoInterface.class);
        this.suspensionDao = (SuspensionDaoInterface)this.createDaoInstance(SuspensionDaoInterface.class);
        this.humanNormalDao = (HumanNormalDaoInterface)this.createDaoInstance(HumanNormalDaoInterface.class);
        this.sectionDao = (SectionDaoInterface)this.createDaoInstance(SectionDaoInterface.class);
        this.appPropertyDao = (AppPropertyDaoInterface)this.createDaoInstance(AppPropertyDaoInterface.class);
        this.applicationPersonMap = new HashMap();
        this.applicationMasterMap = new HashMap();
        this.humanMap = new HashMap();
        this.retireMap = new HashMap();
        this.suspensionMap = new HashMap();
        this.mailAddressMap = new HashMap();
        this.sectionMap = new HashMap();
        this.appPropertyMap = new HashMap();
    }

    public RouteApplicationDtoInterface getRouteApplication(HumanDtoInterface humanDto, Date targetDate, int workflowType) throws MospException {
        Set personSet = this.getApplicationPersonSet(targetDate, workflowType);
        Set masterSet = this.getApplicationMasterSet(targetDate, workflowType);
        return (RouteApplicationDtoInterface)PlatformUtility.getApplicationMaster((HumanDtoInterface)humanDto, (Set)personSet, (Set)masterSet);
    }

    public RouteApplicationDtoInterface getRouteApplication(String personalId, Date targetDate, int workflowType) throws MospException {
        HumanDtoInterface humanDto = this.getHuman(personalId, targetDate);
        return this.getRouteApplication(humanDto, targetDate, workflowType);
    }

    protected Set<RouteApplicationDtoInterface> getApplicationPersonSet(Date targetDate, int workflowType) throws MospException {
        if (this.applicationPersonMap.get(targetDate) == null) {
            this.addApplicationSet(targetDate);
        }
        Set set = (Set)this.applicationPersonMap.get(targetDate);
        return this.getApplicationSet(set, workflowType);
    }

    protected Set<RouteApplicationDtoInterface> getApplicationMasterSet(Date targetDate, int workflowType) throws MospException {
        if (this.applicationMasterMap.get(targetDate) == null) {
            this.addApplicationSet(targetDate);
        }
        Set set = (Set)this.applicationMasterMap.get(targetDate);
        return this.getApplicationSet(set, workflowType);
    }

    protected void addApplicationSet(Date targetDate) throws MospException {
        HashSet<RouteApplicationDtoInterface> personSet = new HashSet<RouteApplicationDtoInterface>();
        HashSet<RouteApplicationDtoInterface> masterSet = new HashSet<RouteApplicationDtoInterface>();
        this.applicationPersonMap.put(targetDate, personSet);
        this.applicationMasterMap.put(targetDate, masterSet);
        int person = Integer.parseInt("1");
        int master = Integer.parseInt("0");
        List list = this.routeApplicationDao.findForActivateDate(targetDate);
        for (RouteApplicationDtoInterface dto : list) {
            if (dto.getRouteApplicationType() == person) {
                personSet.add(dto);
            }
            if (dto.getRouteApplicationType() != master) continue;
            masterSet.add(dto);
        }
    }

    protected Set<RouteApplicationDtoInterface> getApplicationSet(Set<RouteApplicationDtoInterface> set, int workflowType) {
        HashSet<RouteApplicationDtoInterface> applicationSet = new HashSet<RouteApplicationDtoInterface>();
        for (RouteApplicationDtoInterface dto : set) {
            if (dto.getWorkflowType() != workflowType) continue;
            applicationSet.add(dto);
        }
        return applicationSet;
    }

    public HumanDtoInterface getHuman(String personalId, Date targetDate) throws MospException {
        List list = this.getHumanHistory(personalId);
        return (HumanDtoInterface)PlatformUtility.getLatestDto((List)list, (Date)targetDate);
    }

    public HumanDtoInterface getHuman(String personalId, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getHuman(personalId, targetDate);
    }

    public List<HumanDtoInterface> getHumanHistory(String personalId) throws MospException {
        List list = (List)this.humanMap.get(personalId);
        if (list == null) {
            list = this.humanDao.findForHistory(personalId);
            this.humanMap.put(personalId, list);
        }
        return list;
    }

    public RetirementDtoInterface getRetirement(String personalId) throws MospException {
        if (this.retireMap.containsKey(personalId)) {
            return (RetirementDtoInterface)this.retireMap.get(personalId);
        }
        RetirementDtoInterface dto = this.retireDao.findForInfo(personalId);
        this.retireMap.put(personalId, dto);
        return dto;
    }

    public boolean isRetired(String personalId, Date targetDate) throws MospException {
        RetirementDtoInterface dto = this.getRetirement(personalId);
        return HumanUtility.isRetired((RetirementDtoInterface)dto, (Date)targetDate);
    }

    public List<SuspensionDtoInterface> getSuspensions(String personalId) throws MospException {
        List list = (List)this.suspensionMap.get(personalId);
        if (MospUtility.isEmpty((Collection)list)) {
            list = this.suspensionDao.findForHistory(personalId);
            this.suspensionMap.put(personalId, list);
        }
        return list;
    }

    public boolean isSuspended(String personalId, Date targetDate) throws MospException {
        List list = this.getSuspensions(personalId);
        return HumanUtility.isSuspension((Collection)list, (Date)targetDate);
    }

    public String getMailAddress(String personalId) throws MospException {
        if (this.mailAddressMap.containsKey(personalId)) {
            return (String)this.mailAddressMap.get(personalId);
        }
        HumanNormalDtoInterface dto = this.humanNormalDao.findForInfo("mailAddress", personalId);
        String mailAddress = HumanUtility.getHumanItemValue((HumanNormalDtoInterface)dto);
        this.mailAddressMap.put(personalId, mailAddress);
        return mailAddress;
    }

    public String getSectionName(String sectionCode, Date targetDate) throws MospException {
        SectionDtoInterface dto = this.getSection(sectionCode, targetDate);
        if (dto == null) {
            return sectionCode;
        }
        return dto.getSectionName();
    }

    public String getSectionAbbr(String sectionCode, Date targetDate) throws MospException {
        SectionDtoInterface dto = this.getSection(sectionCode, targetDate);
        if (dto == null) {
            return sectionCode;
        }
        return dto.getSectionAbbr();
    }

    public String getSectionNameOrDisplay(String sectionCode, Date targetDate, MospParams mospParams) throws MospException {
        SectionDtoInterface dto = this.getSection(sectionCode, targetDate);
        if (dto == null) {
            return sectionCode;
        }
        if (PlatformUtility.isSectionDisplayName((MospParams)mospParams)) {
            return dto.getSectionDisplay();
        }
        return dto.getSectionName();
    }

    protected SectionDtoInterface getSection(String sectionCode, Date targetDate) throws MospException {
        SectionDtoInterface dto;
        HashMap<Date, SectionDtoInterface> map = (HashMap<Date, SectionDtoInterface>)this.sectionMap.get(sectionCode);
        if (map == null) {
            map = new HashMap<Date, SectionDtoInterface>();
            this.sectionMap.put(sectionCode, map);
        }
        if ((dto = (SectionDtoInterface)map.get(targetDate)) == null) {
            dto = this.sectionDao.findForInfo(sectionCode, targetDate);
            map.put(targetDate, dto);
        }
        return dto;
    }

    public String getAppProperty(String appKey) throws MospException {
        String value = this.mospParams.getApplicationProperty(appKey);
        AppPropertyDtoInterface dto = this.getAppPropertyDto(appKey).orElse(null);
        if (dto != null) {
            value = dto.getAppValue();
        }
        if (MospUtility.isEmpty((String[])new String[]{value})) {
            value = "";
        }
        return value;
    }

    public int getAppPropertyInt(String appKey) throws MospException {
        return MospUtility.getInt((Object)this.getAppProperty(appKey));
    }

    protected Optional<AppPropertyDtoInterface> getAppPropertyDto(String appKey) throws MospException {
        AppPropertyDtoInterface dto = (AppPropertyDtoInterface)this.appPropertyMap.get(appKey);
        if (dto == null) {
            dto = this.appPropertyDao.findForKey(appKey).orElse(null);
            this.appPropertyMap.put(appKey, dto);
        }
        return Optional.ofNullable(dto);
    }
}

