/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.system.NamingRegistBeanInterface;
import jp.mosp.platform.dao.human.HumanHistoryDaoInterface;
import jp.mosp.platform.dao.system.NamingDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.system.NamingDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmNamingDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class NamingRegistBean
extends PlatformBean
implements NamingRegistBeanInterface {
    protected static final int LEN_NAMING_ITEM_CODE = 10;
    protected static final int LEN_NAMING_ITEM_NAME = 15;
    protected static final int LEN_NAMING_ITEM_ABBR = 6;
    protected NamingDaoInterface dao;
    protected HumanHistoryDaoInterface humanHistoryDao;

    public void initBean() throws MospException {
        this.dao = (NamingDaoInterface)this.createDaoInstance(NamingDaoInterface.class);
        this.humanHistoryDao = (HumanHistoryDaoInterface)this.createDaoInstance(HumanHistoryDaoInterface.class);
    }

    public NamingDtoInterface getInitDto() {
        return new PfmNamingDto();
    }

    public void insert(NamingDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmNamingId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(NamingDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmNamingId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(NamingDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmNamingId());
        dto.setPfmNamingId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, String namingType, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            NamingDtoInterface dto = this.dao.findForKey(namingType, code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(namingType, code, activateDate);
                if (dto == null) {
                    PfMessageUtility.addErrorCodeNotExistBeforeDate((MospParams)this.mospParams, (String)code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto, null);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmNamingId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto, null);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmNamingId());
            dto.setPfmNamingId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkDelete((NamingDtoInterface)this.dao.findForKey(id, true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void checkInsert(NamingDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getNamingType(), dto.getNamingItemCode()));
    }

    protected void checkAdd(NamingDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getNamingType(), dto.getNamingItemCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getNamingType(), dto.getNamingItemCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getNamingItemCode(), humanList);
    }

    protected void checkUpdate(NamingDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmNamingId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmNamingId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getNamingType(), dto.getNamingItemCode());
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getNamingItemCode(), humanList);
    }

    protected void checkDelete(NamingDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmNamingId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getNamingType(), dto.getNamingItemCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getNamingItemCode(), humanList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            NamingDtoInterface dto = (NamingDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getNamingItemCode());
        }
        return list;
    }

    protected void checkCodeIsUsed(String code, List<HumanDtoInterface> list) throws MospException {
        for (HumanDtoInterface dto : list) {
            List humanHistoryList = this.humanHistoryDao.findForHistory(dto.getPersonalId(), "post");
            for (HumanHistoryDtoInterface historyDto : humanHistoryList) {
                if (!code.equals(historyDto.getHumanItemValue())) continue;
                PfMessageUtility.addErrorCodeIsUsed((MospParams)this.mospParams, (String)code, (String)dto.getEmployeeCode());
            }
        }
    }

    public void validate(NamingDtoInterface dto, Integer row) {
        this.checkRequired((Object)dto.getNamingType(), PfNameUtility.namingType((MospParams)this.mospParams), row);
        if (!this.isExistNamingType(dto.getNamingType())) {
            PfMessageUtility.addErrorNoItem((MospParams)this.mospParams, (String)PfNameUtility.namingType((MospParams)this.mospParams));
            return;
        }
        this.checkRequired((Object)dto.getNamingItemCode(), PfNameUtility.namingItemCode((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getActivateDate(), PfNameUtility.activateDate((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getNamingItemName(), PfNameUtility.namingItemName((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getNamingItemAbbr(), PfNameUtility.namingItemAbbreviation((MospParams)this.mospParams), row);
        this.checkLength(dto.getNamingItemCode(), 10, PfNameUtility.namingItemCode((MospParams)this.mospParams), row);
        this.checkLength(dto.getNamingItemName(), 15, PfNameUtility.namingItemName((MospParams)this.mospParams), row);
        this.checkByteLength(dto.getNamingItemAbbr(), 6, PfNameUtility.namingItemAbbreviation((MospParams)this.mospParams), row);
        this.checkTypeCode(dto.getNamingItemCode(), PfNameUtility.namingItemCode((MospParams)this.mospParams), row);
        this.checkInactivateFlag(dto.getInactivateFlag(), row);
    }

    public boolean isExistNamingType(String namingType) {
        String[][] codeNamingType;
        for (String[] element : codeNamingType = this.mospParams.getProperties().getCodeArray("NamingType", false)) {
            String item = element[0];
            if (!item.equals(namingType)) continue;
            return true;
        }
        return false;
    }
}

