/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.NamingReferenceBeanInterface;
import jp.mosp.platform.dao.system.NamingDaoInterface;
import jp.mosp.platform.dto.system.NamingDtoInterface;

public class NamingReferenceBean
extends PlatformBean
implements NamingReferenceBeanInterface {
    protected NamingDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (NamingDaoInterface)this.createDaoInstance(NamingDaoInterface.class);
    }

    public List<NamingDtoInterface> getNamingItemHistory(String namingType, String namingItemCode) throws MospException {
        return this.dao.findForHistory(namingType, namingItemCode);
    }

    public NamingDtoInterface getNamingItemInfo(String namingType, String namingItemCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(namingType, namingItemCode, targetDate);
    }

    public String getNamingItemName(String namingType, String namingItemCode, Date targetDate) throws MospException {
        NamingDtoInterface dto = this.getNamingItemInfo(namingType, namingItemCode, targetDate);
        if (dto == null) {
            if (namingItemCode != null) {
                return namingItemCode;
            }
            return "";
        }
        return dto.getNamingItemName();
    }

    public String getNamingItemAbbr(String namingType, String namingItemCode, Date targetDate) throws MospException {
        NamingDtoInterface dto = this.getNamingItemInfo(namingType, namingItemCode, targetDate);
        if (dto == null) {
            return namingItemCode;
        }
        return dto.getNamingItemAbbr();
    }

    public NamingDtoInterface findForKey(String namingType, String namingItemCode, Date activateDate) throws MospException {
        return this.dao.findForKey(namingType, namingItemCode, activateDate);
    }

    public String[][] getCodedSelectArray(String namingType, Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(namingType, targetDate, needBlank, true);
    }

    public String[][] getSelectArray(String namingType, Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(namingType, targetDate, needBlank, false);
    }

    protected String[][] getSelectArray(String namingType, Date targetDate, boolean needBlank, boolean viewCode) throws MospException {
        List list = this.dao.findForList(namingType, targetDate);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        int codeLength = 0;
        for (NamingDtoInterface dto : list) {
            if (dto.getNamingItemCode().length() <= codeLength) continue;
            codeLength = dto.getNamingItemCode().length();
        }
        for (NamingDtoInterface dto : list) {
            array[idx][0] = dto.getNamingItemCode();
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getNamingItemCode(), dto.getNamingItemName(), codeLength);
                continue;
            }
            array[idx++][1] = dto.getNamingItemName();
        }
        return array;
    }
}

