/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.dao.system.EmploymentContractDaoInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;

public class EmploymentContractReferenceBean
extends PlatformBean
implements EmploymentContractReferenceBeanInterface {
    protected EmploymentContractDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (EmploymentContractDaoInterface)this.createDaoInstance(EmploymentContractDaoInterface.class);
    }

    public List<EmploymentContractDtoInterface> getContractHistory(String employmentContractCode) throws MospException {
        return this.dao.findForHistory(employmentContractCode);
    }

    public EmploymentContractDtoInterface getContractInfo(String employmentContractCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(employmentContractCode, targetDate);
    }

    public String getContractName(String employmentContractCode, Date targetDate) throws MospException {
        EmploymentContractDtoInterface dto = this.getContractInfo(employmentContractCode, targetDate);
        if (dto == null) {
            return employmentContractCode;
        }
        return dto.getEmploymentContractName();
    }

    public String getContractAbbr(String employmentContractCode, Date targetDate) throws MospException {
        EmploymentContractDtoInterface dto = this.getContractInfo(employmentContractCode, targetDate);
        if (dto == null) {
            return employmentContractCode;
        }
        return dto.getEmploymentContractAbbr();
    }

    public List<EmploymentContractDtoInterface> getContractList(Date targetDate, String operationType) throws MospException {
        String[] rangeArray = this.getRangeEmploymentContract(operationType, targetDate);
        return this.dao.findForActivateDate(targetDate, rangeArray);
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, false, false);
    }

    public String[][] getNameSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, true, false);
    }

    public String[][] getCodedAbbrSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, false, true);
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, true, true);
    }

    public EmploymentContractDtoInterface findForKey(String employmentContractCode, Date activateDate) throws MospException {
        return this.dao.findForKey(employmentContractCode, activateDate);
    }

    protected String[][] getSelectArray(Date targetDate, boolean needBlank, String operationType, boolean isName, boolean viewCode) throws MospException {
        List list = this.getContractList(targetDate, operationType);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (EmploymentContractDtoInterface dto : list) {
            array[idx][0] = dto.getEmploymentContractCode();
            if (isName && viewCode) {
                array[idx++][1] = this.getCodedName(dto.getEmploymentContractCode(), dto.getEmploymentContractName(), length);
                continue;
            }
            if (isName) {
                array[idx++][1] = dto.getEmploymentContractName();
                continue;
            }
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getEmploymentContractCode(), dto.getEmploymentContractAbbr(), length);
                continue;
            }
            array[idx++][1] = dto.getEmploymentContractAbbr();
        }
        return array;
    }

    protected int getMaxCodeLength(List<EmploymentContractDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (EmploymentContractDtoInterface dto : list) {
            if (dto.getEmploymentContractCode().length() <= length) continue;
            length = dto.getEmploymentContractCode().length();
        }
        return length;
    }
}

