/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.mosp.framework.base.BaseBean;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.system.CipherBeanInterface;
import org.apache.commons.codec.binary.Base64;

public class CipherBean
extends BaseBean
implements CipherBeanInterface {
    protected static final String STR_SEPARATOR_CREDENTIAL = ":";

    public void initBean() {
    }

    public String encrypt(String source) throws MospException {
        byte[] sourceBytes = MospUtility.getBytes((String)source);
        return this.encode(sourceBytes);
    }

    public String decrypt(String source) throws MospException {
        byte[] sourceBytes = this.decode(source);
        return MospUtility.newString((byte[])sourceBytes);
    }

    protected String encode(byte[] source) throws MospException {
        try {
            return Base64.encodeBase64String((byte[])source);
        }
        catch (Throwable t) {
            throw new MospException(t);
        }
    }

    protected byte[] decode(String source) throws MospException {
        try {
            return Base64.decodeBase64((String)source);
        }
        catch (Throwable t) {
            throw new MospException(t);
        }
    }

    public List<String> decodeBasicAuthHeader(String source) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        String[] array = MospUtility.split((String)source, (String)" ");
        if (array.length != 2) {
            return Collections.emptyList();
        }
        String decoded = MospUtility.newString((byte[])this.decode(array[1]));
        String[] credentials = MospUtility.split((String)decoded, (String)STR_SEPARATOR_CREDENTIAL);
        if (credentials.length != 2) {
            return Collections.emptyList();
        }
        list.add(array[0]);
        list.addAll(MospUtility.asList((String[])credentials));
        for (String value : list) {
            if (!MospUtility.isEmpty((String[])new String[]{value})) continue;
            return Collections.emptyList();
        }
        return list;
    }
}

