/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.BankBranchReferenceBeanInterface;
import jp.mosp.platform.dao.system.BankBranchDaoInterface;
import jp.mosp.platform.dto.system.BankBranchDtoInterface;

public class BankBranchReferenceBean
extends PlatformBean
implements BankBranchReferenceBeanInterface {
    protected BankBranchDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (BankBranchDaoInterface)this.createDaoInstance(BankBranchDaoInterface.class);
    }

    public String[][] getSelectArray(String bankCode, String value, boolean needBlank) throws MospException {
        return this.getSelectArray(bankCode, value, needBlank, true);
    }

    protected String[][] getSelectArray(String bankCode, String value, boolean needBlank, boolean viewCode) throws MospException {
        List list = this.dao.searchBankBranchInfo(bankCode, value);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (BankBranchDtoInterface dto : list) {
            array[idx][0] = dto.getBranchCode();
            array[idx++][1] = this.getCodedName(dto.getBranchCode(), dto.getBranchName(), length);
        }
        return array;
    }

    protected int getMaxCodeLength(List<BankBranchDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (BankBranchDtoInterface dto : list) {
            if (dto.getBranchCode().length() <= length) continue;
            length = dto.getBranchCode().length();
        }
        return length;
    }

    public BankBranchDtoInterface findForKey(String bankCode, String branchCode) throws MospException {
        return this.dao.findForKey(bankCode, branchCode);
    }
}

