/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.BankBaseReferenceBeanInterface;
import jp.mosp.platform.dao.system.BankBaseDaoInterface;
import jp.mosp.platform.dto.system.BankBaseDtoInterface;

public class BankBaseReferenceBean
extends PlatformBean
implements BankBaseReferenceBeanInterface {
    private BankBaseDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (BankBaseDaoInterface)this.createDaoInstance(BankBaseDaoInterface.class);
    }

    public String[][] getSelectArray(String value, boolean needBlank) throws MospException {
        return this.getSelectArray(value, needBlank, true);
    }

    protected String[][] getSelectArray(String value, boolean needBlank, boolean viewCode) throws MospException {
        List list = this.dao.searchBankBaseInfo(value);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (BankBaseDtoInterface dto : list) {
            array[idx][0] = dto.getBankCode();
            array[idx++][1] = this.getCodedName(dto.getBankCode(), dto.getBankName(), length);
        }
        return array;
    }

    protected int getMaxCodeLength(List<BankBaseDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (BankBaseDtoInterface dto : list) {
            if (dto.getBankCode().length() <= length) continue;
            length = dto.getBankCode().length();
        }
        return length;
    }

    public BankBaseDtoInterface findForKey(String code) throws MospException {
        return this.dao.findForKey(code);
    }
}

