/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.AppPropertyRegistBeanInterface;
import jp.mosp.platform.dao.system.AppPropertyDaoInterface;
import jp.mosp.platform.dto.system.AppPropertyDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmAppPropertyDto;
import jp.mosp.platform.utils.PfNameUtility;

public class AppPropertyRegistBean
extends PlatformBean
implements AppPropertyRegistBeanInterface {
    protected AppPropertyDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (AppPropertyDaoInterface)this.createDaoInstance(AppPropertyDaoInterface.class);
    }

    public void regist(String appKey, String appValue) throws MospException {
        PfmAppPropertyDto dto = new PfmAppPropertyDto();
        dto.setAppKey(appKey);
        dto.setAppValue(appValue);
        this.validate((AppPropertyDtoInterface)dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        AppPropertyDtoInterface current = this.dao.findForKey(appKey).orElse(null);
        if (current != null) {
            if (MospUtility.isEqual((Object)appValue, (Object)current.getAppValue())) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, current.getRecordId());
        }
        dto.setPfmAppPropertyId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(String appKey) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, this.dao.findForKey(appKey).map(dto -> dto.getRecordId()).orElse(Long.MIN_VALUE).longValue());
    }

    protected void validate(AppPropertyDtoInterface dto, Integer row) {
        String appKey = dto.getAppKey();
        int deleteFlag = dto.getDeleteFlag();
        String nameAppKey = PfNameUtility.appKey((MospParams)this.mospParams);
        this.checkRequired((Object)appKey, nameAppKey, row);
        this.checkDeleteFlag(deleteFlag, row);
    }
}

