/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.portal.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.constant.MospConst;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.HtmlUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.message.MessageReferenceBeanInterface;
import jp.mosp.platform.bean.portal.PortalBeanInterface;
import jp.mosp.platform.bean.portal.impl.PortalBean;
import jp.mosp.platform.dto.message.MessageDtoInterface;

public class PortalMessageBean
extends PortalBean
implements PortalBeanInterface {
    protected static final String PATH_PORTAL_VIEW = "/jsp/platform/portal/portalMessage.jsp";
    protected static final String APP_PORTAL_MESSAGE_COUNT = "PortalMessageCount";
    protected static final String APP_PORTAL_MESSAGE_COMPARATORS = "PortalMessageComparators";
    public static final String PRM_ARY_LBL_MESSAGE_DATE = "aryLblMessageDate";
    public static final String PRM_ARY_LBL_MESSAGE_NO = "aryLblMessageNo";
    public static final String PRM_ARY_LBL_MESSAGE_TYPE = "aryLblMessageType";
    public static final String PRM_ARY_LBL_MESSAGE_IMPORTANCE = "aryLblMessageImportance";
    public static final String PRM_ARY_LBL_MESSAGE_IMPORTANCE_STYLE = "aryLblMessageImportanceStyle";
    public static final String PRM_ARY_LBL_MESSAGE_TITLE = "aryLblMessageTitle";
    public static final String PRM_ARY_LBL_MESSAGE = "aryLblMessage";
    public static final String PRM_LBL_MESSAGE_COUNT = "lblMessageCount";
    public static final String STYLE_RED = "style=\"color: red\"";
    public static final String STYLE_YAMABUKI = "style=\"color: #f8b500\"";

    public void initBean() {
    }

    public void show() throws MospException {
        this.addPortalViewList(PATH_PORTAL_VIEW);
        if (this.getPortalParameter(PRM_LBL_MESSAGE_COUNT) == null || this.mospParams.getCommand().equals("PF0043")) {
            this.setVoList(this.getMessageList(), true);
        }
    }

    public void regist() throws MospException {
        this.setVoList(this.getMessageList(), false);
    }

    protected List<MessageDtoInterface> getMessageList() throws MospException {
        MessageReferenceBeanInterface message = (MessageReferenceBeanInterface)this.createBean(MessageReferenceBeanInterface.class);
        List list = message.getMessageList(this.mospParams.getUser().getPersonalId(), this.getSystemDate());
        for (String comparator : this.getPortalMessageComparators()) {
            this.sortList(list, comparator, true);
        }
        return list;
    }

    protected void setVoList(List<MessageDtoInterface> list, boolean isCapped) {
        int portalMessageCount;
        int count = list.size();
        int ohterMessageCount = 0;
        if (isCapped && (portalMessageCount = this.mospParams.getApplicationProperty(APP_PORTAL_MESSAGE_COUNT, 0)) > 0 && count > portalMessageCount) {
            ohterMessageCount = count - portalMessageCount;
            count = portalMessageCount;
        }
        String[] aryLblMessageDate = new String[count];
        String[] aryLblMessageNo = new String[count];
        String[] aryLblMessageType = new String[count];
        String[] aryLblMessageImportance = new String[count];
        String[] aryLblMessageImportanceStyle = new String[count];
        String[] aryLblMessageTitle = new String[count];
        String[] aryLblMessage = new String[count];
        for (int i = 0; i < count; ++i) {
            MessageDtoInterface dto = list.get(i);
            aryLblMessageDate[i] = DateUtility.getStringDateAndDay((Date)dto.getStartDate());
            aryLblMessageNo[i] = dto.getMessageNo();
            aryLblMessageType[i] = this.getCodeName(dto.getMessageType(), "MessageType");
            aryLblMessageImportance[i] = this.getCodeName(dto.getMessageImportance(), "MessageImportanceMark");
            aryLblMessageImportanceStyle[i] = "";
            if (dto.getMessageImportance() == 1) {
                aryLblMessageImportanceStyle[i] = STYLE_RED;
            } else if (dto.getMessageImportance() == 3) {
                aryLblMessageImportanceStyle[i] = STYLE_YAMABUKI;
            }
            aryLblMessageTitle[i] = dto.getMessageTitle();
            aryLblMessage[i] = this.getMessageBody(dto);
        }
        this.putPortalParameters(PRM_ARY_LBL_MESSAGE_DATE, aryLblMessageDate);
        this.putPortalParameters(PRM_ARY_LBL_MESSAGE_NO, aryLblMessageNo);
        this.putPortalParameters(PRM_ARY_LBL_MESSAGE_TYPE, aryLblMessageType);
        this.putPortalParameters(PRM_ARY_LBL_MESSAGE_IMPORTANCE, aryLblMessageImportance);
        this.putPortalParameters(PRM_ARY_LBL_MESSAGE_IMPORTANCE_STYLE, aryLblMessageImportanceStyle);
        this.putPortalParameters(PRM_ARY_LBL_MESSAGE_TITLE, aryLblMessageTitle);
        this.putPortalParameters(PRM_ARY_LBL_MESSAGE, aryLblMessage);
        this.putPortalParameter(PRM_LBL_MESSAGE_COUNT, String.valueOf(ohterMessageCount));
    }

    protected String[] getPortalMessageComparators() {
        String portalBeans = this.mospParams.getApplicationProperty(APP_PORTAL_MESSAGE_COMPARATORS);
        return MospUtility.split((String)portalBeans, (String)",");
    }

    protected String getMessageBody(MessageDtoInterface dto) {
        String[] lines;
        if (dto == null || dto.getMessageBody() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String line : lines = dto.getMessageBody().split(MospConst.LINE_SEPARATOR)) {
            sb.append(this.getMessageLine(line));
            sb.append(MospConst.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    protected String getMessageLine(String messageLine) {
        String[] uris;
        StringBuffer sb = new StringBuffer();
        for (String target : uris = messageLine.split("(?<=.)(?=https?://)")) {
            if (target.startsWith("http://") || target.startsWith("https://")) {
                String uri = target.trim();
                sb.append(this.getAnchor(uri));
                sb.append(HtmlUtility.escapeHTML((String)target.substring(uri.length())));
                continue;
            }
            sb.append(HtmlUtility.escapeHTML((String)target));
        }
        return sb.toString();
    }

    protected String getAnchor(String uri) {
        if (this.validateURI(uri)) {
            StringBuffer sb = new StringBuffer();
            sb.append("<a onclick=\"openWindow('");
            sb.append(uri);
            sb.append("')\">");
            sb.append(HtmlUtility.escapeHTML((String)uri));
            sb.append("</a>");
            return sb.toString();
        }
        return HtmlUtility.escapeHTML((String)uri);
    }

    protected boolean validateURI(String uri) {
        return uri.matches("^https?://.+");
    }
}

