/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.portal.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.SeUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dao.system.UserPasswordDaoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;

public class PasswordCheckBean
extends PlatformBean
implements PasswordCheckBeanInterface {
    protected static final String APP_PASSWORD_PERIOD = "PasswordPeriod";
    protected static final String APP_MIN_PASSWORD = "MinPassword";
    protected static final String APP_CHAR_PASSWORD = "CharPassword";
    protected static final String APP_CHECK_PASSWORD = "CheckPassword";
    protected static final String APP_INITIAL_PASSWORD = "InitialPassword";
    protected static final String INITIAL_PASS_USER_ID = "UserId";
    protected static final String PASS_CHECK_INIT_INVALID = "initPasswordInvalid";
    protected UserPasswordDaoInterface dao;
    protected PlatformMasterBeanInterface master;

    public void initBean() throws MospException {
        this.dao = (UserPasswordDaoInterface)this.createDaoInstance(UserPasswordDaoInterface.class);
        this.master = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
    }

    public String encrypt(String pass) throws MospException {
        return SeUtility.encrypt((String)pass);
    }

    public String encryptPlain(String pass) throws MospException {
        return this.encrypt(SeUtility.encrypt((String)pass));
    }

    public void checkPasswordPeriod(String userId, Date targetDate) throws MospException {
        int expiration = this.getPasswordExpiration();
        Date referenceDate = this.getReferenceDate(userId);
        if (DateUtility.isExpireDay((Date)targetDate, (Date)referenceDate, (int)expiration)) {
            PfMessageUtility.addErrorPasswordExpire((MospParams)this.mospParams);
        }
    }

    public void checkPasswordStrength(String userId, String pass) throws MospException {
        Set passwordChecks = this.getPasswordChecks();
        if (passwordChecks.contains(PASS_CHECK_INIT_INVALID)) {
            this.checkInitInvalid(userId, pass);
        }
    }

    public void checkPasswordStrength(String userId) throws MospException {
        String currentPassword = this.getCurrentPassword(userId);
        this.checkPasswordStrength(userId, currentPassword);
    }

    public void checkPasswordChange(String userId, String oldPass, String newPass) throws MospException {
        if (oldPass.equals(newPass)) {
            PfMessageUtility.addErrorPasswordUnchanged((MospParams)this.mospParams);
            return;
        }
        String currentPassword = this.getCurrentPassword(userId);
        if (!currentPassword.equals(oldPass)) {
            PfMessageUtility.addErrorOldPassword((MospParams)this.mospParams);
            return;
        }
    }

    public void checkPasswordChange(String newPass, String confirmPass) {
        if (!confirmPass.equals(newPass)) {
            PfMessageUtility.addErrorNewPassword((MospParams)this.mospParams);
        }
    }

    public String getEncryptedInitialPassword(String userId) throws MospException {
        String initinalPassword = this.getInitialPassword(userId);
        return this.encryptPlain(initinalPassword);
    }

    public String getMinPassword() {
        return this.mospParams.getApplicationProperty(APP_MIN_PASSWORD);
    }

    public String getCharPassword() {
        return this.mospParams.getApplicationProperty(APP_CHAR_PASSWORD);
    }

    public List<String> getAttentionList() {
        ArrayList<String> attentionList = new ArrayList<String>();
        Set passwordChecks = this.getPasswordChecks();
        if (passwordChecks.contains(PASS_CHECK_INIT_INVALID)) {
            attentionList.add(PfMessageUtility.getWarningPasswordInit((MospParams)this.mospParams));
        }
        String minPassword = this.getMinPassword();
        if (!MospUtility.isEmpty((String[])new String[]{minPassword})) {
            attentionList.add(PfMessageUtility.getWarningPasswordMin((MospParams)this.mospParams, (String)minPassword));
        }
        String charPassword = this.getCharPassword();
        if (!MospUtility.isEmpty((String[])new String[]{charPassword})) {
            attentionList.add(PfMessageUtility.getWarningPasswordChar((MospParams)this.mospParams));
        }
        return attentionList;
    }

    protected void checkInitInvalid(String userId, String pass) throws MospException {
        String initialPassword = this.getEncryptedInitialPassword(userId);
        if (initialPassword.equals(pass)) {
            PfMessageUtility.addErrorPasswordInit((MospParams)this.mospParams);
        }
    }

    protected String getCurrentPassword(String userId) throws MospException {
        UserPasswordDtoInterface dto = this.dao.findForInfo(userId);
        if (dto == null) {
            return "";
        }
        return dto.getPassword();
    }

    protected Date getReferenceDate(String userId) throws MospException {
        UserPasswordDtoInterface dto = this.dao.findForInfo(userId);
        if (dto == null) {
            return this.getSystemDate();
        }
        return dto.getChangeDate();
    }

    protected int getPasswordExpiration() throws MospException {
        int expiration = this.master.getAppPropertyInt(APP_PASSWORD_PERIOD);
        if (expiration == 0) {
            expiration = Integer.MAX_VALUE;
        }
        return expiration;
    }

    protected String getInitialPassword(String userId) {
        String initialPassword = this.mospParams.getApplicationProperty(APP_INITIAL_PASSWORD);
        if (MospUtility.isEmpty((String[])new String[]{initialPassword}) || initialPassword.equals(INITIAL_PASS_USER_ID)) {
            return userId;
        }
        return initialPassword;
    }

    protected Set<String> getPasswordChecks() {
        return new LinkedHashSet<String>(MospUtility.asList((String[])this.mospParams.getApplicationProperties(APP_CHECK_PASSWORD)));
    }
}

