/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.message.impl;

import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.message.MessageRegistBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterCheckBeanInterface;
import jp.mosp.platform.dao.message.MessageDaoInterface;
import jp.mosp.platform.dto.message.MessageDtoInterface;
import jp.mosp.platform.dto.message.impl.PftMessageDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class MessageRegistBean
extends PlatformBean
implements MessageRegistBeanInterface {
    protected MessageDaoInterface dao;
    protected PlatformMasterCheckBeanInterface masterCheck;
    protected static final String FORMAT_MESSAGE_NO = "0000000000";

    public void initBean() throws MospException {
        this.dao = (MessageDaoInterface)this.createDaoInstance(MessageDaoInterface.class);
        this.masterCheck = (PlatformMasterCheckBeanInterface)this.createBeanInstance(PlatformMasterCheckBeanInterface.class);
    }

    public MessageDtoInterface getInitDto() {
        return new PftMessageDto();
    }

    public void insert(MessageDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setMessageNo(this.issueSequenceNo(this.dao.getMaxMessageNo(), FORMAT_MESSAGE_NO));
        dto.setPftMessageId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(MessageDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPftMessageId());
        dto.setPftMessageId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(MessageDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPftMessageId());
    }

    protected void checkInsert(MessageDtoInterface dto) throws MospException {
        this.masterCheck.isCheckEmploymentContract(dto.getEmploymentContractCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckPosition(dto.getPositionCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckSection(dto.getSectionCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckWorkPlace(dto.getWorkPlaceCode(), dto.getStartDate(), dto.getEndDate());
    }

    protected void checkUpdate(MessageDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPftMessageId());
        this.masterCheck.isCheckEmploymentContract(dto.getEmploymentContractCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckPosition(dto.getPositionCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckSection(dto.getSectionCode(), dto.getStartDate(), dto.getEndDate());
        this.masterCheck.isCheckWorkPlace(dto.getWorkPlaceCode(), dto.getStartDate(), dto.getEndDate());
    }

    protected void checkDelete(MessageDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPftMessageId());
    }

    protected void validate(MessageDtoInterface dto) {
        if (!this.checkDateOrder(dto.getStartDate(), dto.getEndDate(), true)) {
            PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)PfNameUtility.publishEndDate((MospParams)this.mospParams), (String)PfNameUtility.publishStartDate((MospParams)this.mospParams));
        }
    }
}

