/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.message.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.mail.MailStartTlsBeanInterface;
import jp.mosp.platform.bean.message.MessageMailBeanInterface;
import jp.mosp.platform.bean.message.MessageReferenceBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.message.MessageDtoInterface;

public class MessageMailBean
extends PlatformBean
implements MessageMailBeanInterface {
    protected MailStartTlsBeanInterface mail;
    protected MessageReferenceBeanInterface refer;
    protected HumanSearchBeanInterface humanSearch;
    protected PlatformMasterBeanInterface platformMaster;

    public void initBean() throws MospException {
        this.mail = (MailStartTlsBeanInterface)this.createBeanInstance(MailStartTlsBeanInterface.class);
        this.refer = (MessageReferenceBeanInterface)this.createBeanInstance(MessageReferenceBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBeanInstance(HumanSearchBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
    }

    public int send(String messageNo) throws MospException {
        MessageDtoInterface dto = this.refer.findForKey(messageNo);
        List recipients = this.getMailAddresses(dto);
        this.mail.send(recipients, dto.getMessageTitle(), dto.getMessageBody());
        return recipients.size();
    }

    protected List<String> getMailAddresses(MessageDtoInterface dto) throws MospException {
        ArrayList<String> addresses = new ArrayList<String>();
        Date targetDate = this.getSystemDate();
        int applicationType = dto.getApplicationType();
        if (applicationType == MospUtility.getInt((Object)"0")) {
            this.humanSearch.setTargetDate(targetDate);
            this.humanSearch.setWorkPlaceCode(dto.getWorkPlaceCode());
            this.humanSearch.setSectionCode(dto.getSectionCode());
            this.humanSearch.setPositionCode(dto.getPositionCode());
            this.humanSearch.setEmploymentContractCode(dto.getEmploymentContractCode());
            this.humanSearch.setStateType("presence");
            this.humanSearch.setNeedLowerSection(true);
            this.humanSearch.setNeedConcurrent(true);
            this.humanSearch.setOperationType("1");
            List list = this.humanSearch.search();
            for (HumanDtoInterface humanDto : list) {
                addresses.add(this.platformMaster.getMailAddress(humanDto.getPersonalId()));
            }
        }
        if (applicationType == MospUtility.getInt((Object)"1")) {
            String[] aryPersonalId = this.split(dto.getPersonalId(), ",");
            for (String personalId : aryPersonalId) {
                addresses.add(this.platformMaster.getMailAddress(this.platformMaster.getMailAddress(personalId)));
            }
        }
        return addresses;
    }
}

