/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.mail.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.LogUtility;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.mail.MailStartTlsBeanInterface;
import jp.mosp.platform.utils.MailTemplateUtility;
import jp.mosp.platform.utils.PfMessageUtility;

public class MailStartTlsBean
extends PlatformBean
implements MailStartTlsBeanInterface {
    protected static final String SMTP_AUTH = "true";
    protected static final int SMTP_PORT = 587;
    protected static final String SMTP_ATT_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    protected static final String SMTP_STARTTLS_ENABLE = "true";
    protected static final String SMTP_ATT_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    protected static final String SMTP_STARTTLS_REQUIRED = "true";
    protected static final String APP_LOG_LEVEL_MAIL = "LogLevelMail";
    protected static final String SEPARATOR_ADDRESS = "@";

    public void initBean() {
    }

    public boolean sendAndIsExceptionOccurred(String recipient, String subject, String templatePath, Object dto) throws MospException {
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(recipient);
        String text = this.makeText(templatePath, dto);
        return this.sendAndIsExceptionOccurred(recipients, subject, text, false);
    }

    public void send(String recipient, String subject, String appTemplate, Object dto) throws MospException {
        ArrayList<String> recipients = new ArrayList<String>();
        recipients.add(recipient);
        String text = this.makeText(this.mospParams.getApplicationProperty(appTemplate), dto);
        this.sendAndIsExceptionOccurred(recipients, subject, text, true);
    }

    public void send(List<String> recipients, String subject, String text) {
        this.sendAndIsExceptionOccurred(recipients, subject, text, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendAndIsExceptionOccurred(List<String> recipients, String subject, String text, boolean isErrNecessary) {
        boolean isExceptionOccurred = false;
        MospUtility.removeEmpty(recipients);
        if (MospUtility.isEmpty(recipients)) {
            return isExceptionOccurred;
        }
        Address[] addresses = this.makeAddresses(recipients, isErrNecessary);
        Optional transmitter = this.makeAddress(this.getTransmitter(), this.getTransmitterName(), isErrNecessary);
        Properties props = this.makeProperties();
        Session session = Session.getInstance((Properties)props);
        MimeMessage mimeMessage = new MimeMessage(session);
        Transport transport = null;
        try {
            mimeMessage.setFrom((Address)transmitter.get());
            mimeMessage.setRecipients(Message.RecipientType.TO, addresses);
            mimeMessage.setSubject(subject, "UTF-8");
            mimeMessage.setText(text, "UTF-8");
            mimeMessage.setSentDate(this.getSystemTime());
            transport = session.getTransport("smtp");
            transport.connect(this.getSmtpHost(), this.getSmtpUser(), this.getSmtpPass());
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            this.outputSendLog(recipients);
        }
        catch (Throwable t) {
            LogUtility.error((MospParams)this.mospParams, (Throwable)t);
            this.addErrorSendMailFailed(isErrNecessary);
            isExceptionOccurred = true;
        }
        finally {
            try {
                if (transport != null) {
                    transport.close();
                }
            }
            catch (Throwable t) {
                LogUtility.error((MospParams)this.mospParams, (Throwable)t);
            }
        }
        return isExceptionOccurred;
    }

    protected Properties makeProperties() {
        Properties props = new Properties();
        props.put("mail.smtp.port", String.valueOf(this.getSmtpPort()));
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.connectiontimeout", "60000");
        props.put("mail.smtp.timeout", "60000");
        props.put(SMTP_ATT_STARTTLS_ENABLE, "true");
        props.put(SMTP_ATT_STARTTLS_REQUIRED, "true");
        String[] address = MospUtility.split((String)this.getTransmitter(), (String)SEPARATOR_ADDRESS);
        if (address.length > 1) {
            props.put("mail.user", address[0]);
            props.put("mail.host", address[1]);
        }
        return props;
    }

    protected Address[] makeAddresses(List<String> recipients, boolean isErrNecessary) {
        ArrayList list = new ArrayList();
        for (String recipient : recipients) {
            Optional address = this.makeAddress(recipient, isErrNecessary);
            address.ifPresent(a -> list.add(a));
        }
        return list.toArray(new Address[list.size()]);
    }

    protected Optional<Address> makeAddress(String address, boolean isErrNecessary) {
        try {
            return Optional.of(new InternetAddress(address));
        }
        catch (AddressException e) {
            LogUtility.error((MospParams)this.mospParams, (Throwable)e);
            this.addErrorAddressInvalid(address, isErrNecessary);
            return Optional.ofNullable(null);
        }
    }

    protected Optional<Address> makeAddress(String address, String personal, boolean isErrNecessary) {
        try {
            return Optional.of(new InternetAddress(address, personal));
        }
        catch (Exception e) {
            LogUtility.error((MospParams)this.mospParams, (Throwable)e);
            this.addErrorAddressInvalid(address, isErrNecessary);
            return Optional.ofNullable(null);
        }
    }

    protected String makeText(String templatePath, Object dto) throws MospException {
        return MailTemplateUtility.makeText((MospParams)this.mospParams, (String)templatePath, (Object)dto);
    }

    protected String getSmtpHost() {
        return this.mospParams.getApplicationProperty("MailHost");
    }

    protected int getSmtpPort() {
        return this.mospParams.getApplicationProperty("MailPort", 587);
    }

    protected String getSmtpUser() {
        return this.mospParams.getApplicationProperty("MailUserName");
    }

    protected String getSmtpPass() {
        return this.mospParams.getApplicationProperty("MailPassword");
    }

    protected String getTransmitter() {
        return this.mospParams.getApplicationProperty("MailAddress");
    }

    protected String getTransmitterName() {
        return this.mospParams.getApplicationProperty("MailPersonal");
    }

    protected void outputSendLog(List<String> recipients) {
        int level = this.mospParams.getApplicationProperty(APP_LOG_LEVEL_MAIL, 0);
        if (level == 0) {
            return;
        }
        LogUtility.log((MospParams)this.mospParams, (int)level, (String)this.makeMessage(recipients, "\u3078\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3057\u307e\u3057\u305f\u3002"));
    }

    protected String makeMessage(List<String> recipients, String message) {
        StringBuilder sb = new StringBuilder();
        sb.append(MospUtility.toSeparatedString(recipients, (String)","));
        sb.append(message);
        return sb.toString();
    }

    protected void addErrorAddressInvalid(String address, boolean isErrNecessary) {
        if (!isErrNecessary) {
            return;
        }
        PfMessageUtility.addErrorInvalidMailAddresss((MospParams)this.mospParams, (String)address);
    }

    protected void addErrorSendMailFailed(boolean isErrNecessary) {
        if (!isErrNecessary) {
            return;
        }
        MessageUtility.addErrorSendMailFailed((MospParams)this.mospParams);
    }
}

