/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.RetirementRegistBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.bean.system.UserAccountRegistBeanInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanRetirementDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class RetirementRegistBean
extends PlatformHumanBean
implements RetirementRegistBeanInterface {
    protected static final int LEN_RETIREMENT_DETAIL = 120;
    protected RetirementDaoInterface dao;
    protected UserAccountRegistBeanInterface accountRegist;

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (RetirementDaoInterface)this.createDaoInstance(RetirementDaoInterface.class);
        this.accountRegist = (UserAccountRegistBeanInterface)this.createBeanInstance(UserAccountRegistBeanInterface.class);
    }

    public RetirementDtoInterface getInitDto() {
        return new PfaHumanRetirementDto();
    }

    public void regist(RetirementDtoInterface dto) throws MospException {
        if (dto.getPfaHumanRetirementId() == 0L) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
        this.accountRegist.checkAfterRegist();
    }

    public void delete(RetirementDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanRetirementId());
        this.accountRegist.checkAfterRegist();
    }

    public void validate(RetirementDtoInterface dto, Integer row) {
        this.checkRequired((Object)dto.getRetirementDate(), PfNameUtility.retirementDate((MospParams)this.mospParams), row);
        this.checkLength(dto.getRetirementDetail(), 120, PfNameUtility.retirementReasonDetail((MospParams)this.mospParams), row);
        this.checkRetirementReason(dto.getRetirementReason(), row);
    }

    public void insert(RetirementDtoInterface dto) throws MospException {
        this.validate(dto, null);
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaHumanRetirementId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(RetirementDtoInterface dto) throws MospException {
        this.validate(dto, null);
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanRetirementId());
        dto.setPfaHumanRetirementId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(RetirementDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForInfo(dto.getPersonalId()));
        this.checkEmployee(dto);
    }

    protected void checkUpdate(RetirementDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanRetirementId());
        this.checkEmployee(dto);
    }

    protected void checkDelete(RetirementDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanRetirementId());
    }

    protected void checkEmployee(RetirementDtoInterface dto) throws MospException {
        EntranceDaoInterface entranceDao = (EntranceDaoInterface)this.createDaoInstance(EntranceDaoInterface.class);
        EntranceDtoInterface entranceDto = entranceDao.findForInfo(dto.getPersonalId());
        if (entranceDto == null || entranceDto.getEntranceDate().after(dto.getRetirementDate())) {
            PfMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
        }
    }

    protected void checkRetirementReason(String retirementReason, Integer row) {
        String[][] aryReason;
        for (String[] reason : aryReason = this.mospParams.getProperties().getCodeArray("Retirement", false)) {
            if (!reason[0].equals(retirementReason)) continue;
            return;
        }
        PfMessageUtility.addErrorNotExist((MospParams)this.mospParams, (String)PfNameUtility.retirementReason((MospParams)this.mospParams), (String)retirementReason, (Integer)row);
    }
}

