/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.Date;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.PhoneRegistBeanInterface;
import jp.mosp.platform.dao.human.PhoneDaoInterface;
import jp.mosp.platform.dto.human.PhoneDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaPhoneDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class PhoneRegistBean
extends PlatformBean
implements PhoneRegistBeanInterface {
    protected static final int LEN_HOLDER_ID = 20;
    protected static final int LEN_PHONE_TYPE = 10;
    protected PhoneDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (PhoneDaoInterface)this.createDaoInstance(PhoneDaoInterface.class);
    }

    public PhoneDtoInterface getInitDto() {
        return new PfaPhoneDto();
    }

    public void registPersonalPhone(PhoneDtoInterface dto) throws MospException {
        dto.setPhoneType("1");
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        PhoneDtoInterface duplicateDto = this.dao.findForKey(dto.getHolderId(), dto.getPhoneType(), dto.getActivateDate());
        if (duplicateDto != null) {
            this.logicalDelete((BaseDaoInterface)this.dao, duplicateDto.getPfaPhoneId());
        }
        dto.setPfaPhoneId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void deletePhone(String holderId, Date activateDate, String requestType) throws MospException {
        Set set = this.dao.findForRequestType(holderId, activateDate, requestType);
        for (PhoneDtoInterface dto : set) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaPhoneId());
        }
    }

    public void validate(PhoneDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getHolderId(), PfNameUtility.id((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getPhoneType(), PfNameUtility.phoneType((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getActivateDate(), PfNameUtility.activateDate((MospParams)this.mospParams), row);
        this.checkLength(dto.getHolderId(), 20, PfNameUtility.id((MospParams)this.mospParams), row);
        this.checkLength(dto.getPhoneType(), 10, PfNameUtility.phoneType((MospParams)this.mospParams), row);
        this.checkDeleteFlag(dto.getDeleteFlag(), row);
        this.checkOtherPhoneExist(dto, row);
    }

    protected void checkOtherPhoneExist(PhoneDtoInterface dto, Integer row) throws MospException {
        Date activateDate = dto.getActivateDate();
        PhoneDtoInterface duplicateDto = this.dao.findForKey(dto.getHolderId(), dto.getPhoneType(), activateDate);
        if (duplicateDto == null) {
            return;
        }
        if (duplicateDto.getRequestType().equals(dto.getRequestType())) {
            return;
        }
        PfMessageUtility.addErrorOtherPhoneExist((MospParams)this.mospParams, (Date)activateDate, (Integer)row);
    }
}

