/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.bean.human.HumanSubordinateBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanSearchBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.utils.PlatformUtility;

public class HumanSubordinateBean
extends HumanSearchBean
implements HumanSubordinateBeanInterface {
    protected static final String TYPE_APPLICANTS_APPROVE = "1";
    protected static final String TYPE_SUBORDINATE = "2";
    protected PlatformMasterBeanInterface platformMaster;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected String humanType;

    public void initBean() throws MospException {
        super.initBean();
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
    }

    public Set<String> getSubordinateIds() throws MospException {
        this.setSubordinateParams();
        this.setEmployeeCodeType("forward");
        return this.getPersonalIdSet();
    }

    public Set<HumanDtoInterface> getSubordinates(int workflowType) throws MospException {
        return new LinkedHashSet<HumanDtoInterface>(this.getHumanSubordinates(this.humanType, workflowType));
    }

    protected List<HumanDtoInterface> getHumanSubordinates(String humanType, int workflowType) throws MospException {
        List humanList;
        List<HumanDtoInterface> resultList = new ArrayList();
        this.setEmployeeCodeType("forward");
        this.setSubordinateParams();
        if (MospUtility.isEmpty((String[])new String[]{humanType})) {
            resultList = this.search();
            this.setOperationType(null);
            humanList = this.search();
            List approvalList = this.getApprovableForApplicantList(humanList, this.targetDate, workflowType);
            Set resultSet = PlatformUtility.getPersonalIdSet(resultList);
            for (HumanDtoInterface humanDto : approvalList) {
                if (resultSet.contains(humanDto.getPersonalId())) continue;
                resultList.add(humanDto);
            }
        }
        if (MospUtility.isEqual((Object)humanType, (Object)TYPE_APPLICANTS_APPROVE)) {
            this.setOperationType(null);
            humanList = this.search();
            resultList = this.getApprovableForApplicantList(humanList, this.targetDate, workflowType);
        }
        if (MospUtility.isEqual((Object)humanType, (Object)TYPE_SUBORDINATE)) {
            resultList = this.search();
        }
        return resultList;
    }

    protected void setSubordinateParams() {
        this.setStateType("presence");
        this.setNeedLowerSection(true);
        this.setNeedConcurrent(true);
        this.setOperationType(TYPE_APPLICANTS_APPROVE);
    }

    protected List<HumanDtoInterface> getApprovableForApplicantList(List<HumanDtoInterface> humanList, Date targetDate, int workflowType) throws MospException {
        if (RoleUtility.isSuper((MospParams)this.mospParams)) {
            return humanList;
        }
        ArrayList<HumanDtoInterface> list = new ArrayList<HumanDtoInterface>();
        Set routeSet = this.workflowIntegrate.getApproverRouteSet(this.mospParams.getUser().getPersonalId(), targetDate);
        for (HumanDtoInterface humanDto : humanList) {
            if (!this.isApprovable(humanDto, routeSet, targetDate, workflowType)) continue;
            list.add(humanDto);
        }
        return list;
    }

    protected boolean isApprovable(HumanDtoInterface humanDto, Set<String> routeSet, Date targetDate, int workflowType) throws MospException {
        RouteApplicationDtoInterface dto = this.platformMaster.getRouteApplication(humanDto, targetDate, workflowType);
        if (dto == null) {
            return false;
        }
        return routeSet.contains(dto.getRouteCode());
    }

    public void setHumanType(String humanType) {
        this.humanType = humanType;
    }
}

