/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistAddonBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.impl.PfmHumanDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class HumanRegistBean
extends PlatformHumanBean
implements HumanRegistBeanInterface {
    public static final int LEN_EMPLOYEE_CODE = 10;
    public static final int LEN_EMPLOYEE_NAME = 10;
    protected HumanDaoInterface dao;
    protected static final String FORMAT_PERSONAL_ID = "P000000000";
    protected HumanReferenceBeanInterface humanReference;
    protected List<HumanRegistAddonBeanInterface> addonBeans;
    protected static final String CODE_KEY_ADDONS = "HumanRegistAddons";

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanDaoInterface)this.createDaoInstance(HumanDaoInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBeanInstance(HumanReferenceBeanInterface.class);
    }

    public HumanDtoInterface getInitDto() {
        return new PfmHumanDto();
    }

    public void insert(HumanDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPersonalId(this.getPersonalId());
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmHumanId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        for (HumanRegistAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.insert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void add(HumanDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmHumanId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        for (HumanRegistAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.add(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(HumanDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmHumanId());
        dto.setPfmHumanId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        for (HumanRegistAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.update(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void delete(HumanDtoInterface dto) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmHumanId());
        for (HumanRegistAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.delete(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkInsert(HumanDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPersonalId()));
        this.checkEmployeeCodeDuplicate(dto.getPersonalId(), dto.getEmployeeCode());
    }

    protected void checkAdd(HumanDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate()));
        this.checkEmployeeCodeDuplicate(dto.getPersonalId(), dto.getEmployeeCode());
    }

    protected void checkUpdate(HumanDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmHumanId());
        this.checkEmployeeCodeDuplicate(dto.getPersonalId(), dto.getEmployeeCode());
    }

    protected void checkEmployeeCodeDuplicate(String personalId, String employeeCode) throws MospException {
        List list = this.dao.findForEmployeeCode(employeeCode);
        for (HumanDtoInterface dto : list) {
            if (dto.getPersonalId().equals(personalId)) continue;
            PfMessageUtility.addErrorEmployeeCodeExist((MospParams)this.mospParams, (String)employeeCode);
            return;
        }
    }

    protected String getPersonalId() throws MospException {
        long seq = this.dao.nextPersonalId();
        return this.issueSequenceNo(seq, FORMAT_PERSONAL_ID);
    }

    protected void validate(HumanDtoInterface dto, Integer row) throws MospException {
        List list = this.humanReference.getHistory(dto.getPersonalId());
        Date startDate = dto.getActivateDate();
        Date endDate = this.getLastDate(dto.getActivateDate(), list);
        this.checkRequired((Object)dto.getEmployeeCode(), PfNameUtility.employeeCode((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getActivateDate(), PfNameUtility.activateDate((MospParams)this.mospParams), row);
        this.checkRequired((Object)dto.getLastName(), PfNameUtility.lastName((MospParams)this.mospParams), row);
        this.checkLength(dto.getEmployeeCode(), 10, PfNameUtility.employeeCode((MospParams)this.mospParams), row);
        this.checkLength(dto.getLastName(), 10, PfNameUtility.lastName((MospParams)this.mospParams), row);
        this.checkLength(dto.getFirstName(), 10, PfNameUtility.firstName((MospParams)this.mospParams), row);
        this.checkLength(dto.getLastKana(), 10, PfNameUtility.lastNameKana((MospParams)this.mospParams), row);
        this.checkLength(dto.getFirstKana(), 10, PfNameUtility.firstNameKana((MospParams)this.mospParams), row);
        this.checkTypeCode(dto.getEmployeeCode(), PfNameUtility.employeeCode((MospParams)this.mospParams), row);
        this.checkTypeKana(dto.getLastKana(), PfNameUtility.lastNameKana((MospParams)this.mospParams), row);
        this.checkTypeKana(dto.getFirstKana(), PfNameUtility.firstNameKana((MospParams)this.mospParams), row);
        this.checkWorkPlace(dto.getWorkPlaceCode(), startDate, endDate, row);
        this.checkEmploymentContract(dto.getEmploymentContractCode(), startDate, endDate, row);
        this.checkSection(dto.getSectionCode(), startDate, endDate, row);
        this.checkPosition(dto.getPositionCode(), startDate, endDate, row);
    }

    protected Date getLastDate(Date targetDate, List<HumanDtoInterface> list) throws MospException {
        Date lastDate = null;
        for (HumanDtoInterface dto : list) {
            if (targetDate.compareTo(dto.getActivateDate()) >= 0 || dto.getActivateDate() == null) continue;
            lastDate = DateUtility.addDay((Date)dto.getActivateDate(), (int)-1);
            break;
        }
        return lastDate;
    }

    protected List<HumanRegistAddonBeanInterface> getAddonBeans() throws MospException {
        if (this.addonBeans == null) {
            this.makeAddonBeans();
        }
        return this.addonBeans;
    }

    protected void makeAddonBeans() throws MospException {
        this.addonBeans = new ArrayList();
        for (String[] addon : MospUtility.getCodeArray((MospParams)this.mospParams, (String)CODE_KEY_ADDONS, (boolean)false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            HumanRegistAddonBeanInterface bean = (HumanRegistAddonBeanInterface)this.createBean(addonBean);
            this.addonBeans.add(bean);
        }
    }
}

