/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PlatformUtility;

public class HumanReferenceBean
extends PlatformHumanBean
implements HumanReferenceBeanInterface {
    protected HumanDaoInterface humanDao;

    public void initBean() throws MospException {
        super.initBean();
        this.humanDao = (HumanDaoInterface)this.createDaoInstance(HumanDaoInterface.class);
    }

    public HumanDtoInterface findForKey(long id) throws MospException {
        BaseDto dto = this.findForKey((BaseDaoInterface)this.humanDao, id, false);
        if (dto != null) {
            return (HumanDtoInterface)dto;
        }
        return null;
    }

    public HumanDtoInterface getHumanInfo(String personalId, Date targetDate) throws MospException {
        return super.getHumanInfo(personalId, targetDate);
    }

    public HumanDtoInterface getHumanInfoForEmployeeCode(String employeeCode, Date targetDate) throws MospException {
        return this.humanDao.findForEmployeeCode(employeeCode, targetDate);
    }

    public List<HumanDtoInterface> getHistory(String personalId) throws MospException {
        return this.humanDao.findForHistory(personalId);
    }

    public List<HumanDtoInterface> getHumanList(Date targetDate) throws MospException {
        return this.humanDao.findForActivateDate(targetDate);
    }

    public String getPersonalId(String employeeCode, Date targetDate) throws MospException {
        HumanDtoInterface dto = this.getHumanInfoForEmployeeCode(employeeCode, targetDate);
        if (dto == null) {
            PfMessageUtility.addErrorEmployeeHistoryNotExist((MospParams)this.mospParams, (Date)targetDate, (String)employeeCode);
            return "";
        }
        return dto.getPersonalId();
    }

    public String getEmployeeCode(String personalId, Date targetDate) throws MospException {
        HumanDtoInterface dto = this.getHumanInfo(personalId, targetDate);
        if (dto != null) {
            return dto.getEmployeeCode();
        }
        return "";
    }

    public String getHumanName(String personalId, Date targetDate) throws MospException {
        return this.getHumanName(this.getHumanInfo(personalId, targetDate));
    }

    public List<String> getPersonalIdList(List<String> employeeCodeList, Date targetDate) throws MospException {
        ArrayList<String> personalIdList = new ArrayList<String>();
        for (String employeeCode : employeeCodeList) {
            personalIdList.add(this.getPersonalId(employeeCode, targetDate));
        }
        return personalIdList;
    }

    public List<String> getEmployeeCodeList(List<String> personalIdList, Date targetDate) throws MospException {
        ArrayList<String> employeeCodeList = new ArrayList<String>();
        for (String personalId : personalIdList) {
            employeeCodeList.add(this.getEmployeeCode(personalId, targetDate));
        }
        return employeeCodeList;
    }

    public List<String> getHumanNameList(List<String> personalIdList, Date targetDate) throws MospException {
        ArrayList<String> humanNameList = new ArrayList<String>();
        for (String personalId : personalIdList) {
            humanNameList.add(this.getHumanName(personalId, targetDate));
        }
        return humanNameList;
    }

    public String getPersonalIds(String employeeCodes, Date targetDate) throws MospException {
        return this.toSeparatedString(this.getPersonalIdList(employeeCodes, targetDate), ",");
    }

    public List<String> getPersonalIdList(String employeeCodes, Date targetDate) throws MospException {
        List employeeCodeList = this.asList(employeeCodes, ",");
        return this.getPersonalIdList(employeeCodeList, targetDate);
    }

    public String getEmployeeCodes(String personalIds, Date targetDate) throws MospException {
        List personalIdList = this.asList(personalIds, ",");
        List employeeCodeList = this.getEmployeeCodeList(personalIdList, targetDate);
        return this.toSeparatedString(employeeCodeList, ", ");
    }

    public String getHumanNames(List<String> personalIdList, Date targetDate) throws MospException {
        List humanNameList = this.getHumanNameList(personalIdList, targetDate);
        return this.toSeparatedString(humanNameList, ", ");
    }

    public String getHumanNames(String personalIds, Date targetDate) throws MospException {
        return this.getHumanNames(this.asList(personalIds, ","), targetDate);
    }

    public void addHuman(List<HumanDtoInterface> list, String personalId, Date targetDate) throws MospException {
        if (PlatformUtility.getPersonalIdSet(list).contains(personalId)) {
            return;
        }
        list.add(this.getHumanInfo(personalId, targetDate));
    }
}

