/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.property.ConventionProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.xml.ItemProperty;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanGeneralBean;
import jp.mosp.platform.dao.human.HumanHistoryDaoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;

public class HumanHistoryReferenceBean
extends HumanGeneralBean
implements HumanHistoryReferenceBeanInterface {
    protected HumanHistoryDaoInterface dao;
    protected LinkedHashMap<String, Map<String, String>> historyHumanInfoMap;
    protected Map<String, String> historyMap;
    protected LinkedHashMap<String, Long> recordsMap;
    protected LinkedHashMap<String, LinkedHashMap<String, Long>> historyReferenceInfoMap;
    protected List<TableItemProperty> tableItemList;

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanHistoryDaoInterface)this.createDaoInstance(HumanHistoryDaoInterface.class);
    }

    public void setCommounInfo(String division, String viewKey) {
        this.conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default");
        this.tableItemList = this.getTableItemList(division, viewKey);
        this.historyHumanInfoMap = new LinkedHashMap();
        this.historyMap = new HashMap();
        this.recordsMap = new LinkedHashMap();
        this.historyReferenceInfoMap = new LinkedHashMap();
    }

    public LinkedHashMap<String, Map<String, String>> getHistoryMapInfo(String division, String viewKey, String personalId, Date activeDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                HumanHistoryDtoInterface dto = this.findForKey(personalId, itemName, activeDate);
                if (dto == null) {
                    this.historyMap.put(itemName, "");
                    continue;
                }
                String itemKey = itemKeys[i];
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKey);
                String pulldownValue = this.getPulldownValue(itemProperty, activeDate, dto.getHumanItemValue(), itemName, false);
                if (!pulldownValue.isEmpty()) {
                    this.historyMap.put(itemName, pulldownValue);
                    if (i != itemNames.length - 1) continue;
                    this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dto.getActivateDate()), this.historyMap);
                    continue;
                }
                this.historyMap.put(itemName, dto.getHumanItemValue());
                this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dto.getActivateDate()), this.historyMap);
            }
        }
        return this.historyHumanInfoMap;
    }

    public void getHistoryRecordMapInfo(String division, String viewKey, String personalId, Date activeDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                HumanHistoryDtoInterface dto;
                String itemName = itemNames[i];
                if (itemName.isEmpty() || (dto = this.findForKey(personalId, itemName, activeDate)) == null) continue;
                String itemKey = itemKeys[i];
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKey);
                String pulldownValue = this.getPulldownValue(itemProperty, activeDate, dto.getHumanItemValue(), itemName, false);
                if (!pulldownValue.isEmpty()) {
                    dto.setHumanItemValue(pulldownValue);
                }
                this.historyMap.put(itemName, dto.getHumanItemValue());
                this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dto.getActivateDate()), this.historyMap);
                this.recordsMap.put(itemName, dto.getPfaHumanHistoryId());
            }
        }
    }

    public Map<String, String> getBeforeHumanHistoryMapInfo(String division, String viewKey, String personalId, Date activeDate, Date targetDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                String itemKey;
                ItemProperty itemProperty;
                String pulldownValue;
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                HumanHistoryDtoInterface dto = this.findForInfoItems(personalId, itemName, activeDate);
                if (dto == null) {
                    List humanList = this.findForHistory(personalId, itemName);
                    if (humanList.isEmpty()) {
                        this.historyMap.put(itemName, "");
                        continue;
                    }
                    dto = (HumanHistoryDtoInterface)humanList.get(0);
                }
                if (!(pulldownValue = this.getPulldownValue(itemProperty = this.conventionProperty.getItem(itemKey = itemKeys[i]), activeDate, dto.getHumanItemValue(), itemName, false)).isEmpty()) {
                    this.historyMap.put(itemName, pulldownValue);
                    continue;
                }
                this.historyMap.put(itemName, dto.getHumanItemValue());
            }
        }
        return this.historyMap;
    }

    public LinkedHashMap<String, Map<String, String>> getHumanHistoryMapInfo(String division, String viewKey, String personalId, Date activeDate, Date targetDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            String[] labelKeys = tableItem.getLabelKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                String itemKey = itemKeys[i];
                String labelKey = labelKeys[i];
                if (itemName.isEmpty()) continue;
                String humanItemValue = "";
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKey);
                HumanHistoryDtoInterface dto = this.findForInfoItems(personalId, itemName, activeDate);
                if (dto == null) continue;
                this.historyMap = (Map)this.historyHumanInfoMap.get(DateUtility.getStringDate((Date)dto.getActivateDate()));
                if (this.historyMap == null) {
                    this.historyMap = new HashMap();
                }
                String dateTypeValue = this.getSeparateTxtItemHistoryValue(personalId, itemName, itemProperty, activeDate, targetDate, labelKey);
                this.historyMap.put(itemName, dateTypeValue);
                humanItemValue = dateTypeValue;
                String pulldownValue = this.getPulldownValue(itemProperty, activeDate, dto.getHumanItemValue(), itemName, true);
                if (!pulldownValue.isEmpty()) {
                    this.historyMap.put(itemName, pulldownValue);
                    humanItemValue = pulldownValue;
                }
                if (humanItemValue.isEmpty()) {
                    this.historyMap.put(itemName, dto.getHumanItemValue());
                }
                this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dto.getActivateDate()), this.historyMap);
            }
        }
        return this.historyHumanInfoMap;
    }

    public void getActiveDateHistoryMapInfo(String division, String viewKey, String personalId, Date targetDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        HashSet activeSet = this.getActiveDateList(this.tableItemList, personalId);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemKeys = tableItem.getItemKeys();
            String[] itemNames = tableItem.getItemNames();
            String[] labelKeys = tableItem.getLabelKeys();
            for (Date activeDate : activeSet) {
                for (int i = 0; i < itemNames.length; ++i) {
                    this.historyMap = (Map)this.historyHumanInfoMap.get(DateUtility.getStringDate((Date)activeDate));
                    this.recordsMap = (LinkedHashMap)this.historyReferenceInfoMap.get(DateUtility.getStringDate((Date)activeDate));
                    if (this.historyMap == null) {
                        this.historyMap = new HashMap();
                    }
                    if (this.recordsMap == null) {
                        this.recordsMap = new LinkedHashMap();
                    }
                    HumanHistoryDtoInterface dto = this.findForInfoItems(personalId, itemNames[i], activeDate);
                    ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
                    String humanItemValue = "";
                    humanItemValue = this.getSeparateTxtItemHistoryValue(personalId, itemNames[i], itemProperty, activeDate, targetDate, labelKeys[i]);
                    if (dto == null) {
                        this.historyMap.put(itemNames[i], humanItemValue);
                        continue;
                    }
                    if (humanItemValue.isEmpty()) {
                        humanItemValue = this.getPulldownValue(itemProperty, activeDate, dto.getHumanItemValue(), itemNames[i], true);
                    }
                    this.historyMap.put(itemNames[i], humanItemValue);
                    if (humanItemValue.isEmpty()) {
                        this.historyMap.put(dto.getHumanItemType(), dto.getHumanItemValue());
                    }
                    this.recordsMap.put(dto.getHumanItemType(), dto.getPfaHumanHistoryId());
                    this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)activeDate), this.historyMap);
                    this.historyReferenceInfoMap.put(DateUtility.getStringDate((Date)activeDate), this.recordsMap);
                }
            }
        }
    }

    public void getHistoryListData(String division, String viewKey) throws MospException {
        this.conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default");
        this.tableItemList = this.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemKeys = tableItem.getItemKeys();
            String[] itemNames = tableItem.getItemNames();
            for (Map.Entry set : this.historyHumanInfoMap.entrySet()) {
                for (int i = 0; i < itemNames.length; ++i) {
                    ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
                    if (itemProperty == null || itemProperty.getDataType() == null) continue;
                    Map map = (Map)set.getValue();
                    Map valueMap = (Map)set.getValue();
                    String value = "";
                    String dataType = itemProperty.getDataType();
                    if (dataType.equals("Date") || dataType.equals("Age")) {
                        Date date = DateUtility.getDate((String)((String)map.get(itemNames[i] + "Year")), (String)((String)map.get(itemNames[i] + "Month")), (String)((String)map.get(itemNames[i] + "Day")));
                        value = this.getFormatDateAge(date, itemProperty, DateUtility.getDate((String)((String)set.getKey())));
                    }
                    if (dataType.equals("Phone")) {
                        value = this.getFormatPhone((String)map.get(itemNames[i] + "Area"), (String)map.get(itemNames[i] + "Local"), (String)map.get(itemNames[i] + "Subscriber"), itemProperty.getFormat());
                    }
                    String[] itemSepaleteNames = MospUtility.split((String)itemNames[i], (String)",");
                    String[] aryReplaceText = new String[itemSepaleteNames.length];
                    int idx = 0;
                    for (String replaceText : itemSepaleteNames) {
                        if (!map.containsKey(replaceText)) continue;
                        if (dataType.equals("Concatenate")) {
                            value = value + (map.get(replaceText) == null ? "" : (String)map.get(replaceText));
                        }
                        if (!dataType.equals("Format")) continue;
                        String string = aryReplaceText[idx++] = map.get(replaceText) == null ? "" : (String)map.get(replaceText);
                        if (itemSepaleteNames.length != idx) continue;
                        value = this.getReplaceFormat(itemProperty.getFormat(), aryReplaceText);
                    }
                    valueMap.put(itemNames[i], value);
                    this.historyHumanInfoMap.put(set.getKey(), valueMap);
                }
            }
        }
    }

    public String getHistoryItemValue(String division, String viewKey, String personalId, Date targetDate, String tableItemKey, boolean isPulldownName) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            if (!tableItem.getKey().equals(tableItemKey)) continue;
            String[] itemNames = tableItem.getItemNames();
            String[] labelKeys = tableItem.getLabelKeys();
            int i = 0;
            String[] itemKeys = tableItem.getItemKeys();
            if (i >= itemKeys.length) continue;
            HumanHistoryDtoInterface dto = this.findForInfoItems(personalId, itemNames[i], targetDate);
            if (dto == null) {
                return "";
            }
            Date activeDate = dto.getActivateDate();
            ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
            if (itemKeys[i].equals("ActivateDate")) {
                dto = this.findForInfo(personalId, itemNames[i], activeDate);
                if (dto == null) {
                    return "";
                }
                return this.getStringDate(dto.getActivateDate());
            }
            String dateTypeValue = this.getSeparateTxtItemHistoryValue(personalId, itemNames[i], itemProperty, activeDate, targetDate, labelKeys[i]);
            if (!dateTypeValue.isEmpty()) {
                return dateTypeValue;
            }
            dto = this.findForInfo(personalId, itemNames[i], activeDate);
            if (dto == null) {
                return "";
            }
            String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemNames[i], isPulldownName);
            if (!pulldownValue.isEmpty()) {
                return pulldownValue;
            }
            return dto.getHumanItemValue();
        }
        return "";
    }

    public List<HumanHistoryDtoInterface> findForHistory(String personalId, String humanItemType) throws MospException {
        return this.dao.findForHistory(personalId, humanItemType);
    }

    public HumanHistoryDtoInterface findForInfo(String personalId, String humanItemType, Date targetDate) throws MospException {
        return this.dao.findForInfo(personalId, humanItemType, targetDate);
    }

    private HumanHistoryDtoInterface findForInfoItems(String personalId, String humanItemType, Date targetDate) throws MospException {
        String[] aryItemName;
        HumanHistoryDtoInterface dto = this.dao.findForInfo(personalId, humanItemType, targetDate);
        if (dto == null) {
            dto = this.findForInfo(personalId, humanItemType + "Year", targetDate);
        }
        if (dto == null) {
            dto = this.findForInfo(personalId, humanItemType + "Area", targetDate);
        }
        if (dto == null && (aryItemName = MospUtility.split((String)humanItemType, (String)",")).length != 0) {
            dto = this.findForInfo(personalId, aryItemName[0], targetDate);
        }
        return dto;
    }

    public HumanHistoryDtoInterface findForKey(String personalId, String humanItemType, Date activateDate) throws MospException {
        return this.dao.findForKey(personalId, humanItemType, activateDate);
    }

    public HashSet<Date> getActiveDateList(List<TableItemProperty> tableItemList, String personalId) throws MospException {
        ArrayList<Date> activeDateList = new ArrayList<Date>();
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                String[] itemNameSplit;
                for (String item : itemNameSplit = MospUtility.split((String)itemName, (String)",")) {
                    String[] aryItemName;
                    List valueList = this.findForHistory(personalId, item);
                    if (valueList.isEmpty()) {
                        valueList = this.findForHistory(personalId, item + "Year");
                    }
                    if (valueList.isEmpty()) {
                        valueList = this.findForHistory(personalId, item + "Area");
                    }
                    if (valueList.isEmpty() && (aryItemName = MospUtility.split((String)item, (String)",")).length != 0) {
                        valueList = this.findForHistory(personalId, aryItemName[0]);
                    }
                    for (HumanHistoryDtoInterface dto : valueList) {
                        activeDateList.add(dto.getActivateDate());
                    }
                }
            }
        }
        HashSet<Date> activeDateSet = new HashSet<Date>();
        activeDateSet.addAll(activeDateList);
        return activeDateSet;
    }

    public String[] getArrayActiveDate(LinkedHashMap<String, Map<String, String>> activeDateHistoryMapInfo) {
        ArrayList<String> activeList = new ArrayList<String>(activeDateHistoryMapInfo.keySet());
        String[] arrayActiveDate = new String[activeList.size()];
        if (activeList.isEmpty()) {
            return arrayActiveDate;
        }
        Collections.sort(activeList);
        for (int i = 0; i < activeList.size(); ++i) {
            arrayActiveDate[i] = (String)activeList.get(activeList.size() - i - 1);
        }
        return arrayActiveDate;
    }

    public LinkedHashMap<String, Long> getRecordsMap() {
        return this.recordsMap;
    }

    public LinkedHashMap<String, Map<String, String>> getHistoryHumanInfoMap() {
        return this.historyHumanInfoMap;
    }

    public LinkedHashMap<String, LinkedHashMap<String, Long>> getHistoryReferenceInfoMap() {
        return this.historyReferenceInfoMap;
    }
}

