/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospMethodInvoker;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.CheckConfigProperty;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.human.ExtraHumanGeneralCheckBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralCheckBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dto.human.HumanArrayDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanNormalDtoInterface;

public class HumanGeneralCheckBean
extends PlatformHumanBean
implements HumanGeneralCheckBeanInterface {
    private String INPUT_CHECK_BEAN = "jp.mosp.platform.utils.InputCheckUtility";
    private static String KEY_PROPERTY_SEPARATOR_SINGLE = "'";
    private static String KEY_PROPERTY_SEPARATOR_DOUBLE = "\"";
    private static String KEY_PROPERTY_SEPARATOR_PLUS = "\\+";
    private static String KEY_PROPERTY_CONCAT_YEAR = "Year";
    private static String KEY_PROPERTY_CONCAT_MONTH = "Month";
    private static String KEY_PROPERTY_CONCAT_DAY = "Day";
    private static String CLASS_CONCAT_PERIOD = ".";
    private static String KEY_PROPERTY_ROW_COUNT = "RowCount";
    protected Map<Integer, LinkedHashMap<String, String>> generalCheckMap;
    protected HumanGeneralBeanInterface humanGeneral;

    public void initBean() throws MospException {
        super.initBean();
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBeanInstance(HumanGeneralBeanInterface.class);
    }

    public void validate(String division, String viewKey) throws MospException {
        CheckConfigProperty checkConfig = this.getCheckConfig(division);
        if (checkConfig == null) {
            return;
        }
        this.executeCheckMethod(checkConfig);
        for (String beanName : checkConfig.getExtraCheckList()) {
            ExtraHumanGeneralCheckBeanInterface bean = (ExtraHumanGeneralCheckBeanInterface)this.createBean(beanName);
            bean.extraValidate(division, viewKey);
        }
    }

    public void validate(String division, List<? extends PlatformDtoInterface> listPlatFormDto) throws MospException {
        CheckConfigProperty checkConfig = this.getCheckConfig(division);
        this.generalCheckMap = new LinkedHashMap();
        if (checkConfig == null) {
            return;
        }
        if (listPlatFormDto == null) {
            return;
        }
        this.getInputCheckMap(division, listPlatFormDto);
        if (this.generalCheckMap.isEmpty()) {
            return;
        }
        this.executeCheckMethod(checkConfig);
        for (String beanName : checkConfig.getExtraCheckList()) {
            ExtraHumanGeneralCheckBeanInterface bean = (ExtraHumanGeneralCheckBeanInterface)this.createBean(beanName);
            bean.extraValidate(division, listPlatFormDto);
        }
    }

    private CheckConfigProperty getCheckConfig(String division) {
        ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(division);
        return viewConfig.getCheckConfig(division);
    }

    private void getInputCheckMap(String division, List<? extends PlatformDtoInterface> listPlatFormDto) {
        String key = "";
        String value = "";
        String viewKey = "";
        int idx = 0;
        String firstKey = "";
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < listPlatFormDto.size(); ++i) {
            HumanNormalDtoInterface divisionDto;
            key = "";
            value = "";
            if (listPlatFormDto.get(i) instanceof HumanNormalDtoInterface) {
                divisionDto = (HumanNormalDtoInterface)listPlatFormDto.get(i);
                key = divisionDto.getHumanItemType();
                value = divisionDto.getHumanItemValue();
                viewKey = "NormalCard";
            }
            if (listPlatFormDto.get(i) instanceof HumanArrayDtoInterface) {
                divisionDto = (HumanArrayDtoInterface)listPlatFormDto.get(i);
                key = divisionDto.getHumanItemType();
                value = divisionDto.getHumanItemValue();
                viewKey = "ArrayCard";
            }
            if (listPlatFormDto.get(i) instanceof HumanHistoryDtoInterface) {
                divisionDto = (HumanHistoryDtoInterface)listPlatFormDto.get(i);
                key = divisionDto.getHumanItemType();
                value = divisionDto.getHumanItemValue();
                viewKey = "HistoryCard";
            }
            if (firstKey.equals(key)) {
                this.generalCheckMap.put(idx, map);
                map = new LinkedHashMap();
                ++idx;
            }
            if (i == 0) {
                firstKey = key;
            }
            List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
            for (TableItemProperty tableItem : tableItemList) {
                String[] itemNames;
                for (String itemName : itemNames = tableItem.getItemNames()) {
                    if (itemName.isEmpty() || !itemName.equals(key)) continue;
                    map.put(key, value);
                }
            }
            if (listPlatFormDto.size() > i + 1) continue;
            this.generalCheckMap.put(idx, map);
        }
    }

    private void executeCheckMethod(CheckConfigProperty checkConfig) throws MospException {
        List list = checkConfig.getCheckItem();
        for (LinkedHashMap map : list) {
            for (Map.Entry entry : map.entrySet()) {
                String methodName = this.INPUT_CHECK_BEAN + CLASS_CONCAT_PERIOD + (String)entry.getKey();
                Method method = MospMethodInvoker.getMethod((String)methodName);
                if (method == null) continue;
                if (this.generalCheckMap != null) {
                    int idx = 0;
                    for (Integer keySet : this.generalCheckMap.keySet()) {
                        String[] paramArray = this.getCheckParam((String)entry.getKey(), (String)entry.getValue(), keySet, Integer.valueOf(idx));
                        MospMethodInvoker.invokeStaticMethod((String)methodName, (MospParams)this.mospParams, (String[])paramArray);
                        ++idx;
                    }
                    continue;
                }
                String[] paramArray = this.getCheckParam((String)entry.getKey(), (String)entry.getValue(), null, null);
                MospMethodInvoker.invokeStaticMethod((String)methodName, (MospParams)this.mospParams, (String[])paramArray);
            }
        }
    }

    private String[] getCheckParam(String key, String values, Integer humanImportKey, Integer rowIndex) throws MospException {
        String[] param = MospUtility.split((String)values, (String)",");
        String[] paramArray = new String[param.length];
        for (int i = 0; i < param.length; ++i) {
            String paramValue = "";
            paramArray[i] = paramValue = this.getParamValue(param[i], humanImportKey, rowIndex);
        }
        return paramArray;
    }

    private String getParamValue(String key, Integer humanImportKey, Integer rowIndex) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        String value = this.getParamsNameForXml(key);
        if (!value.isEmpty()) {
            if (value.equals(KEY_PROPERTY_ROW_COUNT)) {
                return rowIndex == null ? null : String.valueOf(rowIndex);
            }
            return value;
        }
        if (this.generalCheckMap != null) {
            LinkedHashMap map = (LinkedHashMap)this.generalCheckMap.get(humanImportKey);
            for (String requestParam : map.keySet()) {
                if (!requestParam.startsWith(key)) continue;
                list.add(requestParam);
            }
            if (list.size() == 3) {
                String year = (String)map.get(key + KEY_PROPERTY_CONCAT_YEAR);
                String month = (String)map.get(key + KEY_PROPERTY_CONCAT_MONTH);
                String day = (String)map.get(key + KEY_PROPERTY_CONCAT_DAY);
                return year == null ? "" : DateUtility.getStringDate((Date)DateUtility.getDate((String)year, (String)month, (String)day));
            }
            return (String)map.get(key);
        }
        for (Map.Entry requestParam : this.mospParams.getRequestParamsMap().entrySet()) {
            if (!((String)requestParam.getKey()).startsWith(key)) continue;
            list.add((String)requestParam.getKey());
        }
        if (list.size() == 3) {
            String year = this.mospParams.getRequestParam(key + KEY_PROPERTY_CONCAT_YEAR);
            String month = this.mospParams.getRequestParam(key + KEY_PROPERTY_CONCAT_MONTH);
            String day = this.mospParams.getRequestParam(key + KEY_PROPERTY_CONCAT_DAY);
            return year == null ? "" : DateUtility.getStringDate((Date)DateUtility.getDate((String)year, (String)month, (String)day));
        }
        return this.mospParams.getRequestParam(key);
    }

    private String getParamsNameForXml(String key) {
        if (-1 < key.indexOf(KEY_PROPERTY_SEPARATOR_SINGLE)) {
            return key.replace(KEY_PROPERTY_SEPARATOR_SINGLE, "");
        }
        if (-1 < key.indexOf(KEY_PROPERTY_SEPARATOR_DOUBLE)) {
            String newkey = key.replace(KEY_PROPERTY_SEPARATOR_DOUBLE, "");
            if (newkey.equals(KEY_PROPERTY_ROW_COUNT)) {
                return newkey;
            }
            String[] arrayKey = MospUtility.split((String)newkey, (String)KEY_PROPERTY_SEPARATOR_PLUS);
            StringBuffer sb = new StringBuffer();
            for (String strs : arrayKey) {
                if (strs == null || strs.isEmpty()) continue;
                sb.append(NameUtility.getName((MospParams)this.mospParams, (String)strs));
            }
            return sb.toString();
        }
        return "";
    }
}

