/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ConventionProperty;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.framework.xml.ItemProperty;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.framework.xml.ViewProperty;
import jp.mosp.framework.xml.ViewTableProperty;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.bean.system.NamingReferenceBeanInterface;
import jp.mosp.platform.dao.human.HumanArrayDaoInterface;
import jp.mosp.platform.dao.human.HumanHistoryDaoInterface;
import jp.mosp.platform.dao.human.HumanNormalDaoInterface;
import jp.mosp.platform.dto.human.HumanArrayDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.dto.human.HumanNormalDtoInterface;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;

public class HumanGeneralBean
extends PlatformHumanBean
implements HumanGeneralBeanInterface {
    protected NamingReferenceBeanInterface namingReference;
    protected HumanNormalDaoInterface normalDao;
    protected HumanHistoryDaoInterface historyDao;
    protected HumanArrayDaoInterface arrayDao;
    public static final String KEY_FORMAT_AGE = "Age";
    public static final String KEY_FORMAT_DATE = "Date";
    public static final String KEY_FORMAT_YEAR = "Year";
    public static final String KEY_FORMAT_MONTH = "Month";
    public static final String KEY_FORMAT_DAY = "Day";
    public static final String KEY_FORMAT_PHONE = "Phone";
    public static final String KEY_FORMAT_PHONE_1 = "Area";
    public static final String KEY_FORMAT_PHONE_2 = "Local";
    public static final String KEY_FORMAT_PHONE_3 = "Subscriber";
    public static final String KEY_FORMAT_BINARY = "Binary";
    public static final String KEY_CONCATENATED_LABEL = "Concatenate";
    public static final String KEY_FORMAT = "Format";
    protected ConventionProperty conventionProperty;
    protected ItemProperty labelItemProperty;
    protected String labelDateType = null;
    protected String labelFormat = null;

    public void initBean() throws MospException {
        super.initBean();
        this.normalDao = (HumanNormalDaoInterface)this.createDaoInstance(HumanNormalDaoInterface.class);
        this.historyDao = (HumanHistoryDaoInterface)this.createDaoInstance(HumanHistoryDaoInterface.class);
        this.arrayDao = (HumanArrayDaoInterface)this.createDaoInstance(HumanArrayDaoInterface.class);
        this.namingReference = (NamingReferenceBeanInterface)this.createBeanInstance(NamingReferenceBeanInterface.class);
    }

    public String[][] getHumanGeneralItemPulldown(ItemProperty itemProperty, Date activeDate) throws MospException {
        if (itemProperty == null) {
            return null;
        }
        String codeKey = itemProperty.getCodeKey();
        boolean isNeedSpace = itemProperty.isNeedSpace();
        if (codeKey != null && !codeKey.isEmpty()) {
            return this.mospParams.getProperties().getCodeArray(codeKey, isNeedSpace);
        }
        String namingKey = itemProperty.getNamingKey();
        if (namingKey != null) {
            return this.namingReference.getCodedSelectArray(namingKey, activeDate, isNeedSpace);
        }
        return null;
    }

    public Map<String, String[][]> getHumanGeneralPulldown(String division, String viewKey, Date activeDate) throws MospException {
        if (viewKey == null) {
            return null;
        }
        ConventionProperty conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default");
        HashMap<String, String[][]> pulldownMap = new HashMap<String, String[][]>();
        List tableItemList = this.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemKeys = tableItem.getItemKeys();
            String[] itemNames = tableItem.getItemNames();
            for (int i = 0; i < itemKeys.length; ++i) {
                ItemProperty itemProperty;
                String[][] pulldown;
                if (itemKeys[i].isEmpty() || (pulldown = this.getHumanGeneralItemPulldown(itemProperty = conventionProperty.getItem(itemKeys[i]), activeDate)) == null) continue;
                pulldownMap.put(itemNames[i], pulldown);
            }
        }
        return pulldownMap;
    }

    public String getPulldownValue(ItemProperty itemProperty, Date activeDate, String value, String itemName, boolean isPulldownName) throws MospException {
        if (itemProperty == null) {
            return "";
        }
        String[][] pulldown = this.getHumanGeneralItemPulldown(itemProperty, activeDate);
        if (pulldown != null) {
            String codeKey = itemProperty.getCodeKey();
            if (codeKey != null && !codeKey.isEmpty()) {
                if (isPulldownName) {
                    return MospUtility.getCodeName((String)value, (String[][])pulldown);
                }
                return value;
            }
            String namingType = itemProperty.getNamingKey();
            if (namingType != null && !namingType.isEmpty()) {
                if (isPulldownName) {
                    return this.namingReference.getNamingItemName(namingType, value, activeDate);
                }
                return value;
            }
        }
        return "";
    }

    public List<TableItemProperty> getTableItemList(String division, String viewKey) {
        ViewConfigProperty viewConfig = (ViewConfigProperty)this.mospParams.getProperties().getViewConfigProperties().get(division);
        ViewProperty viewProperty = viewConfig.getView(viewKey);
        if (viewProperty == null) {
            return new ArrayList<TableItemProperty>();
        }
        String[] viewTableKeys = viewProperty.getViewTableKeys();
        ArrayList<TableItemProperty> tableItemList = new ArrayList<TableItemProperty>();
        for (String viewTableKey : viewTableKeys) {
            ViewTableProperty viewTableProperty = viewConfig.getViewTable(viewTableKey);
            tableItemList.addAll(viewTableProperty.getTableItem());
        }
        return tableItemList;
    }

    public Map<String, String[][]> getInputActiveDateGeneralPulldown(String division, String viewKey) {
        if (viewKey == null) {
            return null;
        }
        HashMap<String, String[][]> pulldownMap = new HashMap<String, String[][]>();
        List tableItemList = this.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemKeys = tableItem.getItemKeys();
            String[] itemNames = tableItem.getItemNames();
            for (int i = 0; i < itemKeys.length; ++i) {
                if (itemKeys[i].isEmpty()) continue;
                pulldownMap.put(itemNames[i], PlatformUtility.getInputActivateDatePulldown((MospParams)this.mospParams));
            }
        }
        return pulldownMap;
    }

    public Date humanNormalDate(String itemName, String personalId) throws MospException {
        HumanNormalDtoInterface normalYearDto = this.normalDao.findForInfo(itemName + KEY_FORMAT_YEAR, personalId);
        HumanNormalDtoInterface normalMonthDto = this.normalDao.findForInfo(itemName + KEY_FORMAT_MONTH, personalId);
        HumanNormalDtoInterface normalDayDto = this.normalDao.findForInfo(itemName + KEY_FORMAT_DAY, personalId);
        if (normalYearDto == null || normalMonthDto == null || normalDayDto == null) {
            return null;
        }
        return DateUtility.getDate((String)normalYearDto.getHumanItemValue(), (String)normalMonthDto.getHumanItemValue(), (String)normalDayDto.getHumanItemValue());
    }

    public Date humanHistoryDate(String itemName, String personalId, Date activeDate) throws MospException {
        HumanHistoryDtoInterface historyYearDto = this.historyDao.findForInfo(personalId, itemName + KEY_FORMAT_YEAR, activeDate);
        HumanHistoryDtoInterface historyMonthDto = this.historyDao.findForInfo(personalId, itemName + KEY_FORMAT_MONTH, activeDate);
        HumanHistoryDtoInterface historyDayDto = this.historyDao.findForInfo(personalId, itemName + KEY_FORMAT_DAY, activeDate);
        if (historyYearDto == null || historyMonthDto == null || historyDayDto == null) {
            return null;
        }
        return DateUtility.getDate((String)historyYearDto.getHumanItemValue(), (String)historyMonthDto.getHumanItemValue(), (String)historyDayDto.getHumanItemValue());
    }

    public Date humanArrayDate(String itemName, String personalId, String rowId) throws MospException {
        HumanArrayDtoInterface arrayYearDto = this.arrayDao.findForKey(personalId, itemName + KEY_FORMAT_YEAR, MospUtility.getInt((Object)rowId));
        HumanArrayDtoInterface arrayMonthDto = this.arrayDao.findForKey(personalId, itemName + KEY_FORMAT_MONTH, MospUtility.getInt((Object)rowId));
        HumanArrayDtoInterface arrayDayDto = this.arrayDao.findForKey(personalId, itemName + KEY_FORMAT_DAY, MospUtility.getInt((Object)rowId));
        if (arrayYearDto == null || arrayMonthDto == null || arrayDayDto == null) {
            return null;
        }
        return DateUtility.getDate((String)arrayYearDto.getHumanItemValue(), (String)arrayMonthDto.getHumanItemValue(), (String)arrayDayDto.getHumanItemValue());
    }

    protected void setCommounInfo(String labelKey) {
        this.conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default");
        this.labelItemProperty = this.conventionProperty.getItem(labelKey);
        this.labelDateType = this.labelItemProperty.getDataType();
        this.labelFormat = this.labelItemProperty.getFormat();
    }

    public String getSeparateTxtItemNormalValue(String personalId, String itemName, ItemProperty itemProperty, Date targetDate, String labelKey) throws MospException {
        if (itemProperty == null) {
            return "";
        }
        String dataType = itemProperty.getDataType();
        if (dataType == null) {
            return "";
        }
        String format = itemProperty.getFormat();
        if (dataType.equals(KEY_FORMAT_DATE) || dataType.equals(KEY_FORMAT_AGE)) {
            return this.getNormalFormatDateAge(personalId, itemName, itemProperty, targetDate);
        }
        if (dataType.equals(KEY_FORMAT_PHONE)) {
            return this.getNormalFormatPhone(personalId, itemName, format);
        }
        String[] itemNames = MospUtility.split((String)itemName, (String)",");
        String[] labelKeys = MospUtility.split((String)labelKey, (String)",");
        if (dataType.equals(KEY_CONCATENATED_LABEL)) {
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < itemNames.length; ++i) {
                HumanNormalDtoInterface itemDto;
                this.setCommounInfo(labelKeys[i]);
                if (this.labelDateType != null) {
                    String formatDate = this.getNormalFormatDateAge(personalId, itemNames[i], this.labelItemProperty, targetDate);
                    if (!formatDate.equals("")) {
                        value.append(formatDate);
                        continue;
                    }
                    String formatPhone = this.getNormalFormatPhone(personalId, itemNames[i], this.labelFormat);
                    if (!formatPhone.equals("")) {
                        value.append(formatPhone);
                        continue;
                    }
                }
                if ((itemDto = this.normalDao.findForInfo(itemNames[i], personalId)) == null) continue;
                String pulldownValue = this.getPulldownValue(this.labelItemProperty, targetDate, itemDto.getHumanItemValue(), itemNames[i], true);
                if (!pulldownValue.isEmpty()) {
                    value.append(pulldownValue);
                    continue;
                }
                value.append(itemDto.getHumanItemValue());
            }
            return value.toString();
        }
        if (dataType.equals(KEY_FORMAT)) {
            String[] rep = new String[itemNames.length];
            for (int i = 0; i < itemNames.length; ++i) {
                HumanNormalDtoInterface itemDto;
                this.setCommounInfo(labelKeys[i]);
                if (this.labelDateType != null) {
                    String formatDate = this.getNormalFormatDateAge(personalId, itemNames[i], this.labelItemProperty, targetDate);
                    if (!formatDate.equals("")) {
                        rep[i] = formatDate;
                        continue;
                    }
                    String formatPhone = this.getNormalFormatPhone(personalId, itemNames[i], this.labelFormat);
                    if (!formatPhone.equals("")) {
                        rep[i] = formatPhone;
                        continue;
                    }
                }
                if ((itemDto = this.normalDao.findForInfo(itemNames[i], personalId)) != null) {
                    String pulldownValue = this.getPulldownValue(this.labelItemProperty, targetDate, itemDto.getHumanItemValue(), itemNames[i], true);
                    if (!pulldownValue.isEmpty()) {
                        rep[i] = pulldownValue;
                        continue;
                    }
                    rep[i] = itemDto.getHumanItemValue();
                    continue;
                }
                rep[i] = "";
            }
            if (format != null) {
                return this.getReplaceFormat(format, rep);
            }
            return format;
        }
        return "";
    }

    public String getSeparateTxtItemHistoryValue(String personalId, String itemName, ItemProperty itemProperty, Date activeDate, Date targetDate, String labelKey) throws MospException {
        if (itemProperty == null) {
            return "";
        }
        String dataType = itemProperty.getDataType();
        if (dataType == null) {
            return "";
        }
        String format = itemProperty.getFormat();
        if (dataType.equals(KEY_FORMAT_DATE) || dataType.equals(KEY_FORMAT_AGE)) {
            return this.getHistoryFormatDateAge(personalId, itemName, itemProperty, activeDate, targetDate);
        }
        if (dataType.equals(KEY_FORMAT_PHONE)) {
            return this.getHistoryFormatPhone(personalId, itemName, activeDate, format);
        }
        String[] itemNames = MospUtility.split((String)itemName, (String)",");
        String[] labelKeys = MospUtility.split((String)labelKey, (String)",");
        if (dataType.equals(KEY_CONCATENATED_LABEL)) {
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < itemNames.length; ++i) {
                HumanHistoryDtoInterface itemDto;
                this.setCommounInfo(labelKeys[i]);
                if (this.labelDateType != null) {
                    String formatDate = this.getHistoryFormatDateAge(personalId, itemNames[i], this.labelItemProperty, activeDate, targetDate);
                    if (!formatDate.equals("")) {
                        value.append(formatDate);
                        continue;
                    }
                    String formatPhone = this.getHistoryFormatPhone(personalId, itemNames[i], activeDate, this.labelFormat);
                    if (!formatPhone.equals("")) {
                        value.append(formatPhone);
                        continue;
                    }
                }
                if ((itemDto = this.historyDao.findForInfo(personalId, itemNames[i], activeDate)) == null) continue;
                String pulldownValue = this.getPulldownValue(this.labelItemProperty, targetDate, itemDto.getHumanItemValue(), itemNames[i], true);
                if (!pulldownValue.isEmpty()) {
                    value.append(pulldownValue);
                    continue;
                }
                value.append(itemDto.getHumanItemValue());
            }
            return value.toString();
        }
        if (dataType.equals(KEY_FORMAT)) {
            String[] rep = new String[itemNames.length];
            for (int i = 0; i < itemNames.length; ++i) {
                HumanHistoryDtoInterface itemDto;
                this.setCommounInfo(labelKeys[i]);
                if (this.labelDateType != null) {
                    String formatDate = this.getHistoryFormatDateAge(personalId, itemNames[i], this.labelItemProperty, activeDate, targetDate);
                    if (!formatDate.equals("")) {
                        rep[i] = formatDate;
                        continue;
                    }
                    String formatPhone = this.getHistoryFormatPhone(personalId, itemNames[i], activeDate, this.labelFormat);
                    if (!formatPhone.equals("")) {
                        rep[i] = formatPhone;
                        continue;
                    }
                }
                if ((itemDto = this.historyDao.findForInfo(personalId, itemNames[i], activeDate)) != null) {
                    String pulldownValue = this.getPulldownValue(this.labelItemProperty, targetDate, itemDto.getHumanItemValue(), itemNames[i], true);
                    if (!pulldownValue.isEmpty()) {
                        rep[i] = pulldownValue;
                        continue;
                    }
                    rep[i] = itemDto.getHumanItemValue();
                    continue;
                }
                rep[i] = "";
            }
            if (format != null) {
                return this.getReplaceFormat(format, rep);
            }
            return format;
        }
        return "";
    }

    public String getSeparateTxtItemArrayValue(String personalId, String itemName, ItemProperty itemProperty, String rowId, Date targetDate, String labelKey) throws MospException {
        if (itemProperty == null) {
            return "";
        }
        String dataType = itemProperty.getDataType();
        if (dataType == null) {
            return "";
        }
        String format = itemProperty.getFormat();
        if (dataType.equals(KEY_FORMAT_DATE) || dataType.equals(KEY_FORMAT_AGE)) {
            return this.getArrayFormatDateAge(personalId, itemName, itemProperty, rowId, targetDate);
        }
        if (dataType.equals(KEY_FORMAT_PHONE)) {
            return this.getArrayFormatPhone(personalId, itemName, rowId, format);
        }
        String[] itemNames = MospUtility.split((String)itemName, (String)",");
        String[] labelKeys = MospUtility.split((String)labelKey, (String)",");
        if (dataType.equals(KEY_CONCATENATED_LABEL)) {
            StringBuilder value = new StringBuilder();
            for (int i = 0; i < itemNames.length; ++i) {
                HumanArrayDtoInterface itemDto;
                this.setCommounInfo(labelKeys[i]);
                if (this.labelDateType != null) {
                    String formatDate = this.getArrayFormatDateAge(personalId, itemNames[i], this.labelItemProperty, rowId, targetDate);
                    if (!formatDate.equals("")) {
                        value.append(formatDate);
                        continue;
                    }
                    String formatPhone = this.getArrayFormatPhone(personalId, itemNames[i], rowId, this.labelFormat);
                    if (!formatPhone.equals("")) {
                        value.append(formatPhone);
                        continue;
                    }
                }
                if ((itemDto = this.arrayDao.findForKey(personalId, itemNames[i], MospUtility.getInt((Object)rowId))) == null) continue;
                String pulldownValue = this.getPulldownValue(this.labelItemProperty, targetDate, itemDto.getHumanItemValue(), itemNames[i], true);
                if (!pulldownValue.isEmpty()) {
                    value.append(pulldownValue);
                    continue;
                }
                value.append(itemDto.getHumanItemValue());
            }
            return value.toString();
        }
        if (dataType.equals(KEY_FORMAT)) {
            String[] rep = new String[itemNames.length];
            for (int i = 0; i < itemNames.length; ++i) {
                HumanArrayDtoInterface itemDto = this.arrayDao.findForKey(personalId, itemNames[i], MospUtility.getInt((Object)rowId));
                if (itemDto != null) {
                    String pulldownValue;
                    this.setCommounInfo(labelKeys[i]);
                    if (this.labelDateType != null) {
                        String formatDate = this.getArrayFormatDateAge(personalId, itemNames[i], this.labelItemProperty, rowId, targetDate);
                        if (!formatDate.equals("")) {
                            rep[i] = formatDate;
                            continue;
                        }
                        String formatPhone = this.getArrayFormatPhone(personalId, itemNames[i], rowId, this.labelFormat);
                        if (!formatPhone.equals("")) {
                            rep[i] = formatPhone;
                            continue;
                        }
                    }
                    if (!(pulldownValue = this.getPulldownValue(this.labelItemProperty, targetDate, itemDto.getHumanItemValue(), itemNames[i], true)).isEmpty()) {
                        rep[i] = pulldownValue;
                        continue;
                    }
                    rep[i] = itemDto.getHumanItemValue();
                    continue;
                }
                rep[i] = "";
            }
            if (format != null) {
                return this.getReplaceFormat(format, rep);
            }
            return format;
        }
        return "";
    }

    protected String getReplaceFormat(String format, String[] rep) {
        if (!this.isFormatValue(rep)) {
            return "";
        }
        for (int i = 0; i < rep.length; ++i) {
            if (rep[i].isEmpty()) {
                rep[i] = "";
            }
            format = format.replaceAll("%" + String.valueOf(i + 1) + "%", rep[i]);
        }
        return format;
    }

    protected boolean isFormatValue(String[] rep) {
        for (String element : rep) {
            if (element.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getNormalFormatDateAge(String personalId, String itemName, ItemProperty itemProperty, Date targetDate) throws MospException {
        Date date = this.humanNormalDate(itemName, personalId);
        return this.getFormatDateAge(date, itemProperty, targetDate);
    }

    public String getHistoryFormatDateAge(String personalId, String itemName, ItemProperty itemProperty, Date activeDate, Date targetDate) throws MospException {
        Date date = this.humanHistoryDate(itemName, personalId, activeDate);
        return this.getFormatDateAge(date, itemProperty, targetDate);
    }

    public String getArrayFormatDateAge(String personalId, String itemName, ItemProperty itemProperty, String rowId, Date targetDate) throws MospException {
        Date date = this.humanArrayDate(itemName, personalId, rowId);
        return this.getFormatDateAge(date, itemProperty, targetDate);
    }

    public String getFormatDateAge(Date formatDate, ItemProperty itemProperty, Date targetDate) {
        if (MospUtility.isEmpty((Object[])new Object[]{formatDate})) {
            return "";
        }
        String dateType = itemProperty.getDataType();
        String format = itemProperty.getFormat();
        if (dateType.equals(KEY_FORMAT_DATE)) {
            return DateUtility.getStringDate((Date)formatDate, (String)format);
        }
        if (dateType.equals(KEY_FORMAT_AGE)) {
            StringBuilder sb = new StringBuilder(DateUtility.getStringDate((Date)formatDate, (String)format));
            return sb.append(HumanUtility.getHumanOlder((Date)formatDate, (Date)targetDate, (MospParams)this.mospParams)).toString();
        }
        return "";
    }

    public String getNormalFormatPhone(String personalId, String itemName, String format) throws MospException {
        HumanNormalDtoInterface normalAreaDto = this.normalDao.findForInfo(itemName + KEY_FORMAT_PHONE_1, personalId);
        HumanNormalDtoInterface normalLocalDto = this.normalDao.findForInfo(itemName + KEY_FORMAT_PHONE_2, personalId);
        HumanNormalDtoInterface normalSubscriberDto = this.normalDao.findForInfo(itemName + KEY_FORMAT_PHONE_3, personalId);
        String area = normalAreaDto == null ? "" : normalAreaDto.getHumanItemValue();
        String local = normalLocalDto == null ? "" : normalLocalDto.getHumanItemValue();
        String subscriber = normalSubscriberDto == null ? "" : normalSubscriberDto.getHumanItemValue();
        return this.getFormatPhone(area, local, subscriber, format);
    }

    public String getHistoryFormatPhone(String personalId, String itemName, Date activeDate, String format) throws MospException {
        HumanHistoryDtoInterface historyAreaDto = this.historyDao.findForInfo(personalId, itemName + KEY_FORMAT_PHONE_1, activeDate);
        HumanHistoryDtoInterface historyLocalDto = this.historyDao.findForInfo(personalId, itemName + KEY_FORMAT_PHONE_2, activeDate);
        HumanHistoryDtoInterface historySubscriberDto = this.historyDao.findForInfo(personalId, itemName + KEY_FORMAT_PHONE_3, activeDate);
        String area = historyAreaDto == null ? "" : historyAreaDto.getHumanItemValue();
        String local = historyLocalDto == null ? "" : historyLocalDto.getHumanItemValue();
        String subscriber = historySubscriberDto == null ? "" : historySubscriberDto.getHumanItemValue();
        return this.getFormatPhone(area, local, subscriber, format);
    }

    public String getArrayFormatPhone(String personalId, String itemName, String rowId, String format) throws MospException {
        HumanArrayDtoInterface arrayAreaDto = this.arrayDao.findForKey(personalId, itemName + KEY_FORMAT_PHONE_1, MospUtility.getInt((Object)rowId));
        HumanArrayDtoInterface arrayLocalDto = this.arrayDao.findForKey(personalId, itemName + KEY_FORMAT_PHONE_2, MospUtility.getInt((Object)rowId));
        HumanArrayDtoInterface arraySubscriberDto = this.arrayDao.findForKey(personalId, itemName + KEY_FORMAT_PHONE_3, MospUtility.getInt((Object)rowId));
        String area = arrayAreaDto == null ? "" : arrayAreaDto.getHumanItemValue();
        String local = arrayLocalDto == null ? "" : arrayLocalDto.getHumanItemValue();
        String subscriber = arraySubscriberDto == null ? "" : arraySubscriberDto.getHumanItemValue();
        return this.getFormatPhone(area, local, subscriber, format);
    }

    public String getFormatPhone(String parmArea, String parmLocal, String parmSubscriber, String format) throws MospException {
        String area = this.getFormatHyphenValue(parmArea);
        String local = this.getFormatHyphenValue(parmLocal);
        String subscriber = parmSubscriber;
        if (format.equals("%1%-%2%-%3%")) {
            return area + local + subscriber;
        }
        return "";
    }

    public String getFormatHyphenValue(String value) {
        if (!MospUtility.isEmpty((String[])new String[]{value})) {
            return value + PfNameUtility.hyphen((MospParams)this.mospParams);
        }
        return "";
    }

    public String[][] getPulldownForHumanExportImport(String division, String viewKey) {
        List tableItemList = this.getTableItemList(division, viewKey);
        if (tableItemList == null || tableItemList.isEmpty()) {
            return new String[0][];
        }
        String[] tableItemKeys = new String[tableItemList.size()];
        for (int i = 0; i < tableItemList.size(); ++i) {
            String key;
            tableItemKeys[i] = key = ((TableItemProperty)tableItemList.get(i)).getKey();
        }
        int nameSize = tableItemKeys.length;
        String[][] array = new String[nameSize][2];
        for (int i = 0; i < nameSize; ++i) {
            StringBuilder value = new StringBuilder(division);
            value.append(",").append(tableItemKeys[i]);
            StringBuilder name = new StringBuilder(NameUtility.getName((MospParams)this.mospParams, (String)tableItemKeys[i]));
            name.append(PfNameUtility.parentheses((MospParams)this.mospParams, (String)NameUtility.getName((MospParams)this.mospParams, (String)division)));
            array[i][0] = value.toString();
            array[i][1] = name.toString();
        }
        return array;
    }
}

