/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanBinaryNormalRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.HumanBinaryNormalDaoInterface;
import jp.mosp.platform.dto.human.HumanBinaryNormalDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanBinaryNormalDto;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;

public class HumanBinaryNormalRegistBean
extends PlatformHumanBean
implements HumanBinaryNormalRegistBeanInterface {
    protected HumanBinaryNormalDaoInterface dao;
    protected HumanGeneralBeanInterface humanGeneral;
    protected HumanReferenceBeanInterface humanReference;

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanBinaryNormalDaoInterface)this.createDaoInstance(HumanBinaryNormalDaoInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBeanInstance(HumanGeneralBeanInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBeanInstance(HumanReferenceBeanInterface.class);
    }

    public HumanBinaryNormalDtoInterface getInitDto() {
        return new PfaHumanBinaryNormalDto();
    }

    public void delete(HumanBinaryNormalDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryNormalId());
    }

    public void deleteDeadInputItem(Set<String> divisions, String viewKey) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (String division : divisions) {
            List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
            for (TableItemProperty tableItem : tableItemList) {
                String[] itemNames;
                for (String itemName : itemNames = tableItem.getItemNames()) {
                    list.add(itemName);
                }
            }
        }
        if (list.isEmpty()) {
            return;
        }
        List listDeleteItem = this.dao.findForInfoNotIn(list);
        for (HumanBinaryNormalDtoInterface dto : listDeleteItem) {
            this.delete(dto);
        }
    }

    public void insert(HumanBinaryNormalDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaHumanBinaryNormalId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(HumanBinaryNormalDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryNormalId());
        dto.setPfaHumanBinaryNormalId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkUpdate(HumanBinaryNormalDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryNormalId());
    }

    public void validate(HumanBinaryNormalDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getHumanItemType(), dto.getHumanItemType(), row);
        this.checkLength(dto.getFileName(), 50, PfNameUtility.fileName((MospParams)this.mospParams));
        Date entranceDate = this.getEntranceDate(dto.getPersonalId());
        if (entranceDate == null) {
            PfMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
            return;
        }
    }

    protected void checkDelete(HumanBinaryNormalDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanBinaryNormalId());
    }

    protected void checkInsert(HumanBinaryNormalDtoInterface dto) throws MospException {
        List humanList = this.humanReference.getHistory(dto.getPersonalId());
        if (humanList.isEmpty()) {
            PfMessageUtility.addErrorPersonalBasisInfoNotExist((MospParams)this.mospParams);
        }
    }
}

